/*
 * Decompiled with CFR 0.152.
 */
package org.usfirst.frc.team5800.robot.base.commands.drive;

import org.usfirst.frc.team5800.robot.OI;
import org.usfirst.frc.team5800.robot.base.commands.CommandBase;
import org.usfirst.frc.team5800.robot.superclasses.Command5800;

public class CommandDrive
extends Command5800 {
    public static boolean chassiInversion = false;
    public static boolean changeController = false;
    double speed;
    double arcadeSpeed;
    double arcadeRotation;
    public static final double minR = 0.4;
    public static final double difR = 0.5;

    public CommandDrive() {
        super(driver);
    }

    @Override
    protected void execute() {
        if (changeController) {
            this.arcadeSpeed = chassiInversion ? -0.9 * OI.axis_j_Y.get() : 0.9 * OI.axis_j_Y.get();
            this.arcadeRotation = -0.9 * OI.axis_j_Rotate.get();
            this.arcadeDrive(this.arcadeSpeed, this.arcadeRotation);
        } else {
            this.arcadeSpeed = chassiInversion ? -0.9 * OI.axis_d_LY.get() : 0.9 * OI.axis_d_LY.get();
            this.arcadeRotation = -OI.axis_d_RX.get();
            this.arcadeDrive(this.arcadeSpeed, this.arcadeRotation);
        }
    }

    @Override
    protected boolean isDone() {
        return false;
    }

    public void arcadeDrive(double sp, double rotation) {
        double mod = 0.4 + 0.5 * Math.pow(1.0 - Math.abs(sp), 2.0);
        double r = Math.pow(rotation, 3.0) * mod;
        CommandBase.driver.tankDrive(-sp - r, -sp + r);
    }

    @Override
    protected void onCompletion() {
    }
}

