/*
 * Decompiled with CFR 0.152.
 */
package org.usfirst.frc.team5800.robot;

import edu.wpi.first.wpilibj.Joystick;
import edu.wpi.first.wpilibj.buttons.Button;
import edu.wpi.first.wpilibj.buttons.JoystickButton;
import org.usfirst.frc.team5800.robot.base.buttons.JoystickAxis;
import org.usfirst.frc.team5800.robot.base.buttons.JoystickAxisButton;
import org.usfirst.frc.team5800.robot.base.buttons.JoystickPOVButton;
import org.usfirst.frc.team5800.robot.base.commands.CommandArmDown;
import org.usfirst.frc.team5800.robot.base.commands.CommandArmUp;
import org.usfirst.frc.team5800.robot.base.commands.CommandChangeController;
import org.usfirst.frc.team5800.robot.base.commands.CommandChangeDirection;
import org.usfirst.frc.team5800.robot.base.commands.autonomous.Autonomous;
import org.usfirst.frc.team5800.robot.superclasses.Command5800;

public class OI {
    private static final Joystick stick_d = new Joystick(0);
    public static final JoystickAxis axis_d_LX = new JoystickAxis(stick_d, 0);
    public static final JoystickAxis axis_d_LY = new JoystickAxis(stick_d, 1);
    public static final JoystickAxis axis_d_LT = new JoystickAxis(stick_d, 2);
    public static final JoystickAxis axis_d_RT = new JoystickAxis(stick_d, 3);
    public static final JoystickAxis axis_d_RX = new JoystickAxis(stick_d, 4);
    public static final JoystickAxis axis_d_RY = new JoystickAxis(stick_d, 5);
    public static final Button d_A = new JoystickButton(stick_d, 1);
    public static final Button d_B = new JoystickButton(stick_d, 2);
    public static final Button d_X = new JoystickButton(stick_d, 3);
    public static final Button d_Y = new JoystickButton(stick_d, 4);
    public static final Button d_LB = new JoystickButton(stick_d, 5);
    public static final Button d_RB = new JoystickButton(stick_d, 6);
    public static final Button d_Back = new JoystickButton(stick_d, 7);
    public static final Button d_Start = new JoystickButton(stick_d, 8);
    public static final Button d_LStick = new JoystickButton(stick_d, 9);
    public static final Button d_RStick = new JoystickButton(stick_d, 10);
    public static final Button d_POV_U = new JoystickPOVButton(stick_d, 0);
    public static final Button d_POV_R = new JoystickPOVButton(stick_d, 90);
    public static final Button d_POV_D = new JoystickPOVButton(stick_d, 180);
    public static final Button d_POV_L = new JoystickPOVButton(stick_d, 270);
    public static final Button d_LT = new JoystickAxisButton(axis_d_LT, false, 0.5);
    public static final Button d_RT = new JoystickAxisButton(axis_d_RT, false, 0.5);
    private static final Joystick stick_j = new Joystick(1);
    public static final JoystickAxis axis_j_X = new JoystickAxis(stick_j, 0);
    public static final JoystickAxis axis_j_Y = new JoystickAxis(stick_j, 1);
    public static final JoystickAxis axis_j_Rotate = new JoystickAxis(stick_j, 2);
    public static final JoystickAxis axis_j_Slider = new JoystickAxis(stick_j, 3);
    public static final Button j_Fire = new JoystickButton(stick_j, 1);
    public static final Button j_Thumb = new JoystickButton(stick_j, 2);
    public static final Button j_Three = new JoystickButton(stick_j, 3);
    public static final Button j_Four = new JoystickButton(stick_j, 4);
    public static final Button j_Five = new JoystickButton(stick_j, 5);
    public static final Button j_Six = new JoystickButton(stick_j, 6);
    public static final Button j_Seven = new JoystickButton(stick_j, 7);
    public static final Button j_Eight = new JoystickButton(stick_j, 8);
    public static final Button j_Nine = new JoystickButton(stick_j, 9);
    public static final Button j_Ten = new JoystickButton(stick_j, 10);
    public static final Button j_Eleven = new JoystickButton(stick_j, 11);
    public static final Button j_Twelve = new JoystickButton(stick_j, 12);

    public OI() {
        Autonomous.initAutonomous();
        this.whenHeld(d_LB, new CommandChangeDirection());
        this.whenHeld(j_Eleven, new CommandChangeController());
        this.whenPressed(d_A, new CommandArmUp(3.0));
        this.whenPressed(d_B, new CommandArmDown(3.0));
    }

    private void whenPressed(Button button, Command5800 command) {
        button.whenPressed(command);
    }

    private void whenHeld(Button button, Command5800 command) {
        button.whenPressed(command.setCancelWhenReleased(button));
    }

    private void whenReleased(Button button, Command5800 command) {
        button.whenReleased(command);
    }

    private void cancelWhenPressed(Button button, Command5800 command) {
        button.cancelWhenPressed(command);
    }

    private void toggleWhenPressed(Button button, Command5800 command) {
        button.toggleWhenPressed(command);
    }

    private void pulseWhileHeld(Button button, Command5800 command) {
        button.whileHeld(command);
    }
}

