/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfRect;
import org.opencv.core.Size;

public class HOGDescriptor {
    protected final long nativeObj;
    public static final int L2Hys = 0;
    public static final int DEFAULT_NLEVELS = 64;

    protected HOGDescriptor(long l) {
        this.nativeObj = l;
    }

    public HOGDescriptor(Size size, Size size2, Size size3, Size size4, int n, int n2, double d, int n3, double d2, boolean bl, int n4, boolean bl2) {
        this.nativeObj = HOGDescriptor.HOGDescriptor_0(size.width, size.height, size2.width, size2.height, size3.width, size3.height, size4.width, size4.height, n, n2, d, n3, d2, bl, n4, bl2);
    }

    public HOGDescriptor(Size size, Size size2, Size size3, Size size4, int n) {
        this.nativeObj = HOGDescriptor.HOGDescriptor_1(size.width, size.height, size2.width, size2.height, size3.width, size3.height, size4.width, size4.height, n);
    }

    public HOGDescriptor(String string) {
        this.nativeObj = HOGDescriptor.HOGDescriptor_2(string);
    }

    public HOGDescriptor() {
        this.nativeObj = HOGDescriptor.HOGDescriptor_3();
    }

    public boolean checkDetectorSize() {
        boolean bl = HOGDescriptor.checkDetectorSize_0(this.nativeObj);
        return bl;
    }

    public boolean load(String string, String string2) {
        boolean bl = HOGDescriptor.load_0(this.nativeObj, string, string2);
        return bl;
    }

    public boolean load(String string) {
        boolean bl = HOGDescriptor.load_1(this.nativeObj, string);
        return bl;
    }

    public double getWinSigma() {
        double d = HOGDescriptor.getWinSigma_0(this.nativeObj);
        return d;
    }

    public long getDescriptorSize() {
        long l = HOGDescriptor.getDescriptorSize_0(this.nativeObj);
        return l;
    }

    public static MatOfFloat getDaimlerPeopleDetector() {
        MatOfFloat matOfFloat = MatOfFloat.fromNativeAddr(HOGDescriptor.getDaimlerPeopleDetector_0());
        return matOfFloat;
    }

    public static MatOfFloat getDefaultPeopleDetector() {
        MatOfFloat matOfFloat = MatOfFloat.fromNativeAddr(HOGDescriptor.getDefaultPeopleDetector_0());
        return matOfFloat;
    }

    public void compute(Mat mat, MatOfFloat matOfFloat, Size size, Size size2, MatOfPoint matOfPoint) {
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfPoint matOfPoint2 = matOfPoint;
        HOGDescriptor.compute_0(this.nativeObj, mat.nativeObj, matOfFloat2.nativeObj, size.width, size.height, size2.width, size2.height, matOfPoint2.nativeObj);
    }

    public void compute(Mat mat, MatOfFloat matOfFloat) {
        MatOfFloat matOfFloat2 = matOfFloat;
        HOGDescriptor.compute_1(this.nativeObj, mat.nativeObj, matOfFloat2.nativeObj);
    }

    public void computeGradient(Mat mat, Mat mat2, Mat mat3, Size size, Size size2) {
        HOGDescriptor.computeGradient_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height, size2.width, size2.height);
    }

    public void computeGradient(Mat mat, Mat mat2, Mat mat3) {
        HOGDescriptor.computeGradient_1(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public void detect(Mat mat, MatOfPoint matOfPoint, MatOfDouble matOfDouble, double d, Size size, Size size2, MatOfPoint matOfPoint2) {
        MatOfPoint matOfPoint3 = matOfPoint;
        MatOfDouble matOfDouble2 = matOfDouble;
        MatOfPoint matOfPoint4 = matOfPoint2;
        HOGDescriptor.detect_0(this.nativeObj, mat.nativeObj, matOfPoint3.nativeObj, matOfDouble2.nativeObj, d, size.width, size.height, size2.width, size2.height, matOfPoint4.nativeObj);
    }

    public void detect(Mat mat, MatOfPoint matOfPoint, MatOfDouble matOfDouble) {
        MatOfPoint matOfPoint2 = matOfPoint;
        MatOfDouble matOfDouble2 = matOfDouble;
        HOGDescriptor.detect_1(this.nativeObj, mat.nativeObj, matOfPoint2.nativeObj, matOfDouble2.nativeObj);
    }

    public void detectMultiScale(Mat mat, MatOfRect matOfRect, MatOfDouble matOfDouble, double d, Size size, Size size2, double d2, double d3, boolean bl) {
        MatOfRect matOfRect2 = matOfRect;
        MatOfDouble matOfDouble2 = matOfDouble;
        HOGDescriptor.detectMultiScale_0(this.nativeObj, mat.nativeObj, matOfRect2.nativeObj, matOfDouble2.nativeObj, d, size.width, size.height, size2.width, size2.height, d2, d3, bl);
    }

    public void detectMultiScale(Mat mat, MatOfRect matOfRect, MatOfDouble matOfDouble) {
        MatOfRect matOfRect2 = matOfRect;
        MatOfDouble matOfDouble2 = matOfDouble;
        HOGDescriptor.detectMultiScale_1(this.nativeObj, mat.nativeObj, matOfRect2.nativeObj, matOfDouble2.nativeObj);
    }

    public void save(String string, String string2) {
        HOGDescriptor.save_0(this.nativeObj, string, string2);
    }

    public void save(String string) {
        HOGDescriptor.save_1(this.nativeObj, string);
    }

    public void setSVMDetector(Mat mat) {
        HOGDescriptor.setSVMDetector_0(this.nativeObj, mat.nativeObj);
    }

    public Size get_winSize() {
        Size size = new Size(HOGDescriptor.get_winSize_0(this.nativeObj));
        return size;
    }

    public Size get_blockSize() {
        Size size = new Size(HOGDescriptor.get_blockSize_0(this.nativeObj));
        return size;
    }

    public Size get_blockStride() {
        Size size = new Size(HOGDescriptor.get_blockStride_0(this.nativeObj));
        return size;
    }

    public Size get_cellSize() {
        Size size = new Size(HOGDescriptor.get_cellSize_0(this.nativeObj));
        return size;
    }

    public int get_nbins() {
        int n = HOGDescriptor.get_nbins_0(this.nativeObj);
        return n;
    }

    public int get_derivAperture() {
        int n = HOGDescriptor.get_derivAperture_0(this.nativeObj);
        return n;
    }

    public double get_winSigma() {
        double d = HOGDescriptor.get_winSigma_0(this.nativeObj);
        return d;
    }

    public int get_histogramNormType() {
        int n = HOGDescriptor.get_histogramNormType_0(this.nativeObj);
        return n;
    }

    public double get_L2HysThreshold() {
        double d = HOGDescriptor.get_L2HysThreshold_0(this.nativeObj);
        return d;
    }

    public boolean get_gammaCorrection() {
        boolean bl = HOGDescriptor.get_gammaCorrection_0(this.nativeObj);
        return bl;
    }

    public MatOfFloat get_svmDetector() {
        MatOfFloat matOfFloat = MatOfFloat.fromNativeAddr(HOGDescriptor.get_svmDetector_0(this.nativeObj));
        return matOfFloat;
    }

    public int get_nlevels() {
        int n = HOGDescriptor.get_nlevels_0(this.nativeObj);
        return n;
    }

    public boolean get_signedGradient() {
        boolean bl = HOGDescriptor.get_signedGradient_0(this.nativeObj);
        return bl;
    }

    protected void finalize() throws Throwable {
        HOGDescriptor.delete(this.nativeObj);
    }

    private static native long HOGDescriptor_0(double var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, int var16, int var17, double var18, int var20, double var21, boolean var23, int var24, boolean var25);

    private static native long HOGDescriptor_1(double var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, int var16);

    private static native long HOGDescriptor_2(String var0);

    private static native long HOGDescriptor_3();

    private static native boolean checkDetectorSize_0(long var0);

    private static native boolean load_0(long var0, String var2, String var3);

    private static native boolean load_1(long var0, String var2);

    private static native double getWinSigma_0(long var0);

    private static native long getDescriptorSize_0(long var0);

    private static native long getDaimlerPeopleDetector_0();

    private static native long getDefaultPeopleDetector_0();

    private static native void compute_0(long var0, long var2, long var4, double var6, double var8, double var10, double var12, long var14);

    private static native void compute_1(long var0, long var2, long var4);

    private static native void computeGradient_0(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14);

    private static native void computeGradient_1(long var0, long var2, long var4, long var6);

    private static native void detect_0(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14, double var16, long var18);

    private static native void detect_1(long var0, long var2, long var4, long var6);

    private static native void detectMultiScale_0(long var0, long var2, long var4, long var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, boolean var22);

    private static native void detectMultiScale_1(long var0, long var2, long var4, long var6);

    private static native void save_0(long var0, String var2, String var3);

    private static native void save_1(long var0, String var2);

    private static native void setSVMDetector_0(long var0, long var2);

    private static native double[] get_winSize_0(long var0);

    private static native double[] get_blockSize_0(long var0);

    private static native double[] get_blockStride_0(long var0);

    private static native double[] get_cellSize_0(long var0);

    private static native int get_nbins_0(long var0);

    private static native int get_derivAperture_0(long var0);

    private static native double get_winSigma_0(long var0);

    private static native int get_histogramNormType_0(long var0);

    private static native double get_L2HysThreshold_0(long var0);

    private static native boolean get_gammaCorrection_0(long var0);

    private static native long get_svmDetector_0(long var0);

    private static native int get_nlevels_0(long var0);

    private static native boolean get_signedGradient_0(long var0);

    private static native void delete(long var0);
}

