/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.features2d;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDMatch;
import org.opencv.utils.Converters;

public class DescriptorMatcher {
    protected final long nativeObj;
    public static final int FLANNBASED = 1;
    public static final int BRUTEFORCE = 2;
    public static final int BRUTEFORCE_L1 = 3;
    public static final int BRUTEFORCE_HAMMING = 4;
    public static final int BRUTEFORCE_HAMMINGLUT = 5;
    public static final int BRUTEFORCE_SL2 = 6;

    protected DescriptorMatcher(long l) {
        this.nativeObj = l;
    }

    public boolean empty() {
        boolean bl = DescriptorMatcher.empty_0(this.nativeObj);
        return bl;
    }

    public boolean isMaskSupported() {
        boolean bl = DescriptorMatcher.isMaskSupported_0(this.nativeObj);
        return bl;
    }

    public static DescriptorMatcher create(int n) {
        DescriptorMatcher descriptorMatcher = new DescriptorMatcher(DescriptorMatcher.create_0(n));
        return descriptorMatcher;
    }

    public DescriptorMatcher clone(boolean bl) {
        DescriptorMatcher descriptorMatcher = new DescriptorMatcher(DescriptorMatcher.clone_0(this.nativeObj, bl));
        return descriptorMatcher;
    }

    public DescriptorMatcher clone() {
        DescriptorMatcher descriptorMatcher = new DescriptorMatcher(DescriptorMatcher.clone_1(this.nativeObj));
        return descriptorMatcher;
    }

    public List<Mat> getTrainDescriptors() {
        ArrayList<Mat> arrayList = new ArrayList<Mat>();
        Mat mat = new Mat(DescriptorMatcher.getTrainDescriptors_0(this.nativeObj));
        Converters.Mat_to_vector_Mat(mat, arrayList);
        return arrayList;
    }

    public void add(List<Mat> list) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        DescriptorMatcher.add_0(this.nativeObj, mat.nativeObj);
    }

    public void clear() {
        DescriptorMatcher.clear_0(this.nativeObj);
    }

    public void knnMatch(Mat mat, Mat mat2, List<MatOfDMatch> list, int n, Mat mat3, boolean bl) {
        Mat mat4 = new Mat();
        DescriptorMatcher.knnMatch_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat4.nativeObj, n, mat3.nativeObj, bl);
        Converters.Mat_to_vector_vector_DMatch(mat4, list);
        mat4.release();
    }

    public void knnMatch(Mat mat, Mat mat2, List<MatOfDMatch> list, int n) {
        Mat mat3 = new Mat();
        DescriptorMatcher.knnMatch_1(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n);
        Converters.Mat_to_vector_vector_DMatch(mat3, list);
        mat3.release();
    }

    public void knnMatch(Mat mat, List<MatOfDMatch> list, int n, List<Mat> list2, boolean bl) {
        Mat mat2 = new Mat();
        Mat mat3 = Converters.vector_Mat_to_Mat(list2);
        DescriptorMatcher.knnMatch_2(this.nativeObj, mat.nativeObj, mat2.nativeObj, n, mat3.nativeObj, bl);
        Converters.Mat_to_vector_vector_DMatch(mat2, list);
        mat2.release();
    }

    public void knnMatch(Mat mat, List<MatOfDMatch> list, int n) {
        Mat mat2 = new Mat();
        DescriptorMatcher.knnMatch_3(this.nativeObj, mat.nativeObj, mat2.nativeObj, n);
        Converters.Mat_to_vector_vector_DMatch(mat2, list);
        mat2.release();
    }

    public void match(Mat mat, Mat mat2, MatOfDMatch matOfDMatch, Mat mat3) {
        MatOfDMatch matOfDMatch2 = matOfDMatch;
        DescriptorMatcher.match_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, matOfDMatch2.nativeObj, mat3.nativeObj);
    }

    public void match(Mat mat, Mat mat2, MatOfDMatch matOfDMatch) {
        MatOfDMatch matOfDMatch2 = matOfDMatch;
        DescriptorMatcher.match_1(this.nativeObj, mat.nativeObj, mat2.nativeObj, matOfDMatch2.nativeObj);
    }

    public void match(Mat mat, MatOfDMatch matOfDMatch, List<Mat> list) {
        MatOfDMatch matOfDMatch2 = matOfDMatch;
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        DescriptorMatcher.match_2(this.nativeObj, mat.nativeObj, matOfDMatch2.nativeObj, mat2.nativeObj);
    }

    public void match(Mat mat, MatOfDMatch matOfDMatch) {
        MatOfDMatch matOfDMatch2 = matOfDMatch;
        DescriptorMatcher.match_3(this.nativeObj, mat.nativeObj, matOfDMatch2.nativeObj);
    }

    public void radiusMatch(Mat mat, Mat mat2, List<MatOfDMatch> list, float f, Mat mat3, boolean bl) {
        Mat mat4 = new Mat();
        DescriptorMatcher.radiusMatch_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat4.nativeObj, f, mat3.nativeObj, bl);
        Converters.Mat_to_vector_vector_DMatch(mat4, list);
        mat4.release();
    }

    public void radiusMatch(Mat mat, Mat mat2, List<MatOfDMatch> list, float f) {
        Mat mat3 = new Mat();
        DescriptorMatcher.radiusMatch_1(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, f);
        Converters.Mat_to_vector_vector_DMatch(mat3, list);
        mat3.release();
    }

    public void radiusMatch(Mat mat, List<MatOfDMatch> list, float f, List<Mat> list2, boolean bl) {
        Mat mat2 = new Mat();
        Mat mat3 = Converters.vector_Mat_to_Mat(list2);
        DescriptorMatcher.radiusMatch_2(this.nativeObj, mat.nativeObj, mat2.nativeObj, f, mat3.nativeObj, bl);
        Converters.Mat_to_vector_vector_DMatch(mat2, list);
        mat2.release();
    }

    public void radiusMatch(Mat mat, List<MatOfDMatch> list, float f) {
        Mat mat2 = new Mat();
        DescriptorMatcher.radiusMatch_3(this.nativeObj, mat.nativeObj, mat2.nativeObj, f);
        Converters.Mat_to_vector_vector_DMatch(mat2, list);
        mat2.release();
    }

    public void read(String string) {
        DescriptorMatcher.read_0(this.nativeObj, string);
    }

    public void train() {
        DescriptorMatcher.train_0(this.nativeObj);
    }

    public void write(String string) {
        DescriptorMatcher.write_0(this.nativeObj, string);
    }

    protected void finalize() throws Throwable {
        DescriptorMatcher.delete(this.nativeObj);
    }

    private static native boolean empty_0(long var0);

    private static native boolean isMaskSupported_0(long var0);

    private static native long create_0(int var0);

    private static native long clone_0(long var0, boolean var2);

    private static native long clone_1(long var0);

    private static native long getTrainDescriptors_0(long var0);

    private static native void add_0(long var0, long var2);

    private static native void clear_0(long var0);

    private static native void knnMatch_0(long var0, long var2, long var4, long var6, int var8, long var9, boolean var11);

    private static native void knnMatch_1(long var0, long var2, long var4, long var6, int var8);

    private static native void knnMatch_2(long var0, long var2, long var4, int var6, long var7, boolean var9);

    private static native void knnMatch_3(long var0, long var2, long var4, int var6);

    private static native void match_0(long var0, long var2, long var4, long var6, long var8);

    private static native void match_1(long var0, long var2, long var4, long var6);

    private static native void match_2(long var0, long var2, long var4, long var6);

    private static native void match_3(long var0, long var2, long var4);

    private static native void radiusMatch_0(long var0, long var2, long var4, long var6, float var8, long var9, boolean var11);

    private static native void radiusMatch_1(long var0, long var2, long var4, long var6, float var8);

    private static native void radiusMatch_2(long var0, long var2, long var4, float var6, long var7, boolean var9);

    private static native void radiusMatch_3(long var0, long var2, long var4, float var6);

    private static native void read_0(long var0, String var2);

    private static native void train_0(long var0);

    private static native void write_0(long var0, String var2);

    private static native void delete(long var0);
}

