/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Size;

public class RotatedRect {
    public Point center;
    public Size size;
    public double angle;

    public RotatedRect() {
        this.center = new Point();
        this.size = new Size();
        this.angle = 0.0;
    }

    public RotatedRect(Point point, Size size, double d) {
        this.center = point.clone();
        this.size = size.clone();
        this.angle = d;
    }

    public RotatedRect(double[] dArray) {
        this();
        this.set(dArray);
    }

    public void set(double[] dArray) {
        if (dArray != null) {
            this.center.x = dArray.length > 0 ? dArray[0] : 0.0;
            this.center.y = dArray.length > 1 ? dArray[1] : 0.0;
            this.size.width = dArray.length > 2 ? dArray[2] : 0.0;
            this.size.height = dArray.length > 3 ? dArray[3] : 0.0;
            this.angle = dArray.length > 4 ? dArray[4] : 0.0;
        } else {
            this.center.x = 0.0;
            this.center.x = 0.0;
            this.size.width = 0.0;
            this.size.height = 0.0;
            this.angle = 0.0;
        }
    }

    public void points(Point[] pointArray) {
        double d = this.angle * Math.PI / 180.0;
        double d2 = Math.cos(d) * 0.5;
        double d3 = Math.sin(d) * 0.5;
        pointArray[0] = new Point(this.center.x - d3 * this.size.height - d2 * this.size.width, this.center.y + d2 * this.size.height - d3 * this.size.width);
        pointArray[1] = new Point(this.center.x + d3 * this.size.height - d2 * this.size.width, this.center.y - d2 * this.size.height - d3 * this.size.width);
        pointArray[2] = new Point(2.0 * this.center.x - pointArray[0].x, 2.0 * this.center.y - pointArray[0].y);
        pointArray[3] = new Point(2.0 * this.center.x - pointArray[1].x, 2.0 * this.center.y - pointArray[1].y);
    }

    public Rect boundingRect() {
        Point[] pointArray = new Point[4];
        this.points(pointArray);
        Rect rect = new Rect((int)Math.floor(Math.min(Math.min(Math.min(pointArray[0].x, pointArray[1].x), pointArray[2].x), pointArray[3].x)), (int)Math.floor(Math.min(Math.min(Math.min(pointArray[0].y, pointArray[1].y), pointArray[2].y), pointArray[3].y)), (int)Math.ceil(Math.max(Math.max(Math.max(pointArray[0].x, pointArray[1].x), pointArray[2].x), pointArray[3].x)), (int)Math.ceil(Math.max(Math.max(Math.max(pointArray[0].y, pointArray[1].y), pointArray[2].y), pointArray[3].y)));
        rect.width -= rect.x - 1;
        rect.height -= rect.y - 1;
        return rect;
    }

    public RotatedRect clone() {
        return new RotatedRect(this.center, this.size, this.angle);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.center.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.center.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.size.width);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.size.height);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.angle);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RotatedRect)) {
            return false;
        }
        RotatedRect rotatedRect = (RotatedRect)object;
        return this.center.equals(rotatedRect.center) && this.size.equals(rotatedRect.size) && this.angle == rotatedRect.angle;
    }

    public String toString() {
        return "{ " + this.center + " " + this.size + " * " + this.angle + " }";
    }
}

