/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Range;

public class MatOfByte
extends Mat {
    private static final int _depth = 0;
    private static final int _channels = 1;

    public MatOfByte() {
    }

    protected MatOfByte(long l) {
        super(l);
        if (!this.empty() && this.checkVector(1, 0) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfByte fromNativeAddr(long l) {
        return new MatOfByte(l);
    }

    public MatOfByte(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(1, 0) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfByte(byte ... byArray) {
        this.fromArray(byArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(0, 1));
        }
    }

    public void fromArray(byte ... byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        int n = byArray.length / 1;
        this.alloc(n);
        this.put(0, 0, byArray);
    }

    public byte[] toArray() {
        int n = this.checkVector(1, 0);
        if (n < 0) {
            throw new RuntimeException("Native Mat has unexpected type or size: " + this.toString());
        }
        byte[] byArray = new byte[n * 1];
        if (n == 0) {
            return byArray;
        }
        this.get(0, 0, byArray);
        return byArray;
    }

    public void fromList(List<Byte> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        Byte[] byteArray = list.toArray(new Byte[0]);
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        this.fromArray(byArray);
    }

    public List<Byte> toList() {
        byte[] byArray = this.toArray();
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        return Arrays.asList(byteArray);
    }
}

