/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.smartdashboard;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.tables.ITable;
import java.util.HashMap;

public class SendableChooser<V>
implements Sendable {
    private static final String DEFAULT = "default";
    private static final String SELECTED = "selected";
    private static final String OPTIONS = "options";
    private final HashMap<String, V> m_map = new HashMap();
    private String m_defaultChoice = null;
    private ITable m_table;

    public void addObject(String name, V object) {
        this.m_map.put(name, object);
        if (this.m_table != null) {
            this.m_table.putStringArray(OPTIONS, this.m_map.keySet().toArray(new String[0]));
        }
    }

    public void addDefault(String name, V object) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null");
        }
        this.m_defaultChoice = name;
        if (this.m_table != null) {
            this.m_table.putString(DEFAULT, this.m_defaultChoice);
        }
        this.addObject(name, object);
    }

    public V getSelected() {
        String selected = this.m_table.getString(SELECTED, null);
        return this.m_map.getOrDefault(selected, this.m_map.get(this.m_defaultChoice));
    }

    @Override
    public String getSmartDashboardType() {
        return "String Chooser";
    }

    @Override
    public void initTable(ITable table) {
        this.m_table = table;
        if (table != null) {
            table.putStringArray(OPTIONS, this.m_map.keySet().toArray(new String[0]));
            if (this.m_defaultChoice != null) {
                table.putString(DEFAULT, this.m_defaultChoice);
            }
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }
}

