/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.HLUsageReporting;
import edu.wpi.first.wpilibj.NamedSendable;
import edu.wpi.first.wpilibj.buttons.Trigger;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.LinkedListElement;
import edu.wpi.first.wpilibj.command.Set;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.tables.ITable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Scheduler
implements NamedSendable {
    private static Scheduler instance;
    private Hashtable m_commandTable = new Hashtable();
    private Set m_subsystems = new Set();
    private LinkedListElement m_firstCommand;
    private LinkedListElement m_lastCommand;
    private boolean m_adding = false;
    private boolean m_disabled = false;
    private Vector m_additions = new Vector();
    private ITable m_table;
    private Vector m_buttons;
    private boolean m_runningCommandsChanged;

    public static synchronized Scheduler getInstance() {
        return instance == null ? (instance = new Scheduler()) : instance;
    }

    private Scheduler() {
        HLUsageReporting.reportScheduler();
    }

    public void add(Command command) {
        if (command != null) {
            this.m_additions.addElement(command);
        }
    }

    public void addButton(Trigger.ButtonScheduler button) {
        if (this.m_buttons == null) {
            this.m_buttons = new Vector();
        }
        this.m_buttons.addElement(button);
    }

    private void _add(Command command) {
        if (command == null) {
            return;
        }
        if (this.m_adding) {
            System.err.println("WARNING: Can not start command from cancel method.  Ignoring:" + command);
            return;
        }
        if (!this.m_commandTable.containsKey(command)) {
            Subsystem lock;
            Enumeration requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                lock = (Subsystem)requirements.nextElement();
                if (lock.getCurrentCommand() == null || lock.getCurrentCommand().isInterruptible()) continue;
                return;
            }
            this.m_adding = true;
            requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                lock = (Subsystem)requirements.nextElement();
                if (lock.getCurrentCommand() != null) {
                    lock.getCurrentCommand().cancel();
                    this.remove(lock.getCurrentCommand());
                }
                lock.setCurrentCommand(command);
            }
            this.m_adding = false;
            LinkedListElement element = new LinkedListElement();
            element.setData(command);
            if (this.m_firstCommand == null) {
                this.m_firstCommand = this.m_lastCommand = element;
            } else {
                this.m_lastCommand.add(element);
                this.m_lastCommand = element;
            }
            this.m_commandTable.put(command, element);
            this.m_runningCommandsChanged = true;
            command.startRunning();
        }
    }

    public void run() {
        this.m_runningCommandsChanged = false;
        if (this.m_disabled) {
            return;
        }
        if (this.m_buttons != null) {
            for (int i = this.m_buttons.size() - 1; i >= 0; --i) {
                ((Trigger.ButtonScheduler)this.m_buttons.elementAt(i)).execute();
            }
        }
        for (LinkedListElement element = this.m_firstCommand; element != null; element = element.getNext()) {
            Command command = element.getData();
            if (command.run()) continue;
            this.remove(command);
            this.m_runningCommandsChanged = true;
        }
        for (int i = 0; i < this.m_additions.size(); ++i) {
            this._add((Command)this.m_additions.elementAt(i));
        }
        this.m_additions.removeAllElements();
        Enumeration locks = this.m_subsystems.getElements();
        while (locks.hasMoreElements()) {
            Subsystem lock = (Subsystem)locks.nextElement();
            if (lock.getCurrentCommand() == null) {
                this._add(lock.getDefaultCommand());
            }
            lock.confirmCommand();
        }
        this.updateTable();
    }

    void registerSubsystem(Subsystem system) {
        if (system != null) {
            this.m_subsystems.add(system);
        }
    }

    void remove(Command command) {
        if (command == null || !this.m_commandTable.containsKey(command)) {
            return;
        }
        LinkedListElement element = (LinkedListElement)this.m_commandTable.get(command);
        this.m_commandTable.remove(command);
        if (element.equals(this.m_lastCommand)) {
            this.m_lastCommand = element.getPrevious();
        }
        if (element.equals(this.m_firstCommand)) {
            this.m_firstCommand = element.getNext();
        }
        element.remove();
        Enumeration requirements = command.getRequirements();
        while (requirements.hasMoreElements()) {
            ((Subsystem)requirements.nextElement()).setCurrentCommand(null);
        }
        command.removed();
    }

    public void removeAll() {
        while (this.m_firstCommand != null) {
            this.remove(this.m_firstCommand.getData());
        }
    }

    public void disable() {
        this.m_disabled = true;
    }

    public void enable() {
        this.m_disabled = false;
    }

    @Override
    public String getName() {
        return "Scheduler";
    }

    public String getType() {
        return "Scheduler";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.m_table.putStringArray("Names", new String[0]);
        this.m_table.putNumberArray("Ids", new double[0]);
        this.m_table.putNumberArray("Cancel", new double[0]);
    }

    private void updateTable() {
        if (this.m_table != null) {
            double[] toCancel = this.m_table.getNumberArray("Cancel", new double[0]);
            if (toCancel.length > 0) {
                for (LinkedListElement e = this.m_firstCommand; e != null; e = e.getNext()) {
                    for (int i = 0; i < toCancel.length; ++i) {
                        if ((double)e.getData().hashCode() != toCancel[i]) continue;
                        e.getData().cancel();
                    }
                }
                this.m_table.putNumberArray("Cancel", new double[0]);
            }
            if (this.m_runningCommandsChanged) {
                int number = 0;
                for (LinkedListElement e = this.m_firstCommand; e != null; e = e.getNext()) {
                    ++number;
                }
                String[] commands = new String[number];
                double[] ids = new double[number];
                number = 0;
                for (LinkedListElement e = this.m_firstCommand; e != null; e = e.getNext()) {
                    commands[number] = e.getData().getName();
                    ids[number] = e.getData().hashCode();
                    ++number;
                }
                this.m_table.putStringArray("Names", commands);
                this.m_table.putNumberArray("Ids", ids);
            }
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public String getSmartDashboardType() {
        return "Scheduler";
    }
}

