/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.buttons;

import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.tables.ITable;

public abstract class Trigger
implements Sendable {
    private ITable m_table;

    public abstract boolean get();

    private boolean grab() {
        return this.get() || this.m_table != null && this.m_table.getBoolean("pressed", false);
    }

    public void whenActive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    if (!this.m_pressedLast) {
                        this.m_pressedLast = true;
                        command.start();
                    }
                } else {
                    this.m_pressedLast = false;
                }
            }
        }.start();
    }

    public void whileActive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    this.m_pressedLast = true;
                    command.start();
                } else if (this.m_pressedLast) {
                    this.m_pressedLast = false;
                    command.cancel();
                }
            }
        }.start();
    }

    public void whenInactive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    this.m_pressedLast = true;
                } else if (this.m_pressedLast) {
                    this.m_pressedLast = false;
                    command.start();
                }
            }
        }.start();
    }

    public void toggleWhenActive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    if (!this.m_pressedLast) {
                        this.m_pressedLast = true;
                        if (command.isRunning()) {
                            command.cancel();
                        } else {
                            command.start();
                        }
                    }
                } else {
                    this.m_pressedLast = false;
                }
            }
        }.start();
    }

    public void cancelWhenActive(final Command command) {
        new ButtonScheduler(){
            private boolean m_pressedLast;
            {
                this.m_pressedLast = Trigger.this.grab();
            }

            @Override
            public void execute() {
                if (Trigger.this.grab()) {
                    if (!this.m_pressedLast) {
                        this.m_pressedLast = true;
                        command.cancel();
                    }
                } else {
                    this.m_pressedLast = false;
                }
            }
        }.start();
    }

    @Override
    public String getSmartDashboardType() {
        return "Button";
    }

    @Override
    public void initTable(ITable table) {
        this.m_table = table;
        if (table != null) {
            table.putBoolean("pressed", this.get());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    public abstract class ButtonScheduler {
        public abstract void execute();

        protected void start() {
            Scheduler.getInstance().addButton(this);
        }
    }
}

