/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.GamepadBase;
import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.hal.HAL;

public class XboxController
extends GamepadBase {
    private DriverStation m_ds = DriverStation.getInstance();
    private int m_outputs;
    private short m_leftRumble;
    private short m_rightRumble;

    public XboxController(int port) {
        super(port);
        HAL.report(24, port);
    }

    @Override
    public double getX(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawAxis(0);
        }
        return this.getRawAxis(4);
    }

    @Override
    public double getY(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawAxis(1);
        }
        return this.getRawAxis(5);
    }

    @Override
    public double getRawAxis(int axis) {
        return this.m_ds.getStickAxis(this.getPort(), axis);
    }

    @Override
    public boolean getBumper(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawButton(5);
        }
        return this.getRawButton(6);
    }

    public boolean getTrigger(GenericHID.Hand hand) {
        return false;
    }

    public boolean getTop(GenericHID.Hand hand) {
        return false;
    }

    @Override
    public boolean getRawButton(int button) {
        return this.m_ds.getStickButton(this.getPort(), (byte)button);
    }

    public double getTriggerAxis(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawAxis(2);
        }
        return this.getRawAxis(3);
    }

    public boolean getAButton() {
        return this.getRawButton(1);
    }

    public boolean getBButton() {
        return this.getRawButton(2);
    }

    public boolean getXButton() {
        return this.getRawButton(3);
    }

    public boolean getYButton() {
        return this.getRawButton(4);
    }

    @Override
    public boolean getStickButton(GenericHID.Hand hand) {
        if (hand.equals((Object)GenericHID.Hand.kLeft)) {
            return this.getRawButton(9);
        }
        return this.getRawButton(10);
    }

    public boolean getBackButton() {
        return this.getRawButton(7);
    }

    public boolean getStartButton() {
        return this.getRawButton(8);
    }

    @Override
    public int getPOV(int pov) {
        return this.m_ds.getStickPOV(this.getPort(), pov);
    }

    @Override
    public int getPOVCount() {
        return this.m_ds.getStickPOVCount(this.getPort());
    }

    @Override
    public GenericHID.HIDType getType() {
        return GenericHID.HIDType.values()[this.m_ds.getJoystickType(this.getPort())];
    }

    @Override
    public String getName() {
        return this.m_ds.getJoystickName(this.getPort());
    }

    @Override
    public void setOutput(int outputNumber, boolean value) {
        this.m_outputs = this.m_outputs & ~(1 << outputNumber - 1) | (value ? 1 : 0) << outputNumber - 1;
        HAL.setJoystickOutputs((byte)this.getPort(), this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    @Override
    public void setOutputs(int value) {
        this.m_outputs = value;
        HAL.setJoystickOutputs((byte)this.getPort(), this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    @Override
    public void setRumble(GenericHID.RumbleType type, double value) {
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        if (type == GenericHID.RumbleType.kLeftRumble) {
            this.m_leftRumble = (short)(value * 65535.0);
        } else {
            this.m_rightRumble = (short)(value * 65535.0);
        }
        HAL.setJoystickOutputs((byte)this.getPort(), this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }
}

