/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PWMConfigDataResult;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.PWMJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class PWM
extends SensorBase
implements LiveWindowSendable {
    private int m_channel;
    private int m_handle;
    private ITable m_table;
    private ITableListener m_tableListener;

    public PWM(int channel) {
        PWM.checkPWMChannel(channel);
        this.m_channel = channel;
        this.m_handle = PWMJNI.initializePWMPort(DIOJNI.getPort((byte)channel));
        this.setDisabled();
        PWMJNI.setPWMEliminateDeadband(this.m_handle, false);
        HAL.report(29, channel);
    }

    @Override
    public void free() {
        if (this.m_handle == 0) {
            return;
        }
        this.setDisabled();
        PWMJNI.freePWMPort(this.m_handle);
        this.m_handle = 0;
    }

    public void enableDeadbandElimination(boolean eliminateDeadband) {
        PWMJNI.setPWMEliminateDeadband(this.m_handle, eliminateDeadband);
    }

    @Deprecated
    public void setRawBounds(int max, int deadbandMax, int center, int deadbandMin, int min) {
        PWMJNI.setPWMConfigRaw(this.m_handle, max, deadbandMax, center, deadbandMin, min);
    }

    public void setBounds(double max, double deadbandMax, double center, double deadbandMin, double min) {
        PWMJNI.setPWMConfig(this.m_handle, max, deadbandMax, center, deadbandMin, min);
    }

    public PWMConfigDataResult getRawBounds() {
        return PWMJNI.getPWMConfigRaw(this.m_handle);
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void setPosition(double pos) {
        PWMJNI.setPWMPosition(this.m_handle, pos);
    }

    public double getPosition() {
        return PWMJNI.getPWMPosition(this.m_handle);
    }

    public void setSpeed(double speed) {
        PWMJNI.setPWMSpeed(this.m_handle, speed);
    }

    public double getSpeed() {
        return PWMJNI.getPWMSpeed(this.m_handle);
    }

    public void setRaw(int value) {
        PWMJNI.setPWMRaw(this.m_handle, (short)value);
    }

    public int getRaw() {
        return PWMJNI.getPWMRaw(this.m_handle);
    }

    public void setDisabled() {
        PWMJNI.setPWMDisabled(this.m_handle);
    }

    public void setPeriodMultiplier(PeriodMultiplier mult) {
        switch (mult) {
            case k4X: {
                PWMJNI.setPWMPeriodScale(this.m_handle, 3);
                break;
            }
            case k2X: {
                PWMJNI.setPWMPeriodScale(this.m_handle, 1);
                break;
            }
            case k1X: {
                PWMJNI.setPWMPeriodScale(this.m_handle, 0);
                break;
            }
        }
    }

    protected void setZeroLatch() {
        PWMJNI.latchPWMZero(this.m_handle);
    }

    @Override
    public String getSmartDashboardType() {
        return "Speed Controller";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getSpeed());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
        this.setSpeed(0.0);
        this.m_tableListener = new ITableListener(){

            @Override
            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                PWM.this.setSpeed((Double)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_tableListener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.setSpeed(0.0);
        this.m_table.removeTableListener(this.m_tableListener);
    }

    public static enum PeriodMultiplier {
        k1X,
        k2X,
        k4X;

    }
}

