/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Utility;
import edu.wpi.first.wpilibj.hal.NotifierJNI;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class Notifier {
    private Process m_process;

    public Notifier(Runnable run) {
        this.m_process = new Process(run);
    }

    public void startSingle(double delay) {
        this.m_process.start(delay, false);
    }

    public void startPeriodic(double period) {
        this.m_process.start(period, true);
    }

    public void stop() {
        this.m_process.stop();
    }

    private static class Process
    implements NotifierJNI.NotifierJNIHandlerFunction {
        private final ReentrantLock m_processLock = new ReentrantLock();
        AtomicInteger m_notifier = new AtomicInteger();
        private double m_expirationTime = 0.0;
        private Runnable m_handler;
        private boolean m_periodic = false;
        private double m_period = 0.0;
        private final ReentrantLock m_handlerLock = new ReentrantLock();

        public Process(Runnable run) {
            this.m_handler = run;
            this.m_notifier.set(NotifierJNI.initializeNotifier(this));
        }

        protected void finalize() {
            int handle = this.m_notifier.getAndSet(0);
            NotifierJNI.cleanNotifier(handle);
            this.m_handlerLock.lock();
        }

        private void updateAlarm() {
            NotifierJNI.updateNotifierAlarm(this.m_notifier.get(), (long)(this.m_expirationTime * 1000000.0));
        }

        @Override
        public void apply(long time) {
            this.m_processLock.lock();
            if (this.m_periodic) {
                this.m_expirationTime += this.m_period;
                this.updateAlarm();
            }
            this.m_handlerLock.lock();
            this.m_processLock.unlock();
            this.m_handler.run();
            this.m_handlerLock.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(double period, boolean periodic) {
            ReentrantLock reentrantLock = this.m_processLock;
            synchronized (reentrantLock) {
                this.m_periodic = periodic;
                this.m_period = period;
                this.m_expirationTime = (double)Utility.getFPGATime() * 1.0E-6 + period;
                this.updateAlarm();
            }
        }

        public void stop() {
            NotifierJNI.stopNotifierAlarm(this.m_notifier.get());
            this.m_handlerLock.lock();
            this.m_handlerLock.unlock();
        }
    }
}

