/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.RobotState;
import edu.wpi.first.wpilibj.Timer;

public final class MotorSafetyHelper {
    private double m_expiration;
    private boolean m_enabled;
    private double m_stopTime;
    private final MotorSafety m_safeObject;
    private final MotorSafetyHelper m_nextHelper;
    private static MotorSafetyHelper headHelper = null;

    public MotorSafetyHelper(MotorSafety safeObject) {
        this.m_safeObject = safeObject;
        this.m_enabled = false;
        this.m_expiration = 0.1;
        this.m_stopTime = Timer.getFPGATimestamp();
        this.m_nextHelper = headHelper;
        headHelper = this;
    }

    public void feed() {
        this.m_stopTime = Timer.getFPGATimestamp() + this.m_expiration;
    }

    public void setExpiration(double expirationTime) {
        this.m_expiration = expirationTime;
    }

    public double getExpiration() {
        return this.m_expiration;
    }

    public boolean isAlive() {
        return !this.m_enabled || this.m_stopTime > Timer.getFPGATimestamp();
    }

    public void check() {
        if (!this.m_enabled || RobotState.isDisabled() || RobotState.isTest()) {
            return;
        }
        if (this.m_stopTime < Timer.getFPGATimestamp()) {
            DriverStation.reportError(this.m_safeObject.getDescription() + "... Output not updated often " + "enough.", false);
            this.m_safeObject.stopMotor();
        }
    }

    public void setSafetyEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public boolean isSafetyEnabled() {
        return this.m_enabled;
    }

    public static void checkMotors() {
        MotorSafetyHelper msh = headHelper;
        while (msh != null) {
            msh.check();
            msh = msh.m_nextHelper;
        }
    }
}

