/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.I2CJNI;
import edu.wpi.first.wpilibj.util.BoundaryException;
import java.nio.ByteBuffer;

public class I2C
extends SensorBase {
    private final Port m_port;
    private final int m_deviceAddress;

    public I2C(Port port, int deviceAddress) {
        this.m_port = port;
        this.m_deviceAddress = deviceAddress;
        I2CJNI.i2CInitialize((byte)port.value);
        HAL.report(21, deviceAddress);
    }

    @Override
    public void free() {
    }

    public synchronized boolean transaction(byte[] dataToSend, int sendSize, byte[] dataReceived, int receiveSize) {
        ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(sendSize);
        if (sendSize > 0 && dataToSend != null) {
            dataToSendBuffer.put(dataToSend);
        }
        ByteBuffer dataReceivedBuffer = ByteBuffer.allocateDirect(receiveSize);
        int status = I2CJNI.i2CTransaction((byte)this.m_port.value, (byte)this.m_deviceAddress, dataToSendBuffer, (byte)sendSize, dataReceivedBuffer, (byte)receiveSize);
        if (receiveSize > 0 && dataReceived != null) {
            dataReceivedBuffer.get(dataReceived);
        }
        return status < 0;
    }

    public synchronized boolean transaction(ByteBuffer dataToSend, int sendSize, ByteBuffer dataReceived, int receiveSize) {
        if (!dataToSend.isDirect()) {
            throw new IllegalArgumentException("dataToSend must be a direct buffer");
        }
        if (dataToSend.capacity() < sendSize) {
            throw new IllegalArgumentException("dataToSend is too small, must be at least " + sendSize);
        }
        if (!dataReceived.isDirect()) {
            throw new IllegalArgumentException("dataReceived must be a direct buffer");
        }
        if (dataReceived.capacity() < receiveSize) {
            throw new IllegalArgumentException("dataReceived is too small, must be at least " + receiveSize);
        }
        return I2CJNI.i2CTransaction((byte)this.m_port.value, (byte)this.m_deviceAddress, dataToSend, (byte)sendSize, dataReceived, (byte)receiveSize) < 0;
    }

    public boolean addressOnly() {
        return this.transaction((byte[])null, 0, null, 0);
    }

    public synchronized boolean write(int registerAddress, int data) {
        byte[] buffer = new byte[]{(byte)registerAddress, (byte)data};
        ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(2);
        dataToSendBuffer.put(buffer);
        return I2CJNI.i2CWrite((byte)this.m_port.value, (byte)this.m_deviceAddress, dataToSendBuffer, (byte)buffer.length) < 0;
    }

    public synchronized boolean writeBulk(byte[] data) {
        ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(data.length);
        dataToSendBuffer.put(data);
        return I2CJNI.i2CWrite((byte)this.m_port.value, (byte)this.m_deviceAddress, dataToSendBuffer, (byte)data.length) < 0;
    }

    public synchronized boolean writeBulk(ByteBuffer data, int size) {
        if (!data.isDirect()) {
            throw new IllegalArgumentException("must be a direct buffer");
        }
        if (data.capacity() < size) {
            throw new IllegalArgumentException("buffer is too small, must be at least " + size);
        }
        return I2CJNI.i2CWrite((byte)this.m_port.value, (byte)this.m_deviceAddress, data, (byte)size) < 0;
    }

    public boolean read(int registerAddress, int count, byte[] buffer) {
        if (count < 1) {
            throw new BoundaryException("Value must be at least 1, " + count + " given");
        }
        if (buffer == null) {
            throw new NullPointerException("Null return buffer was given");
        }
        byte[] registerAddressArray = new byte[]{(byte)registerAddress};
        return this.transaction(registerAddressArray, registerAddressArray.length, buffer, count);
    }

    public boolean read(int registerAddress, int count, ByteBuffer buffer) {
        if (count < 1) {
            throw new BoundaryException("Value must be at least 1, " + count + " given");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("must be a direct buffer");
        }
        if (buffer.capacity() < count) {
            throw new IllegalArgumentException("buffer is too small, must be at least " + count);
        }
        ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(1);
        dataToSendBuffer.put(0, (byte)registerAddress);
        return this.transaction(dataToSendBuffer, 1, buffer, count);
    }

    public boolean readOnly(byte[] buffer, int count) {
        if (count < 1) {
            throw new BoundaryException("Value must be at least 1, " + count + " given");
        }
        if (buffer == null) {
            throw new NullPointerException("Null return buffer was given");
        }
        ByteBuffer dataReceivedBuffer = ByteBuffer.allocateDirect(count);
        int retVal = I2CJNI.i2CRead((byte)this.m_port.value, (byte)this.m_deviceAddress, dataReceivedBuffer, (byte)count);
        dataReceivedBuffer.get(buffer);
        return retVal < 0;
    }

    public boolean readOnly(ByteBuffer buffer, int count) {
        if (count < 1) {
            throw new BoundaryException("Value must be at least 1, " + count + " given");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("must be a direct buffer");
        }
        if (buffer.capacity() < count) {
            throw new IllegalArgumentException("buffer is too small, must be at least " + count);
        }
        return I2CJNI.i2CRead((byte)this.m_port.value, (byte)this.m_deviceAddress, buffer, (byte)count) < 0;
    }

    public boolean verifySensor(int registerAddress, int count, byte[] expected) {
        ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(1);
        ByteBuffer deviceData = ByteBuffer.allocateDirect(4);
        int i = 0;
        int curRegisterAddress = registerAddress;
        while (i < count) {
            int toRead = count - i < 4 ? count - i : 4;
            dataToSendBuffer.put(0, (byte)curRegisterAddress);
            if (this.transaction(dataToSendBuffer, 1, deviceData, toRead)) {
                return false;
            }
            for (int j = 0; j < toRead; j = (int)((byte)(j + 1))) {
                if (deviceData.get(j) == expected[i + j]) continue;
                return false;
            }
            i += 4;
            curRegisterAddress += 4;
        }
        return true;
    }

    public static enum Port {
        kOnboard(0),
        kMXP(1);

        public final int value;

        private Port(int value) {
            this.value = value;
        }
    }
}

