/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class DigitalOutput
extends DigitalSource
implements LiveWindowSendable {
    private static final int invalidPwmGenerator = 0;
    private int m_pwmGenerator = 0;
    private int m_channel = 0;
    private int m_handle = 0;
    private ITable m_table;
    private ITableListener m_tableListener;

    public DigitalOutput(int channel) {
        DigitalOutput.checkDigitalChannel(channel);
        this.m_channel = channel;
        this.m_handle = DIOJNI.initializeDIOPort(DIOJNI.getPort((byte)channel), false);
        HAL.report(14, channel);
    }

    @Override
    public void free() {
        if (this.m_pwmGenerator != 0) {
            this.disablePWM();
        }
        DIOJNI.freeDIOPort(this.m_handle);
        this.m_handle = 0;
    }

    public void set(boolean value) {
        DIOJNI.setDIO(this.m_handle, (short)(value ? 1 : 0));
    }

    public boolean get() {
        return DIOJNI.getDIO(this.m_handle);
    }

    @Override
    public int getChannel() {
        return this.m_channel;
    }

    public void pulse(double pulseLength) {
        DIOJNI.pulse(this.m_handle, pulseLength);
    }

    @Deprecated
    public void pulse(int channel, double pulseLength) {
        DIOJNI.pulse(this.m_handle, pulseLength);
    }

    @Deprecated
    public void pulse(int channel, int pulseLength) {
        double convertedPulse = (double)pulseLength / 1.0E9 * (double)(DIOJNI.getLoopTiming() * 25);
        System.err.println("You should use the double version of pulse for portability.  This is deprecated");
        DIOJNI.pulse(this.m_handle, convertedPulse);
    }

    public boolean isPulsing() {
        return DIOJNI.isPulsing(this.m_handle);
    }

    public void setPWMRate(double rate) {
        DIOJNI.setDigitalPWMRate(rate);
    }

    public void enablePWM(double initialDutyCycle) {
        if (this.m_pwmGenerator != 0) {
            return;
        }
        this.m_pwmGenerator = DIOJNI.allocateDigitalPWM();
        DIOJNI.setDigitalPWMDutyCycle(this.m_pwmGenerator, initialDutyCycle);
        DIOJNI.setDigitalPWMOutputChannel(this.m_pwmGenerator, this.m_channel);
    }

    public void disablePWM() {
        if (this.m_pwmGenerator == 0) {
            return;
        }
        DIOJNI.setDigitalPWMOutputChannel(this.m_pwmGenerator, kDigitalChannels);
        DIOJNI.freeDigitalPWM(this.m_pwmGenerator);
        this.m_pwmGenerator = 0;
    }

    public void updateDutyCycle(double dutyCycle) {
        if (this.m_pwmGenerator == 0) {
            return;
        }
        DIOJNI.setDigitalPWMDutyCycle(this.m_pwmGenerator, dutyCycle);
    }

    @Override
    public int getAnalogTriggerTypeForRouting() {
        return 0;
    }

    @Override
    public boolean isAnalogTrigger() {
        return false;
    }

    @Override
    public int getPortHandleForRouting() {
        return this.m_handle;
    }

    @Override
    public String getSmartDashboardType() {
        return "Digital Output";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
    }

    @Override
    public void startLiveWindowMode() {
        this.m_tableListener = new ITableListener(){

            @Override
            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                DigitalOutput.this.set((Boolean)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_tableListener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.m_table.removeTableListener(this.m_tableListener);
    }
}

