/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.cscore.AxisCamera;
import edu.wpi.cscore.CameraServerJNI;
import edu.wpi.cscore.CvSink;
import edu.wpi.cscore.CvSource;
import edu.wpi.cscore.MjpegServer;
import edu.wpi.cscore.UsbCamera;
import edu.wpi.cscore.VideoEvent;
import edu.wpi.cscore.VideoException;
import edu.wpi.cscore.VideoListener;
import edu.wpi.cscore.VideoMode;
import edu.wpi.cscore.VideoProperty;
import edu.wpi.cscore.VideoSink;
import edu.wpi.cscore.VideoSource;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.networktables.NetworkTablesJNI;
import edu.wpi.first.wpilibj.tables.ITable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CameraServer {
    public static final int kBasePort = 1181;
    @Deprecated
    public static final int kSize640x480 = 0;
    @Deprecated
    public static final int kSize320x240 = 1;
    @Deprecated
    public static final int kSize160x120 = 2;
    private static final String kPublishName = "/CameraPublisher";
    private static CameraServer server;
    private AtomicInteger m_defaultUsbDevice = new AtomicInteger();
    private String m_primarySourceName;
    private final Hashtable<String, VideoSource> m_sources = new Hashtable();
    private final Hashtable<String, VideoSink> m_sinks = new Hashtable();
    private final Hashtable<Integer, ITable> m_tables = new Hashtable();
    private final ITable m_publishTable = NetworkTable.getTable("/CameraPublisher");
    private final VideoListener m_videoListener;
    private final int m_tableListener;
    private int m_nextPort = 1181;
    private String[] m_addresses = new String[0];
    private static final Pattern reMode;

    public static synchronized CameraServer getInstance() {
        if (server == null) {
            server = new CameraServer();
        }
        return server;
    }

    private static String makeSourceValue(int source) {
        switch (VideoSource.getKindFromInt(CameraServerJNI.getSourceKind(source))) {
            case kUsb: {
                return "usb:" + CameraServerJNI.getUsbCameraPath(source);
            }
            case kHttp: {
                String[] urls = CameraServerJNI.getHttpCameraUrls(source);
                if (urls.length > 0) {
                    return "ip:" + urls[0];
                }
                return "ip:";
            }
            case kCv: {
                return "usb:";
            }
        }
        return "unknown:";
    }

    private static String makeStreamValue(String address, int port) {
        return "mjpg:http://" + address + ":" + port + "/?action=stream";
    }

    private synchronized String[] getSinkStreamValues(int sink) {
        if (VideoSink.getKindFromInt(CameraServerJNI.getSinkKind(sink)) != VideoSink.Kind.kMjpeg) {
            return new String[0];
        }
        int port = CameraServerJNI.getMjpegServerPort(sink);
        ArrayList<String> values = new ArrayList<String>(this.m_addresses.length + 1);
        String listenAddress = CameraServerJNI.getMjpegServerListenAddress(sink);
        if (!listenAddress.isEmpty()) {
            values.add(CameraServer.makeStreamValue(listenAddress, port));
        } else {
            values.add(CameraServer.makeStreamValue(CameraServerJNI.getHostname() + ".local", port));
            for (String addr : this.m_addresses) {
                if (addr.equals("127.0.0.1")) continue;
                values.add(CameraServer.makeStreamValue(addr, port));
            }
        }
        return values.toArray(new String[0]);
    }

    private synchronized String[] getSourceStreamValues(int source) {
        if (VideoSource.getKindFromInt(CameraServerJNI.getSourceKind(source)) != VideoSource.Kind.kHttp) {
            return new String[0];
        }
        String[] values = CameraServerJNI.getHttpCameraUrls(source);
        for (int j = 0; j < values.length; ++j) {
            values[j] = "mjpg:" + values[j];
        }
        for (VideoSink i : this.m_sinks.values()) {
            int sink = i.getHandle();
            int sinkSource = CameraServerJNI.getSinkSource(sink);
            if (source != sinkSource || VideoSink.getKindFromInt(CameraServerJNI.getSinkKind(sink)) != VideoSink.Kind.kMjpeg) continue;
            String[] finalValues = new String[values.length + 1];
            for (int j = 0; j < values.length; ++j) {
                finalValues[j] = values[j];
            }
            int port = CameraServerJNI.getMjpegServerPort(sink);
            finalValues[values.length] = CameraServer.makeStreamValue("172.22.11.2", port);
            return finalValues;
        }
        return values;
    }

    private synchronized void updateStreamValues() {
        for (VideoSink videoSink : this.m_sinks.values()) {
            String[] values;
            ITable table;
            int sink = videoSink.getHandle();
            int source = CameraServerJNI.getSinkSource(sink);
            if (source == 0 || (table = this.m_tables.get(source)) == null || VideoSource.getKindFromInt(CameraServerJNI.getSourceKind(source)) == VideoSource.Kind.kHttp || (values = this.getSinkStreamValues(sink)).length <= 0) continue;
            table.putStringArray("streams", values);
        }
        for (VideoSource videoSource : this.m_sources.values()) {
            String[] values;
            int source = videoSource.getHandle();
            ITable table = this.m_tables.get(source);
            if (table == null || (values = this.getSourceStreamValues(source)).length <= 0) continue;
            table.putStringArray("streams", values);
        }
    }

    private static String pixelFormatToString(VideoMode.PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case kMJPEG: {
                return "MJPEG";
            }
            case kYUYV: {
                return "YUYV";
            }
            case kRGB565: {
                return "RGB565";
            }
            case kBGR: {
                return "BGR";
            }
            case kGray: {
                return "Gray";
            }
        }
        return "Unknown";
    }

    private static VideoMode.PixelFormat pixelFormatFromString(String pixelFormatStr) {
        switch (pixelFormatStr) {
            case "MJPEG": 
            case "mjpeg": 
            case "JPEG": 
            case "jpeg": {
                return VideoMode.PixelFormat.kMJPEG;
            }
            case "YUYV": 
            case "yuyv": {
                return VideoMode.PixelFormat.kYUYV;
            }
            case "RGB565": 
            case "rgb565": {
                return VideoMode.PixelFormat.kRGB565;
            }
            case "BGR": 
            case "bgr": {
                return VideoMode.PixelFormat.kBGR;
            }
            case "GRAY": 
            case "Gray": 
            case "gray": {
                return VideoMode.PixelFormat.kGray;
            }
        }
        return VideoMode.PixelFormat.kUnknown;
    }

    private static VideoMode videoModeFromString(String modeStr) {
        Matcher matcher = reMode.matcher(modeStr);
        if (!matcher.matches()) {
            return new VideoMode(VideoMode.PixelFormat.kUnknown, 0, 0, 0);
        }
        VideoMode.PixelFormat pixelFormat = CameraServer.pixelFormatFromString(matcher.group("format"));
        int width = Integer.parseInt(matcher.group("width"));
        int height = Integer.parseInt(matcher.group("height"));
        int fps = (int)Double.parseDouble(matcher.group("fps"));
        return new VideoMode(pixelFormat, width, height, fps);
    }

    private static String videoModeToString(VideoMode mode) {
        return mode.width + "x" + mode.height + " " + CameraServer.pixelFormatToString(mode.pixelFormat) + " " + mode.fps + " fps";
    }

    private static String[] getSourceModeValues(int sourceHandle) {
        VideoMode[] modes = CameraServerJNI.enumerateSourceVideoModes(sourceHandle);
        String[] modeStrings = new String[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            modeStrings[i] = CameraServer.videoModeToString(modes[i]);
        }
        return modeStrings;
    }

    private static void putSourcePropertyValue(ITable table, VideoEvent event, boolean isNew) {
        String infoName;
        String name;
        if (event.name.startsWith("raw_")) {
            name = "RawProperty/" + event.name;
            infoName = "RawPropertyInfo/" + event.name;
        } else {
            name = "Property/" + event.name;
            infoName = "PropertyInfo/" + event.name;
        }
        switch (event.propertyKind) {
            case kBoolean: {
                if (isNew) {
                    table.setDefaultBoolean(name, event.value != 0);
                    break;
                }
                table.putBoolean(name, event.value != 0);
                break;
            }
            case kInteger: 
            case kEnum: {
                if (isNew) {
                    table.setDefaultNumber(name, event.value);
                    table.putNumber(infoName + "/min", CameraServerJNI.getPropertyMin(event.propertyHandle));
                    table.putNumber(infoName + "/max", CameraServerJNI.getPropertyMax(event.propertyHandle));
                    table.putNumber(infoName + "/step", CameraServerJNI.getPropertyStep(event.propertyHandle));
                    table.putNumber(infoName + "/default", CameraServerJNI.getPropertyDefault(event.propertyHandle));
                    break;
                }
                table.putNumber(name, event.value);
                break;
            }
            case kString: {
                if (isNew) {
                    table.setDefaultString(name, event.valueStr);
                    break;
                }
                table.putString(name, event.valueStr);
                break;
            }
        }
    }

    private CameraServer() {
        this.m_videoListener = new VideoListener(event -> {
            switch (event.kind) {
                case kSourceCreated: {
                    ITable table = this.m_publishTable.getSubTable(event.name);
                    this.m_tables.put(event.sourceHandle, table);
                    table.putString("source", CameraServer.makeSourceValue(event.sourceHandle));
                    table.putString("description", CameraServerJNI.getSourceDescription(event.sourceHandle));
                    table.putBoolean("connected", CameraServerJNI.isSourceConnected(event.sourceHandle));
                    table.putStringArray("streams", this.getSourceStreamValues(event.sourceHandle));
                    try {
                        VideoMode mode = CameraServerJNI.getSourceVideoMode(event.sourceHandle);
                        table.setDefaultString("mode", CameraServer.videoModeToString(mode));
                        table.putStringArray("modes", CameraServer.getSourceModeValues(event.sourceHandle));
                    }
                    catch (VideoException mode) {}
                    break;
                }
                case kSourceDestroyed: {
                    ITable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.putString("source", "");
                    table.putStringArray("streams", new String[0]);
                    table.putStringArray("modes", new String[0]);
                    break;
                }
                case kSourceConnected: {
                    ITable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.putString("description", CameraServerJNI.getSourceDescription(event.sourceHandle));
                    table.putBoolean("connected", true);
                    break;
                }
                case kSourceDisconnected: {
                    ITable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.putBoolean("connected", false);
                    break;
                }
                case kSourceVideoModesUpdated: {
                    ITable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.putStringArray("modes", CameraServer.getSourceModeValues(event.sourceHandle));
                    break;
                }
                case kSourceVideoModeChanged: {
                    ITable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    table.putString("mode", CameraServer.videoModeToString(event.mode));
                    break;
                }
                case kSourcePropertyCreated: {
                    ITable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    CameraServer.putSourcePropertyValue(table, event, true);
                    break;
                }
                case kSourcePropertyValueUpdated: {
                    ITable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    CameraServer.putSourcePropertyValue(table, event, false);
                    break;
                }
                case kSourcePropertyChoicesUpdated: {
                    ITable table = this.m_tables.get(event.sourceHandle);
                    if (table == null) break;
                    String[] choices = CameraServerJNI.getEnumPropertyChoices(event.propertyHandle);
                    table.putStringArray("PropertyInfo/" + event.name + "/choices", choices);
                    break;
                }
                case kSinkSourceChanged: 
                case kSinkCreated: 
                case kSinkDestroyed: {
                    this.updateStreamValues();
                    break;
                }
                case kNetworkInterfacesChanged: {
                    this.m_addresses = CameraServerJNI.getNetworkInterfaces();
                    break;
                }
            }
        }, 20479, true);
        this.m_tableListener = NetworkTablesJNI.addEntryListener("/CameraPublisher/", (uid, key, eventValue, flags) -> {
            String propName;
            String relativeKey = key.substring(kPublishName.length() + 1);
            int subKeyIndex = relativeKey.indexOf(47);
            if (subKeyIndex == -1) {
                return;
            }
            String sourceName = relativeKey.substring(0, subKeyIndex);
            VideoSource source = this.m_sources.get(sourceName);
            if (source == null) {
                return;
            }
            if ((relativeKey = relativeKey.substring(subKeyIndex + 1)).equals("mode")) {
                NetworkTablesJNI.putString(key, CameraServer.videoModeToString(source.getVideoMode()));
                return;
            }
            if (relativeKey.startsWith("Property/")) {
                propName = relativeKey.substring(9);
            } else if (relativeKey.startsWith("RawProperty/")) {
                propName = relativeKey.substring(12);
            } else {
                return;
            }
            VideoProperty property = source.getProperty(propName);
            switch (property.getKind()) {
                case kNone: {
                    return;
                }
                case kBoolean: {
                    NetworkTablesJNI.putBoolean(key, property.get() != 0);
                    return;
                }
                case kInteger: 
                case kEnum: {
                    NetworkTablesJNI.putDouble(key, property.get());
                    return;
                }
                case kString: {
                    NetworkTablesJNI.putString(key, property.getString());
                    return;
                }
            }
        }, 17);
    }

    public UsbCamera startAutomaticCapture() {
        return this.startAutomaticCapture(this.m_defaultUsbDevice.getAndIncrement());
    }

    public UsbCamera startAutomaticCapture(int dev) {
        UsbCamera camera = new UsbCamera("USB Camera " + dev, dev);
        this.startAutomaticCapture(camera);
        return camera;
    }

    public UsbCamera startAutomaticCapture(String name, int dev) {
        UsbCamera camera = new UsbCamera(name, dev);
        this.startAutomaticCapture(camera);
        return camera;
    }

    public UsbCamera startAutomaticCapture(String name, String path) {
        UsbCamera camera = new UsbCamera(name, path);
        this.startAutomaticCapture(camera);
        return camera;
    }

    public void startAutomaticCapture(VideoSource camera) {
        this.addCamera(camera);
        MjpegServer server = this.addServer("serve_" + camera.getName());
        server.setSource(camera);
    }

    public AxisCamera addAxisCamera(String host) {
        return this.addAxisCamera("Axis Camera", host);
    }

    public AxisCamera addAxisCamera(String[] hosts) {
        return this.addAxisCamera("Axis Camera", hosts);
    }

    public AxisCamera addAxisCamera(String name, String host) {
        AxisCamera camera = new AxisCamera(name, host);
        this.startAutomaticCapture(camera);
        return camera;
    }

    public AxisCamera addAxisCamera(String name, String[] hosts) {
        AxisCamera camera = new AxisCamera(name, hosts);
        this.startAutomaticCapture(camera);
        return camera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CvSink getVideo() {
        VideoSource source;
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            if (this.m_primarySourceName == null) {
                throw new VideoException("no camera available");
            }
            source = this.m_sources.get(this.m_primarySourceName);
        }
        if (source == null) {
            throw new VideoException("no camera available");
        }
        return this.getVideo(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CvSink getVideo(VideoSource camera) {
        String name = "opencv_" + camera.getName();
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            VideoSink sink = this.m_sinks.get(name);
            if (sink != null) {
                VideoSink.Kind kind = sink.getKind();
                if (kind != VideoSink.Kind.kCv) {
                    throw new VideoException("expected OpenCV sink, but got " + (Object)((Object)kind));
                }
                return (CvSink)sink;
            }
        }
        CvSink newsink = new CvSink(name);
        newsink.setSource(camera);
        this.addServer(newsink);
        return newsink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CvSink getVideo(String name) {
        VideoSource source;
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            source = this.m_sources.get(name);
            if (source == null) {
                throw new VideoException("could not find camera " + name);
            }
        }
        return this.getVideo(source);
    }

    public CvSource putVideo(String name, int width, int height) {
        CvSource source = new CvSource(name, VideoMode.PixelFormat.kMJPEG, width, height, 30);
        this.startAutomaticCapture(source);
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MjpegServer addServer(String name) {
        int port;
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            port = this.m_nextPort++;
        }
        return this.addServer(name, port);
    }

    public MjpegServer addServer(String name, int port) {
        MjpegServer server = new MjpegServer(name, port);
        this.addServer(server);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServer(VideoSink server) {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            this.m_sinks.put(server.getName(), server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServer(String name) {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            this.m_sinks.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoSink getServer() {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            if (this.m_primarySourceName == null) {
                throw new VideoException("no camera available");
            }
            return this.getServer("serve_" + this.m_primarySourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoSink getServer(String name) {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            return this.m_sinks.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCamera(VideoSource camera) {
        String name = camera.getName();
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            if (this.m_primarySourceName == null) {
                this.m_primarySourceName = name;
            }
            this.m_sources.put(name, camera);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCamera(String name) {
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            this.m_sources.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setSize(int size) {
        VideoSource source = null;
        CameraServer cameraServer = this;
        synchronized (cameraServer) {
            if (this.m_primarySourceName == null) {
                return;
            }
            source = this.m_sources.get(this.m_primarySourceName);
            if (source == null) {
                return;
            }
        }
        switch (size) {
            case 0: {
                source.setResolution(640, 480);
                break;
            }
            case 1: {
                source.setResolution(320, 240);
                break;
            }
            case 2: {
                source.setResolution(160, 120);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported size: " + size);
            }
        }
    }

    static {
        reMode = Pattern.compile("(?<width>[0-9]+)\\s*x\\s*(?<height>[0-9]+)\\s+(?<format>.*?)\\s+(?<fps>[0-9.]+)\\s*fps");
    }
}

