/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PIDInterface;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public interface CANSpeedController
extends SpeedController,
PIDInterface,
LiveWindowSendable {
    public static final String SMART_DASHBOARD_TYPE = "CANSpeedController";

    public ControlMode getControlMode();

    public void setControlMode(int var1);

    public void setP(double var1);

    public void setI(double var1);

    public void setD(double var1);

    default public void setF(double f) {
    }

    default public double getF() {
        return 0.0;
    }

    public double getBusVoltage();

    public double getOutputVoltage();

    public double getOutputCurrent();

    public double getTemperature();

    public double getPosition();

    public double getSpeed();

    public void setVoltageRampRate(double var1);

    @Override
    default public void updateTable() {
        ITable table = this.getTable();
        if (table != null) {
            table.putString("~TYPE~", SMART_DASHBOARD_TYPE);
            table.putString("Type", this.getClass().getSimpleName());
            table.putNumber("Mode", this.getControlMode().getValue());
            if (this.getControlMode().isPID()) {
                table.putNumber("p", this.getP());
                table.putNumber("i", this.getI());
                table.putNumber("d", this.getD());
                table.putNumber("f", this.getF());
            }
            table.putBoolean("Enabled", this.isEnabled());
            table.putNumber("Value", this.get());
        }
    }

    @Override
    default public String getSmartDashboardType() {
        return SMART_DASHBOARD_TYPE;
    }

    default public ITableListener createTableListener() {
        return (table, key, value, isNew) -> {
            switch (key) {
                case "Enabled": {
                    if (((Boolean)value).booleanValue()) {
                        this.enable();
                        break;
                    }
                    this.disable();
                    break;
                }
                case "Value": {
                    this.set((Double)value);
                    break;
                }
                case "Mode": {
                    this.setControlMode(((Double)value).intValue());
                    break;
                }
            }
            if (this.getControlMode().isPID()) {
                switch (key) {
                    case "p": {
                        this.setP((Double)value);
                        break;
                    }
                    case "i": {
                        this.setI((Double)value);
                        break;
                    }
                    case "d": {
                        this.setD((Double)value);
                        break;
                    }
                    case "f": {
                        this.setF((Double)value);
                        break;
                    }
                }
            }
        };
    }

    public static interface ControlMode {
        public String name();

        public boolean isPID();

        public int getValue();
    }
}

