/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.hal.AccelerometerJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.interfaces.Accelerometer;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class BuiltInAccelerometer
implements Accelerometer,
LiveWindowSendable {
    private ITable m_table;

    public BuiltInAccelerometer(Accelerometer.Range range) {
        this.setRange(range);
        HAL.report(4, 0, 0, "Built-in accelerometer");
        LiveWindow.addSensor("BuiltInAccel", 0, (LiveWindowSendable)this);
    }

    public BuiltInAccelerometer() {
        this(Accelerometer.Range.k8G);
    }

    @Override
    public void setRange(Accelerometer.Range range) {
        AccelerometerJNI.setAccelerometerActive(false);
        switch (range) {
            case k2G: {
                AccelerometerJNI.setAccelerometerRange(0);
                break;
            }
            case k4G: {
                AccelerometerJNI.setAccelerometerRange(1);
                break;
            }
            case k8G: {
                AccelerometerJNI.setAccelerometerRange(2);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)range) + " range not supported (use k2G, k4G, or k8G)");
            }
        }
        AccelerometerJNI.setAccelerometerActive(true);
    }

    @Override
    public double getX() {
        return AccelerometerJNI.getAccelerometerX();
    }

    @Override
    public double getY() {
        return AccelerometerJNI.getAccelerometerY();
    }

    @Override
    public double getZ() {
        return AccelerometerJNI.getAccelerometerZ();
    }

    @Override
    public String getSmartDashboardType() {
        return "3AxisAccelerometer";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("X", this.getX());
            this.m_table.putNumber("Y", this.getY());
            this.m_table.putNumber("Z", this.getZ());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

