/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogInput;
import edu.wpi.first.wpilibj.GyroBase;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.hal.AnalogGyroJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.interfaces.Gyro;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;

public class AnalogGyro
extends GyroBase
implements Gyro,
PIDSource,
LiveWindowSendable {
    private static final double kDefaultVoltsPerDegreePerSecond = 0.007;
    protected AnalogInput m_analog;
    private boolean m_channelAllocated = false;
    private int m_gyroHandle = 0;

    public void initGyro() {
        if (this.m_gyroHandle == 0) {
            this.m_gyroHandle = AnalogGyroJNI.initializeAnalogGyro(this.m_analog.m_port);
        }
        AnalogGyroJNI.setupAnalogGyro(this.m_gyroHandle);
        HAL.report(20, this.m_analog.getChannel());
        LiveWindow.addSensor("AnalogGyro", this.m_analog.getChannel(), (LiveWindowSendable)this);
    }

    @Override
    public void calibrate() {
        AnalogGyroJNI.calibrateAnalogGyro(this.m_gyroHandle);
    }

    public AnalogGyro(int channel) {
        this(new AnalogInput(channel));
        this.m_channelAllocated = true;
    }

    public AnalogGyro(AnalogInput channel) {
        this.m_analog = channel;
        if (this.m_analog == null) {
            throw new NullPointerException("AnalogInput supplied to Gyro constructor is null");
        }
        this.initGyro();
        this.calibrate();
    }

    public AnalogGyro(int channel, int center, double offset) {
        this(new AnalogInput(channel), center, offset);
        this.m_channelAllocated = true;
    }

    public AnalogGyro(AnalogInput channel, int center, double offset) {
        this.m_analog = channel;
        if (this.m_analog == null) {
            throw new NullPointerException("AnalogInput supplied to Gyro constructor is null");
        }
        this.initGyro();
        AnalogGyroJNI.setAnalogGyroParameters(this.m_gyroHandle, 0.007, offset, center);
        this.reset();
    }

    @Override
    public void reset() {
        AnalogGyroJNI.resetAnalogGyro(this.m_gyroHandle);
    }

    @Override
    public void free() {
        if (this.m_analog != null && this.m_channelAllocated) {
            this.m_analog.free();
        }
        this.m_analog = null;
        AnalogGyroJNI.freeAnalogGyro(this.m_gyroHandle);
    }

    @Override
    public double getAngle() {
        if (this.m_analog == null) {
            return 0.0;
        }
        return AnalogGyroJNI.getAnalogGyroAngle(this.m_gyroHandle);
    }

    @Override
    public double getRate() {
        if (this.m_analog == null) {
            return 0.0;
        }
        return AnalogGyroJNI.getAnalogGyroRate(this.m_gyroHandle);
    }

    public double getOffset() {
        return AnalogGyroJNI.getAnalogGyroOffset(this.m_gyroHandle);
    }

    public int getCenter() {
        return AnalogGyroJNI.getAnalogGyroCenter(this.m_gyroHandle);
    }

    public void setSensitivity(double voltsPerDegreePerSecond) {
        AnalogGyroJNI.setAnalogGyroVoltsPerDegreePerSecond(this.m_gyroHandle, voltsPerDegreePerSecond);
    }

    void setDeadband(double volts) {
        AnalogGyroJNI.setAnalogGyroDeadband(this.m_gyroHandle, volts);
    }
}

