/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.I2C;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.interfaces.Accelerometer;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ADXL345_I2C
extends SensorBase
implements Accelerometer,
LiveWindowSendable {
    private static final byte kAddress = 29;
    private static final byte kPowerCtlRegister = 45;
    private static final byte kDataFormatRegister = 49;
    private static final byte kDataRegister = 50;
    private static final double kGsPerLSB = 0.00390625;
    private static final byte kPowerCtl_Link = 32;
    private static final byte kPowerCtl_AutoSleep = 16;
    private static final byte kPowerCtl_Measure = 8;
    private static final byte kPowerCtl_Sleep = 4;
    private static final byte kDataFormat_SelfTest = -128;
    private static final byte kDataFormat_SPI = 64;
    private static final byte kDataFormat_IntInvert = 32;
    private static final byte kDataFormat_FullRes = 8;
    private static final byte kDataFormat_Justify = 4;
    protected I2C m_i2c;
    private ITable m_table;

    public ADXL345_I2C(I2C.Port port, Accelerometer.Range range) {
        this(port, range, 29);
    }

    public ADXL345_I2C(I2C.Port port, Accelerometer.Range range, int deviceAddress) {
        this.m_i2c = new I2C(port, deviceAddress);
        this.m_i2c.write(45, 8);
        this.setRange(range);
        HAL.report(5, 2);
        LiveWindow.addSensor("ADXL345_I2C", port.value, (LiveWindowSendable)this);
    }

    @Override
    public void setRange(Accelerometer.Range range) {
        int value;
        switch (range) {
            case k2G: {
                value = 0;
                break;
            }
            case k4G: {
                value = 1;
                break;
            }
            case k8G: {
                value = 2;
                break;
            }
            case k16G: {
                value = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)range) + " unsupported range type");
            }
        }
        this.m_i2c.write(49, 8 | value);
    }

    @Override
    public double getX() {
        return this.getAcceleration(Axes.kX);
    }

    @Override
    public double getY() {
        return this.getAcceleration(Axes.kY);
    }

    @Override
    public double getZ() {
        return this.getAcceleration(Axes.kZ);
    }

    public double getAcceleration(Axes axis) {
        ByteBuffer rawAccel = ByteBuffer.allocateDirect(2);
        this.m_i2c.read(50 + axis.value, 2, rawAccel);
        rawAccel.order(ByteOrder.LITTLE_ENDIAN);
        return (double)rawAccel.getShort(0) * 0.00390625;
    }

    public AllAxes getAccelerations() {
        AllAxes data = new AllAxes();
        ByteBuffer rawData = ByteBuffer.allocateDirect(6);
        this.m_i2c.read(50, 6, rawData);
        rawData.order(ByteOrder.LITTLE_ENDIAN);
        data.XAxis = (double)rawData.getShort(0) * 0.00390625;
        data.YAxis = (double)rawData.getShort(2) * 0.00390625;
        data.ZAxis = (double)rawData.getShort(4) * 0.00390625;
        return data;
    }

    @Override
    public String getSmartDashboardType() {
        return "3AxisAccelerometer";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("X", this.getX());
            this.m_table.putNumber("Y", this.getY());
            this.m_table.putNumber("Z", this.getZ());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }

    public static class AllAxes {
        public double XAxis;
        public double YAxis;
        public double ZAxis;
    }

    public static enum Axes {
        kX(0),
        kY(2),
        kZ(4);

        public final byte value;

        private Axes(byte value) {
            this.value = value;
        }
    }
}

