/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.cscore;

import edu.wpi.cscore.CameraServerJNI;
import edu.wpi.cscore.VideoMode;
import edu.wpi.cscore.VideoProperty;
import edu.wpi.cscore.VideoSource;
import org.opencv.core.Mat;

public class CvSource
extends VideoSource {
    public CvSource(String name, VideoMode mode) {
        super(CameraServerJNI.createCvSource(name, mode.pixelFormat.getValue(), mode.width, mode.height, mode.fps));
    }

    public CvSource(String name, VideoMode.PixelFormat pixelFormat, int width, int height, int fps) {
        super(CameraServerJNI.createCvSource(name, pixelFormat.getValue(), width, height, fps));
    }

    public void putFrame(Mat image) {
        CameraServerJNI.putSourceFrame(this.m_handle, image.nativeObj);
    }

    public void notifyError(String msg) {
        CameraServerJNI.notifySourceError(this.m_handle, msg);
    }

    public void setConnected(boolean connected) {
        CameraServerJNI.setSourceConnected(this.m_handle, connected);
    }

    public void setDescription(String description) {
        CameraServerJNI.setSourceDescription(this.m_handle, description);
    }

    public VideoProperty createProperty(String name, VideoProperty.Kind kind, int minimum, int maximum, int step, int defaultValue, int value) {
        return new VideoProperty(CameraServerJNI.createSourceProperty(this.m_handle, name, kind.getValue(), minimum, maximum, step, defaultValue, value));
    }

    public void SetEnumPropertyChoices(VideoProperty property, String[] choices) {
        CameraServerJNI.setSourceEnumPropertyChoices(this.m_handle, property.m_handle, choices);
    }
}

