/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.cscore;

import edu.wpi.cscore.UsbCameraInfo;
import edu.wpi.cscore.VideoEvent;
import edu.wpi.cscore.VideoMode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.opencv.core.Core;

public class CameraServerJNI {
    static boolean libraryLoaded = false;
    static boolean cvLibraryLoaded = false;
    static File jniLibrary = null;

    public static native int getPropertyKind(int var0);

    public static native String getPropertyName(int var0);

    public static native int getProperty(int var0);

    public static native void setProperty(int var0, int var1);

    public static native int getPropertyMin(int var0);

    public static native int getPropertyMax(int var0);

    public static native int getPropertyStep(int var0);

    public static native int getPropertyDefault(int var0);

    public static native String getStringProperty(int var0);

    public static native void setStringProperty(int var0, String var1);

    public static native String[] getEnumPropertyChoices(int var0);

    public static native int createUsbCameraDev(String var0, int var1);

    public static native int createUsbCameraPath(String var0, String var1);

    public static native int createHttpCamera(String var0, String var1, int var2);

    public static native int createHttpCameraMulti(String var0, String[] var1, int var2);

    public static native int createCvSource(String var0, int var1, int var2, int var3, int var4);

    public static native int getSourceKind(int var0);

    public static native String getSourceName(int var0);

    public static native String getSourceDescription(int var0);

    public static native long getSourceLastFrameTime(int var0);

    public static native boolean isSourceConnected(int var0);

    public static native int getSourceProperty(int var0, String var1);

    public static native int[] enumerateSourceProperties(int var0);

    public static native VideoMode getSourceVideoMode(int var0);

    public static native boolean setSourceVideoMode(int var0, int var1, int var2, int var3, int var4);

    public static native boolean setSourcePixelFormat(int var0, int var1);

    public static native boolean setSourceResolution(int var0, int var1, int var2);

    public static native boolean setSourceFPS(int var0, int var1);

    public static native VideoMode[] enumerateSourceVideoModes(int var0);

    public static native int[] enumerateSourceSinks(int var0);

    public static native int copySource(int var0);

    public static native void releaseSource(int var0);

    public static native void setCameraBrightness(int var0, int var1);

    public static native int getCameraBrightness(int var0);

    public static native void setCameraWhiteBalanceAuto(int var0);

    public static native void setCameraWhiteBalanceHoldCurrent(int var0);

    public static native void setCameraWhiteBalanceManual(int var0, int var1);

    public static native void setCameraExposureAuto(int var0);

    public static native void setCameraExposureHoldCurrent(int var0);

    public static native void setCameraExposureManual(int var0, int var1);

    public static native String getUsbCameraPath(int var0);

    public static native int getHttpCameraKind(int var0);

    public static native void setHttpCameraUrls(int var0, String[] var1);

    public static native String[] getHttpCameraUrls(int var0);

    public static native void putSourceFrame(int var0, long var1);

    public static native void notifySourceError(int var0, String var1);

    public static native void setSourceConnected(int var0, boolean var1);

    public static native void setSourceDescription(int var0, String var1);

    public static native int createSourceProperty(int var0, String var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static native void setSourceEnumPropertyChoices(int var0, int var1, String[] var2);

    public static native int createMjpegServer(String var0, String var1, int var2);

    public static native int createCvSink(String var0);

    public static native int getSinkKind(int var0);

    public static native String getSinkName(int var0);

    public static native String getSinkDescription(int var0);

    public static native void setSinkSource(int var0, int var1);

    public static native int getSinkSourceProperty(int var0, String var1);

    public static native int getSinkSource(int var0);

    public static native int copySink(int var0);

    public static native void releaseSink(int var0);

    public static native String getMjpegServerListenAddress(int var0);

    public static native int getMjpegServerPort(int var0);

    public static native void setSinkDescription(int var0, String var1);

    public static native long grabSinkFrame(int var0, long var1);

    public static native long grabSinkFrameTimeout(int var0, long var1, double var3);

    public static native String getSinkError(int var0);

    public static native void setSinkEnabled(int var0, boolean var1);

    public static native int addListener(Consumer<VideoEvent> var0, int var1, boolean var2);

    public static native void removeListener(int var0);

    public static native void setLogger(LoggerFunction var0, int var1);

    public static native UsbCameraInfo[] enumerateUsbCameras();

    public static native int[] enumerateSources();

    public static native int[] enumerateSinks();

    public static native String getHostname();

    public static native String[] getNetworkInterfaces();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (!libraryLoaded) {
            try {
                System.loadLibrary("cscore");
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    String osname = System.getProperty("os.name");
                    String resname = osname.startsWith("Windows") ? "/Windows/" + System.getProperty("os.arch") + "/" : "/" + osname + "/" + System.getProperty("os.arch") + "/";
                    System.out.println("platform: " + resname);
                    resname = osname.startsWith("Windows") ? resname + "cscore.dll" : (osname.startsWith("Mac") ? resname + "libcscore.dylib" : resname + "libcscore.so");
                    InputStream is = CameraServerJNI.class.getResourceAsStream(resname);
                    if (is != null) {
                        jniLibrary = System.getProperty("os.name").startsWith("Windows") ? File.createTempFile("CameraServerJNI", ".dll") : (System.getProperty("os.name").startsWith("Mac") ? File.createTempFile("libCameraServerJNI", ".dylib") : File.createTempFile("libCameraServerJNI", ".so"));
                        jniLibrary.deleteOnExit();
                        FileOutputStream os = new FileOutputStream(jniLibrary);
                        byte[] buffer = new byte[1024];
                        try {
                            int readBytes;
                            while ((readBytes = is.read(buffer)) != -1) {
                                ((OutputStream)os).write(buffer, 0, readBytes);
                            }
                        }
                        finally {
                            ((OutputStream)os).close();
                            is.close();
                        }
                        System.load(jniLibrary.getAbsolutePath());
                    }
                    System.loadLibrary("cscore");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
            libraryLoaded = true;
            if (!cvLibraryLoaded) {
                try {
                    System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
                }
                catch (UnsatisfiedLinkError ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                cvLibraryLoaded = true;
            }
        }
    }

    @FunctionalInterface
    public static interface LoggerFunction {
        public void apply(int var1, String var2, int var3, String var4);
    }
}

