import React from "react"
import ReactDOM from "react-dom"
import { Provider } from "react-redux"
import { ToastContainer } from "react-toastify"
import "react-toastify/dist/ReactToastify.css"
import "semantic-ui-css/semantic.min.css"
import App from "./App"
import "./index.css"
import store from "./redux/store"
import * as serviceWorker from "./render/serviceWorker"

ReactDOM.render(
    <Provider store={store}>
        <App />
        <ToastContainer position="bottom-right" />
    </Provider>,
    document.getElementById("root")
)

// If you want your app to work offline and load faster, you can change
// unregister() to register() below. Note this comes with some pitfalls.
// Learn more about service workers: https://bit.ly/CRA-PWA
serviceWorker.unregister()
