[![Awesome](images/awesome.svg)](https://github.com/sindresorhus/awesome)
[![Maintenance](https://img.shields.io/badge/Maintained%3F-YES-green.svg)](https://github.com/EthicalML/awesome-artificial-intelligence-guidelines/graphs/commit-activity)
![GitHub](https://img.shields.io/badge/Release-PROD-yellow.svg)
![GitHub](https://img.shields.io/badge/Languages-MULTI-blue.svg)
![GitHub](https://img.shields.io/badge/License-MIT-lightgrey.svg)
[![GitHub](https://img.shields.io/twitter/follow/axsaucedo.svg?label=Follow)](https://twitter.com/AxSaucedo/)


<table>
<tr>
<td width="60%">
<h1>Awesome AI Regulation, Principles & Guidelines</h1>
</td>
<td>
<a href="https://youtu.be/dKjCWfuvYxQ?t=147"><img src="images/bosstown.gif"></a> <br> (AKA Writing AI Responsibly)
</td>
</td>
</table>

## Overview

As AI systems become more prevalent in society, we face bigger and tougher societal challenges. Given many of these challenges have not been faced before, practitioners will face scenarios that will require dealing with hard ethical and societal questions.

There has been a large amount of content published which attempts to address these issues through “Principles”, “Ethics Frameworks”, “Checklists” and beyond. However navigating the broad number of resources is not easy. 

This repository aims to simplify this by mapping the ecosystem of guidelines, principles, codes of ethics, standards and regulation being put in place around artificial intelligence.

## Quick links to sections in this page

### National Regulation by Economic Area

| | | |
|-|-|-|
|[Austria 🇦🇹](#austria)|[Brazil 🇧🇷](#brazil)|[Canada 🇨🇦](#canada)|[China 🇨🇳](#china)|
|[Israel 🇮🇱](#israel)|[European Union 🇪🇺](#european-union)|[India 🇮🇳](#india)|
|[Mexico 🇲🇽](#mexico)|[Singapore 🇸🇬](#singapore)|[United Arab Emirates 🇦🇪](#united-arab-emirates)|
|[United States of America 🇺🇸](#united-states-of-america)|[United Kingdom 🇬🇧](#united-kingdom)||

### Other Sections

| | | |
|-|-|-|
|[🔍 High Level Frameworks & Principles](#high-level-frameworks-and-principles) |[🔏 Processes & Checklists](#processes-and-checklists) | [🔨 Interactive & Practical Tools](#interactive-and-practical-tools)|
|[📜 Industry standards initiatives](#industry-standards-initiatives)|[📚 Online Courses](#online-courses-and-learning-resources)|[🤖 Research and Industry Newsletters](#research-and-industry-newsletters)|

## Other relevant resources

<table>
  <tr>
    <td width="30%">
         You can join the <a href="https://ethical.institute/mle.html">Machine Learning Engineer</a> newsletter. You will receive updates on open source frameworks, tutorials and articles curated by machine learning professionals.
    </td>
    <td width="70%">
        <a href="https://ethical.institute/mle.html"><img src="images/mleng.png"></a>
    </td>
  </tr>
</table>


# Regulation and Policy

## Austria

* [Artificial Intelligence Mission Austria 2030](https://www.bmk.gv.at/themen/innovation/publikationen/ikt/ai/aimat.html) - Shaping the Future of Artificial Intelligence in Austria. The Austrian ministry for Innovation and Technology published their vision for AI until 2030.

## Canada

* [Artificial Intelligence and Data Act (AIDA)](https://github.com/EthicalML/awesome-artificial-intelligence-regulation/tree/master?tab=readme-ov-file#european-union) - An Act to enact the Consumer Privacy Protection Act, the Personal Information and Data Protection Tribunal Act and the Artificial Intelligence and Data Act and to make consequential and related amendments to other Acts

## Brazil

* [Brazilian AI Regulation (PL 2338/2023)](https://www25.senado.leg.br/web/atividade/materias/-/materia/157233): A proposed bill in Brazil aiming to establish a comprehensive framework for the development and use of artificial intelligence, emphasizing transparency, accountability, and alignment with international standards.

## China

* [Beijing AI Principles](https://www.baai.ac.cn/blog/beijing-ai-principles) - initiative for the research, development, use, governance and long-term planning of AI, calling for its healthy development to support the construction of a human community with a shared future, and the realization of beneficial AI for humankind and nature.
* [China's Interim Measures for the Management of Generative Artificial Intelligence Services](https://www.cac.gov.cn/2023-07/13/c_1690898327029107.htm) - The first administrative regulation on the management of Generative AI services, which came into effect on August 15, 2023.
* [China Internet Security Law](https://en.wikipedia.org/wiki/China_Internet_Security_Law) - China's law which enacted to increase cybersecurity and national security, safeguard cyberspace sovereignty and public interest, protect the legitimate rights and interests of citizens, legal persons and other organisations, and promote healthy economic and social development (and was argued by the Chinese ministry for industry and information that this law justified the means of pursuing the "Going Out" strategy China has persisted on ever since 1999). [KPMG's summary of the Cybersecurity Law](https://assets.kpmg/content/dam/kpmg/cn/pdf/en/2017/02/overview-of-cybersecurity-law.pdf). Center for strategic & international studies [overview of China's new Data Privacy law](https://www.csis.org/analysis/new-china-data-privacy-standard-looks-more-far-reaching-gdpr)
* [China's Personal Information Security Specification (Translation)](https://www.newamerica.org/cybersecurity-initiative/digichina/blog/translation-chinas-personal-information-security-specification/) - The Chinese Government's first major digital privacy rules which took effect in May 2018, which lays out granular guidelines for consent and how personal data should be collected, used and shared. Center for strategic & international studies [overview of the specification](https://www.csis.org/analysis/chinas-emerging-data-privacy-system-and-gdpr) 
* [China's Administrative Provisions on Information Services on Microblogs](http://en.pkulaw.cn/display.aspx?cgid=309714&lib=law) - China's provisions which require microblogging sites (social media sites) to obtain relevant credentials by law, verify users' real identities, establish mechanisms for dispelling and refuting rumors, etc. [Summary of rules](https://www.loc.gov/law/foreign-news/article/china-rules-regulating-microblogs-issued/) by the US Law Library of Congress.
* [Decision on strengthening the protection of online information](https://www.globalprivacyblog.com/privacy/chinas-legislature-adopts-decision-on-strengthening-the-protection-of-online-information/) - The Standing Committee of the National People's Congress (NPC) of the People's Republic of China adopted the decision on strengthening the protection of online information - this is an act that contains 12 clauses applicable to entities both in the public and private sectors in respect to the collection and processing of electronic personal information on the internet.
* [Personal Data Protection Act](https://law.moj.gov.tw/ENG/LawClass/LawAll.aspx?pcode=I0050021) - The personal data protection act of the Republic of China, which is enacted to regulate the collection, processing and use of personal data as so to prevent harm on personality rights, and to facilitate the proper use of personal data.

## Israel

* [The principles of the policy for the responsible development of the field of AI](https://www.gov.il/en/pages/most-news20221117) - The draft policy for regulation and ethics in the field of artificial intelligence, with an emphasis on “responsible innovation”, is intended to ensure the advancement of the industry while safeguarding the public interest

## Dubai

* [Smart Dubai Artificial Intelligence Principles and Ethics - Ethical AI Toolkit](https://www.smartdubai.ae/initiatives/ai-principles-ethics) - created to provide practical help across a city ecosystem. It supports industry, academia and individuals in understanding how AI systems can be used responsibly. It consists of principles and guidelines, and a self-assessment tool for developers to assess their platforms.


## European Union

* [Ethics Guidelines for Trustworthy AI](https://ec.europa.eu/futurium/en/ai-alliance-consultation) - European Commission document prepared by the High-Level Expert Group on Artificial Intelligence (AI HLEG).
* [EU AI Act](https://artificialintelligenceact.eu/) - The EU Artificial Intelligence (AI) Act is a legal framework that regulates AI in the European Union; this was the first regulation implemented on AI ([overview](https://www.europarl.europa.eu/topics/en/article/20230601STO93804/eu-ai-act-first-regulation-on-artificial-intelligence)).
* [General Data Protection Regulation GDPR](https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=celex%3A32016R0679) - Legal text for the EU GDPR regulation 2016/679 of the European Parliament and of the Council of 27 April 2016 on the protection of natural persons with regard to the processing of personal data and on the free movement of such data, and repealing Directive 95/46/EC
* [GDPR.EU Guide](https://gdpr.eu/) - A project co-funded by the Horizon 2020 Framework programme of the EU which provides a resource for organisations and individuals researching GDPR, including a library of straightforward and up-to-date information to help organisations achieve GDPR compliance ([Legal Text](https://www.govinfo.gov/content/pkg/USCODE-2012-title5/pdf/USCODE-2012-title5-partI-chap5-subchapII-sec552a.pdf)).

## India

* [The National Strategy for Artificial Intelligence](https://www.niti.gov.in/sites/default/files/2023-03/National-Strategy-for-Artificial-Intelligence.pdf) - The approach in this paper focuses on how India can leverage the transformative technologies to ensure social and inclusive growth in line with the development philosophy of the government. In addition, India should strive to replicate these solutions in other similarly placed developing countries.
* [The Principles for Responsible AI](https://www.niti.gov.in/sites/default/files/2021-02/Responsible-AI-22022021.pdf) - The paper incorporates insights, feedback and experiences consolidated through inter-ministerial consultations, large-scale global multi-stakeholder consultations and a series of 1-1 consultations with AI ethics experts in India and globally, as well as wider public consultations, conducted over the last 15 months. This paper is meant to serve as an essential roadmap for the AI ecosystem, encouraging adoption of AI in a responsible manner in India and building public trust in the use of this technology, placing the idea of ‘AI for All’ at its very core.

## Mexico

* [Artificial Intelligence National Agenda Proposal for Mexico](https://www.ania.org.mx/_files/ugd/447d95_c7e6ebee6cf44b38a0d386cc9534f6e5.pdf) - Recommendations for multi-faceted commitment to guide the development and use of artificial intelligence in Mexico in an ethical and responsible manner.

## Singapore

* [Data Protection Act 2012](https://sso.agc.gov.sg/Act/PDPA2012) - The Personal Data Protection Act 2012 (the "Act") sets out the law on data protection in Singapore. Apart from establishing a general data protection regime, the Act also regulates telemarketing practices.
* [Protection from Online Falsehoods and Manipulation Act 2019](https://sso.agc.gov.sg/Acts-Supp/18-2019/Published/20190625?DocDate=20190625) - An act to prevent the electronic communication in Singapore of false statements of fact, to suppress support for and counteract the effects of such communication, to safeguard against the use of online accounts for such communication and for information manipulation, to enable measures to be taken to enhance transparency of online political advertisements and for related matters.

## United Arab Emirates

* [UAE National Strategy for AI](https://ai.gov.ae/wp-content/uploads/2021/07/UAE-National-Strategy-for-Artificial-Intelligence-2031.pdf) - This paper outlines the UAE's ambitions to become a fast adopter of emerging AI technologies across Government, as well as attract top AI talent to experiment with new technologies and work in a sophisticated, secure ecosystem to solve complex problems.

## United States of America

* [The White House Executive Order in AI](https://www.whitehouse.gov/briefing-room/presidential-actions/2023/10/30/executive-order-on-the-safe-secure-and-trustworthy-development-and-use-of-artificial-intelligence/) - The USA Executive Order on the Safe, Secure, and Trustworthy Development and Use of Artificial Intelligence 
* [California Consumer Privacy Act (CCPA)](http://leginfo.legislature.ca.gov/faces/billCompareClient.xhtml?bill_id=201720180AB375) - Legal text for California's consumer privacy act
* [EU-U.S. and Swiss-U.S. Privacy Shield Frameworks](https://www.privacyshield.gov/welcome) - The EU-U.S. and Swiss-U.S. Privacy Shield Frameworks were designed by the U.S. Department of Commerce and the European Commission and Swiss Administration to provide companies on both sides of the Atlantic with a mechanism to comply with data protection requirements when transferring personal data from the European Union and Switzerland to the United States in support of transatlantic commerce.
* [Fair Credit Reporting Act 2018](https://www.ftc.gov/enforcement/statutes/fair-credit-reporting-act) - The Fair Reporting Act is a federal law that regulates the collection of consumers' credit information and access to their credit reports.
* [Gramm-Leach-Billey Act (for financial institutions)](https://www.ftc.gov/tips-advice/business-center/privacy-and-security/gramm-leach-bliley-act) - The Graham-Leach-Billey Act requires financial institutions (companies that offer consumers financial projects or services like loans, financial, or investment advice, or insurance) to explain their information-sharing practices to their customers and to safeguard sensitive data.
* [Health Insurance Portability and Accountability Act of 1996](https://www.hhs.gov/hipaa/for-professionals/security/laws-regulations/index.html) - The HIPAA required the secretary of the US department of health and human services (HHS) to develop regulations protecting the privacy and security of certain health information, which then HHS published what is known as the HIPAA [Privacy Rule](https://www.hhs.gov/hipaa/for-professionals/privacy/index.html), and the HIPAA [Security Rule](https://www.hhs.gov/hipaa/for-professionals/security/index.html).
* [Executive Order on Maintaining American Leadership in AI](https://www.whitehouse.gov/presidential-actions/executive-order-maintaining-american-leadership-artificial-intelligence/) - Official mandate by the President of the US to 
* [Privacy Act of 1974](https://www.justice.gov/opcl/privacy-act-1974) - The privacy act of 1974 which establishes a code of fair information practices that governs the collection, maintenance, use and dissemination of information about individuals that is maintained in systems of records by federal agencies.
* [Privacy Protection Act of 1980](https://epic.org/privacy/ppa/) - The Privacy Protection Act of 1980 protects journalists from being required to turn over to law enforcement any work product and documentary materials, including sources, before it is disseminated to the public.
* [DoD's Ethical Principles for AI](https://www.diu.mil/responsible-ai-guidelines) - The U.S.A. Department of Defense responsible AI guidelines for tech contractors. The guidelines provide a step-by-step process to follow during the planning, development, and deployment phases of the technical lifecycle. 


## United Kingdom

* [UK's AI regulation: a pro-innovation approach](https://www.gov.uk/government/publications/ai-regulation-a-pro-innovation-approach) - This white paper details the UK's plans for implementing a pro-innovation approach to AI regulation.
* [UK Data Protection Act of 2018](http://www.legislation.gov.uk/ukpga/2018/12/contents/enacted) - The DPA 2018 enacts the GDPR into UK Law, however in doing so has included various "derogations" as permitted by the GDPR, resulting in some key differenced (which although small are not of insignificance impact and may have a greater impact after Brexit).
* [The Information Commissioner's Office guide to Data Protection](https://ico.org.uk/for-organisations/guide-to-data-protection/) - This guide is for data protection officers and others who have day-to-day responsibility for data protection. It is aimed at small and medium-sized organisations, but it may be useful for larger organisations too.

# High Level Frameworks and Principles

* [AI & Machine Learning 8 principles for Responsible ML](https://ethical.institute/principles.html) - The Institute for Ethical AI & Machine Learning has put together 8 principles for responsible machine learning that are to be adopted by individuals and delivery teams designing, building and operating machine learning systems.
* [An Evaluation of Guidelines - The Ethics of Ethics](https://arxiv.org/ftp/arxiv/papers/1903/1903.03425.pdf) - A research paper that analyses multiple Ethics principles
* [Association for Computer Machinery's Code of Ethics and Professional Conduct](https://www.acm.org/code-of-ethics) - This is the code of ethics that has been put together in 1992 by the Association for Computer Machinery and updated in 2018. The Code is designed to inspire and guide the ethical conduct of all computing professionals, including current and aspiring practitioners, instructors, students, influencers, and anyone who uses computing technology in an impactful way. Additionally, the Code serves as a basis for remediation when violations occur. The Code includes principles formulated as statements of responsibility, based on the understanding that the public good is always the primary consideration.
* [From What to How: An initial review of publicly available AI Ethics Tools, Methods and Research to translate principles into practices](https://arxiv.org/abs/1905.06876) - A paper published by the UK Digital Catapult that aims to identify and present the gap between principles and their practical applications.
* [European Commission's Guidelines for Trustworthy AI](https://digital-strategy.ec.europa.eu/en/library/ethics-guidelines-trustworthy-ai) - The Ethics Guidelines for Trustworthy Artificial Intelligence (AI) is a document prepared by the High-Level Expert Group on Artificial Intelligence (AI HLEG). This independent expert group was set up by the European Commission in June 2018, as part of the AI strategy announced earlier that year.
* [IEEE's Ethically Aligned Design](https://ethicsinaction.ieee.org/) - A Vision for Prioritizing Human Wellbeing with Artificial Intelligence and Autonomous Systems that encourages technologists to prioritize ethical considerations in the creation of autonomous and intelligent technologies.
* [Montréal Declaration for a responsible development of artificial intelligence](https://www.montrealdeclaration-responsibleai.com/the-declaration) -  ethical principles and values that promote the fundamental interests of people and group created as an initiative by Université de Montréal 
* [Oxford's Recommendations for AI Governance](https://www.fhi.ox.ac.uk/wp-content/uploads/Standards_-FHI-Technical-Report.pdf) - A set of recommendations from Oxford's Future of Humanity institute which focus on the infrastructure and attributes required for efficient design, development, and research around the ongoing work building & implementing AI standards.
* [PWC's Responsible AI](https://www.pwc.com/gx/en/issues/data-and-analytics/artificial-intelligence/what-is-responsible-ai.html) - PWC has put together a survey and a set of principles that abstract some of the key areas they've identified for responsible AI.
* [Singapore Data Protection Govt Commission's AI Governance Principles](https://www.pdpc.gov.sg/help-and-resources/2020/01/model-ai-governance-framework) - The Singapore government's Personal Data Protection Commission has put together a set of guiding principles towards data protection and human involvement in automated systems, and comes with a report that breaks down the [guiding principles and motivations](https://www.pdpc.gov.sg/-/media/Files/PDPC/PDF-Files/Resource-for-Organisation/AI/Primer-for-2nd-edition-of-AI-Gov-Framework.pdf?la=en).
* [Toronto Declaration](https://www.accessnow.org/the-toronto-declaration-protecting-the-rights-to-equality-and-non-discrimination-in-machine-learning-systems/) Protecting the right to equality and non-discrimination in machine learning systems by accessnow. 
* [UK Government's Data Ethics Framework Principles](https://www.gov.uk/government/publications/data-ethics-framework/data-ethics-framework) - A resource put together by the Department for Digital, Culture, Media and Sport (DCMS) which outlines an overview of data ethics, together with a 7-principle framework.
* [Algorithm charter for Aotearoa New Zealand](https://data.govt.nz/use-data/data-ethics/government-algorithm-transparency-and-accountability/algorithm-charter) - The  Algorithm  Charter  for  Aotearoa  New  Zealand  is  an  evolving piece of work that needs to respond to emerging technologies  and  also  be  fit-for-purpose  for  government  agencies.  
* [Montreal AI Ethics Institute State of AI Ethics June 2020 Report](https://montrealethics.ai/the-state-of-ai-ethics-report-june-2020/) - A resource put together by the [Montreal AI Ethics Institute](https://montrealethics.ai) that captures the most relevant research and reporting in the domain of AI ethics between March 2020 and June 2020.
* [Montreal AI Ethics Institute State of AI Ethics October 2020 Report](https://montrealethics.ai/oct2020/) - A resource put together by the [Montreal AI Ethics Institute](https://montrealethics.ai) that captures the most relevant research and reporting in the domain of AI ethics between July 2020 and October 2020.
* [Technical and Organizational Best Practices](https://www.fbpml.org/the-best-practices/the-best-practices) - A resource put together by [Foundation for Best Practices in Machine Learning (FBPML)](https://www.fbpml.org/) with technical guidelines (e.g. fairness and non-discrimination, monitoring and maintenance, data quality, product traceability, explainability) and organizational guidelines (e.g. data governance, product management, human resources management, compliance and auditing). Community contributions are welcome via the [FBPML Wiki](https://wiki.fbpml.org/wiki/Main_Page).
* [Understanding artificial intelligence ethics and safety](https://www.turing.ac.uk/research/publications/understanding-artificial-intelligence-ethics-and-safety) - A guide for the responsible design and implementation of AI systems in the public sector by David Leslie from the [Alan Turing Institute](https://www.turing.ac.uk/). 
* [Declaration for responsible and intelligent data practice](https://www.declaration.org.uk/) - a shared vision of what best practice in data looks like by [Open Data Manchester](https://www.opendatamanchester.org.uk/).
* [Recommendation on the Ethics of Artificial Intelligence](https://unesdoc.unesco.org/ark:/48223/pf0000381137) - The Recommendation by the UNESCO is a comprehensive international framework aiming to shape the development and use of AI technologies and establishes a set of values in line with the promotion and protection of human rights, human dignity, and environmental sustainability. It has been adopted by acclamation by 193 Member States at UNESCO’s General Conference in November 2021. For more information, refer to UNESCO's 2023 publication on key facts [here](https://www.unesco.org/en/articles/unescos-recommendation-ethics-artificial-intelligence-key-facts).

# Processes and Checklists

* [AI RFX Procurement Framework](https://ethical.institute/rfx.html) - A procurement framework for evaluating the maturity of machine learning systems put together by cross functional teams of academics, industry practitioners and technical individuals at The Institute for Ethical AI & Machine Learning to empower industry practitioners looking to procure machine learning suppliers.
* [Checklist for data science projects](http://deon.drivendata.org/) – Deon by DrivenData is a command line tool that allows you to easily add an ethics checklist to your data science projects.
* [Designing Ethical AI Experiences Checklist and Agreement](https://resources.sei.cmu.edu/library/asset-view.cfm?assetid=636620) - document to guide the development of accountable, de-risked, respectful, secure, honest, and usable artificial intelligence (AI) systems with a diverse team aligned on shared ethics. Carnegie Mellon University, Software Engineering Institute.
* [Ethical OS Toolkit](https://ethicalos.org/) - A toolkit that dives into 8 risk zones to assess the potential challenges that a technology team may face, together with 14 scenarios to provide examples, and 7 future-proofing strategies to help take ethical action.
* [Ethics Canvas](https://www.ethicscanvas.org/index.html) - A resource inspired by the traditional business canvas, which provides an interactive way to brainstorm potential risks, opportunities and solutions to ethical challenges that may be faced in a project using post-it note-like approach.
* [Kat Zhou's Design Ethically Resources](https://www.designethically.com/toolkit) - A set of workshops that can be organised across teams to identify challenges, assess current risks and take action on potential issues around ethical challenges that may be faced.
* [Markula Center's Ethical Toolkit for Engineering/Design Practice](https://www.scu.edu/ethics-in-technology-practice/ethical-toolkit/) - A practical and comprehensible toolkit with seven components to aid practitioners reflect, and judge the moral grounds in which they are operating.
* [San Francisco City's Ethics & Algorithms Toolkit](https://ethicstoolkit.ai/) - A risk management framework for government leaders and staff who work with algorithms, providing a two part assessment process including an algorithmic assessment process, and a process to address the risks.
* [UK Government's Data Ethics Workbook](https://www.gov.uk/government/publications/data-ethics-workbook/data-ethics-workbook) - A resource put together by the Department for Digital, Culture, Media and Sport (DCMS) which provides a set of questions that can be asked by practitioners in the public sector, which address each of the principles in their [Data Ethics Framework Principles](https://www.gov.uk/government/publications/data-ethics-framework/data-ethics-framework).
* [World Economic Forum's Guidelines for Procurement](https://www.weforum.org/press/2019/09/uk-government-first-to-pilot-ai-procurement-guidelines-co-designed-with-world-economic-forum/) - The WEF has put together a set of guidelines for governments to be able to safely and reliably procure machine learning related systems, which has been trialled with the UK government.
* [Machine Learning Assurance](https://monitaur.ai/blog/machine-learning-assurance/) - Quick look at machine learning assurance: process of recording, understanding, verifying, and auditing machine learning models and their transactions.
* [ODEP's Checklist for Employers: Facilitating the Hiring of People with Disabilities Through the Use of eRecruiting Screening Systems, Including AI](https://www.peatworks.org/wp-content/uploads/2020/10/EARN_PEAT_eRecruiting_Checklist.pdf) - The Employer Assistance and Resource Network on Disability Inclusion (EARN) and the Partnership on Employment & Accessible Technology (PEAT), which are both funded through the U.S. Department of Labor's Office of Disability Employment Policy (ODEP), collaborated on an inclusive AI checklist for employers. The checklist provides direction for leadership, human resources personnel, equal employment opportunity managers, and procurement officers for reviewing AI tools used in recruiting and candidate assessment for fairness and inclusion of individuals with disabilities.
* [Microsoft AI Fairness Checklist](https://www.microsoft.com/en-us/research/project/ai-fairness-checklist/)
* [US NIST AI Risk Management Framework](https://www.nist.gov/itl/ai-risk-management-framework) - The Framework is intended to help developers, users and evaluators of AI systems better manage AI risks which could affect individuals, organizations, society, or the environment.

# Interactive and Practical Tools

* [Aequitas' Bias & Fairness Audit Toolkit](http://aequitas.dssg.io/) - The Bias Report is powered by Aequitas, an open-source bias audit toolkit for machine learning developers, analysts, and policymakers to audit machine learning models for discrimination and bias, and make informed and equitable decisions around developing and deploying predictive risk-assessment tools. 
* [Awesome Machine Learning Production List](https://github.com/ethicalml/awesome-production-machine-learning) - A list of tools and frameworks that support the design, development and operation of production machine learning systems, currently maintained by The Institute for Ethical AI & Machine Learning.
* [Cape Python](https://github.com/capeprivacy/cape-python) - Easily apply privacy-enhancing techniques for data science and machine learning tasks in Pandas and Spark. Can be used in conjunction with [Cape Core](https://github.com/capeprivacy/cape) to collaborate on privacy policies and distribute those policies for data projects across teams and organizations.
* [eXplainability Toolbox](https://ethical.institute/xai.html) - The Institute for Ethical AI & Machine Learning proposal for an extended version of the traditional data science process which focuses on algorithmic bias and explainability, to ensure a baseline of risks around undesired biases can be mitigated.
* [FAT Forensics](https://fat-forensics.org/) is a Python toolkit for evaluating Fairness, Accountability and Transparency of Artificial Intelligence systems. It is built on top of SciPy and NumPy, and distributed under the 3-Clause BSD license (new BSD).
* [IBM's AI Explainability 360 Open Source Toolkit](http://aix360.mybluemix.net/) - This is IBM's toolkit that includes large number of examples, research papers and demos implementing several algorithms that provide insights on fairness in machine learning systems.
* [Linux Foundation AI Landscape](https://landscape.lfai.foundation/) - The official list of tools in the AI landscape curated by the Linux Foundation, which contains well maintained and used tools and frameworks. 
* [Taking action on digital ethics](https://www.avanade.com/en-us/thinking/research-and-insights/trendlines/digital-ethics) from Avanade
* [Microsoft Fairlearn](https://fairlearn.org/) - An open-source toolkit for assessing and improving fairness in machine learning products developed by Microsoft 
* [Microsoft Interpret ML](https://interpret.ml/) - An open-source toolkit for improving explainability/interpretability developed by Microsoft
* [Alibi](https://github.com/SeldonIO/alibi) - An open-source Python library for machine learning model inspection and interpretation. 

# Industry standards initiatives

* [ACS Code of Professional Conduct - PDF](https://www.acs.org.au/content/dam/acs/rules-and-regulations/Code-of-Professional-Conduct_v2.1.pdf) - Australian ICT (Information and Communication Technology) sector professional organization.
* [Association for Computer Machinery's Code of Ethics and Professional Conduct](https://www.acm.org/code-of-ethics) - This is the code of ethics that has been put together in 1992 by the Association for Computer Machinery and updated in 2018. The Code is designed to inspire and guide the ethical conduct of all computing professionals, including current and aspiring practitioners, instructors, students, influencers, and anyone who uses computing technology in an impactful way. Additionally, the Code serves as a basis for remediation when violations occur. The Code includes principles formulated as statements of responsibility, based on the understanding that the public good is always the primary consideration.
* [IEEE Global Initiative for Ethical Considerations in Artificial Intelligence (AI) and Autonomous Systems (AS)](https://ethicsinaction.ieee.org/) - IEEE Approved Standards Projects specifically focused on the Ethically Aligned Design principles, and includes 14 (P700X) standards which cover topics from data collection to privacy, to algorithmic bias and beyond.
* [ISO/IEC's Standards for Artificial Intelligence](https://www.iso.org/committee/6794475/x/catalogue/) - The ISO's initiative for Artificial Intelligence standards, which include a large set of subsequent standards ranging across Big Data, AI Terminology, Machine Learning frameworks, etc.

# Online Courses and Learning Resources

* [Udacity's Secure & Private AI Course](https://www.udacity.com/course/secure-and-private-ai--ud185) - Free course by Udacity which introduces three cutting-edge technologies for privacy-preserving AI: Federated Learning, Differential Privacy, and Encrypted Computation. 
* [Data science ethics](https://www.coursera.org/learn/data-science-ethics) - Free course by Prof. Jagadish from the University of Michigan (via Coursera) that covers data ownership, privacy and anonymity, data validity, and algorithmic fairness.
* [Practical Data Ethics](https://ethics.fast.ai/) - Free course by Rachel Thomas from the University of San Francisco Data Institute (via fast.ai) that covers disinformation, bias and fairness, foundations of ethics, privacy and surveillance, algorithmic colonialism
* [Bias and Discrimination in AI](https://www.edx.org/course/bias-and-discrimination-in-ai) - Free course by the University of Montreal and IVADO (via edX) about the discriminatory effects of algorithmic decision-making and responsible machine learning (institutional and technical strategies to identify and address bias). 
* [Intro to AI ethics](https://www.kaggle.com/learn/intro-to-ai-ethics) - Free course by Kaggle introducing the base concepts of ethics in AI and how to mitigate related problems.
* [Introduction to AI Safety, Ethics, and Society](https://www.aisafetybook.com/) - Developed by Dan Hendrycks, director of the [Center for AI Safety](https://www.safe.ai/), this free online textbook aims to provide an accessible introduction to students, practitioners and others looking to better understand issues pertaining to AI Safety and Ethics. Apart from online reading, this book is available as a PDF [here](https://www.aisafetybook.com/download) and also as a free virtual course [here](https://www.aisafetybook.com/virtual-course).

# Research and Industry Newsletters

* [Import AI](https://jack-clark.net/) - A newsletter curated by OpenAI's Jack Clark which curates the most resent and relevant AI research, as well as relevant societal issues that intersect with technical AI research.
* [Matt's thoughts in between](https://www.getrevue.co/profile/mattclifford) - Newsletter curated by Entrepreneur First CEO Matt Clifford that provides a curated critical analysis on topics surrounding geopolitics, deep tech startups, economics and beyond.
* [The Machine Learning Engineer](https://ethical.institute/mle.html) - A newsletter curated by The Institute for Ethical AI & Machine Learning that contains curated articles, tutorials and blog posts from experienced Machine Learning professionals and includes insights on best practices, tools and techniques in machine learning explainability, reproducibility, model evaluation, feature analysis and beyond.
* [Montreal AI Ethics Institute Weekly AI Ethics newsletter](https://aiethics.substack.com) - A weekly newsletter curated by [Abhishek Gupta](https://atg-abhishek.github.io) and his team at the [Montreal AI Ethics Institute](https://montrealethics.ai) that presents accessible summaries of technical and academic research papers along with commentary on the latest in the domain of AI ethics.
* [AI Safety Newsletter](https://newsletter.safe.ai/) - A weekly newsletter from the Center for AI Safety providing updates on AI research, policy, and other areas for a non-technical audience.
* [ML Safety Newsletter](https://newsletter.mlsafety.org/) - A newsletter from the Center for AI Safety providing occasional deep-dives on key results in technical AI research.




