# -------------------------------------------------------------------------
#
#  Part of the CodeChecker project, under the Apache License v2.0 with
#  LLVM Exceptions. See LICENSE for license information.
#  SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
#
# -------------------------------------------------------------------------

"""
Test the parsing of the sarif files.
"""


import os
import unittest

from codechecker_report_converter.report import report_file


gen_sarif_dir_path = os.path.join(
    os.path.dirname(__file__), 'sarif_test_files', 'gen_sarif')


class SarifParserTestCase(unittest.TestCase):
    """Test the parsing of the sarif generated by multiple clang versions."""

    @classmethod
    def setup_class(cls):
        """Initialize test source file."""
        # Already generated sarif files for the tests.
        cls.__this_dir = os.path.dirname(__file__)
        cls.__sarif_test_files = os.path.join(
            cls.__this_dir, 'sarif_test_files')

    def test_no_crash(self):
        """There was no bug in the checked file."""
        for root, _, files in os.walk(self.__sarif_test_files):
            for filename in files:
                if not filename.endswith(".sarif"):
                    continue
                abs_filename = os.path.join(root, filename)
                # We test for no crashes.
                report_file.get_reports(abs_filename)
