# Analyzer report identification

Unique report identifiers are required to compare analysis results. If an
analyzer (`Clang Static Analyzer`, `Clang Tidy`) does not generate a unique
report identifier (for example `Clang Tidy`), CodeChecker tries to generate
one.

It is recommended to use the identifier generated by the analyzers because they
can include the semantic context of the result better into the unique id.

**!!! WARNING !!!**: the same hash method should be used consistently for a
product. Mixing them can cause a lot of confusion when the compare or other
features are used.

## Hash generation methods

### Context sensitive
This is the default hash method for Clang Static Analyzer. The hashes are
calculated based on the following information:
  - **signature** of the enclosing function declaration, type declaration or
  namespace.
  - **content of the line** where the bug is.
  - **checker name** (e.g.: *core.DivideZero*, *core.NullDereference*, etc.).
  - **position** (column) within the line.

### Context insensitive
This is the default hash method for *Clang Tidy* reports. The hashes are
calculated based on the following information:

- **file name** (e.g.: *main.cpp*, *lib.cpp*, etc.).
- **checker name** (e.g.: *bugprone-infinite-loop*,
*clang-diagnostic-uninitialized* etc.).
- **checker message** (e.g: *variable 'ptr' is uninitialized when used here*,
etc.).
- **content of the line** where the bug is if it can be read up.
- **range column numbers** where the bug is.
- **range column numbers** of the bug steps.

### Context free
With this method the hash will not be changed so easily for example on code
indentation or when a checker is renamed.

You can override the default hash calculation method for reports by using the
`--report-hash` option of the `CodeChecker analyze` or the `CodeChecker check`
commands.

The following calculation methods are supported:
- [context-free](#context-free)
- [context-free-v2](#context-free-v2)

#### context-free
- In case of `Clang Tidy` the [Context insensitive](#context-sensitive) hash
method is used.
- In case of `Clang Static Analyzer` the [context-free-v2](#context-free-v2)
hash method is used.

**Important**: there was a bug and for `Clang Tidy` the default hash was
generated and not the context free hash. We kept this only for backward
compatibility reason. Use [context-free-v2](#context-free-v2) hash method
instead of this.

#### context-free-v2
The hashes are calculated based on the following information:
- **file name** (e.g.: *main.cpp*, *lib.cpp*, etc.).
- **checker name** (e.g.: *bugprone-infinite-loop*, *core.DivideZero* etc.).
- **content of the line** where the bug is if it can be read up. All the
whitespaces from the source content are removed.
- **range column numbers** where the bug is.

#### diagnostic-message
The hashes are calculated based on the following information:
- Same as `context-free-v2` (**file name**, **checker message** etc.)
- **bug step messages** (e.g.: *Calling 'foo'*, *Entered call from 'main'*
etc.).

**Note**: this is an experimental hash and it is not recommended to use it on
your project because this hash can change very easily for example on variable /
function renames.
