﻿using System;

namespace Epinova.ElasticSearch.Core
{
    public static class Constants
    {
        public const string EPiServerConnectionStringName = "EPiServerDB";
        public const string TrackingFieldIndex = "IndexName";
        public const string CommerceProviderName = "CatalogContent";
        public const string InvariantCultureIndexNamePostfix = "invariantculture";
        public const char IndexNameLanguageSplitChar = '¤';
        public const string IndexEPiServerContentDisplayName = "Elasticsearch: Index CMS content";
        public const string DefaultSynonym = "example_from,example_to";

        internal static readonly Version MinimumSupportedVersion = new Version(7, 3);
        
        // Plugin 'ingest-attachment' is included in Elastic for v8.4.
        public static readonly Version IngestAttachmentProcessorIncludedVersion = new Version(8, 4);

        internal static class Tracking
        {
            internal const string TableName = "ElasticTracking";

            internal static class Sql
            {
                internal const string Definition = "[Query] [nvarchar](400) NOT NULL, [Searches] [int] NOT NULL, [NoHits] [bit] NOT NULL, [Language] [nvarchar](10) NOT NULL, [IndexName] [nvarchar](200) NOT NULL";
                internal const string Update = "UPDATE [" + TableName + "] SET [Searches] = [Searches]+1, [NoHits] = @nohits WHERE [Query] = @query AND [Language] = @lang AND [IndexName] = @index";
                internal const string Insert = "INSERT INTO [" + TableName + "] ([Query], [Searches], [NoHits], [Language], [IndexName]) VALUES (@query, 1, @nohits, @lang, @index)";
                internal const string Delete = "DELETE FROM [" + TableName + "] WHERE Language = @lang AND [IndexName] = @index";
                internal const string Select = "SELECT [Query], [Searches] FROM [" + TableName + "] WHERE Language = @lang AND [IndexName] = @index";
                internal const string SelectNoHits = Select + " AND NoHits=1";
                internal const string Exists = "SELECT Query FROM [" + TableName + "] WHERE Query = @query AND Language = @lang AND [IndexName] = @index";
            }
        }
    }
}