---
id: storybook_stacks
title: Ensono Stacks Storybook
sidebar_label: Ensono Stacks Storybook
description: Using Ensono Stacks with Storybook
keywords:
  - Nx
  - monorepo
  - stacks
  - Generator
  - Executor
  - ensono
---

import Tabs from '@theme/Tabs';
import TabItem from '@theme/TabItem';

[Storybook](https://storybook.js.org/) is an open-source tool used to build, test, and showcase individual components or UI elements in isolation.

The primary purpose of Storybook is to facilitate the development and documentation of UI components in a sandboxed environment. Instead of integrating components into a full application, developers can create separate stories for each component, which are essentially individual test cases or scenarios that demonstrate the component's behaviour in different states and use cases.

Some of the benefits of Storybook include:

#### Component Isolation

Storybook allows developers to work on a single UI component in isolation, without the need to navigate through the whole application. This isolation helps in quicker development, debugging, and testing of components.

#### Visual Testing

Storybook provides a way to visually test components, making it simpler to catch UI-related bugs and regressions during development.

#### Interactive Documentation

Documentation, usage examples, and interactive demos can be added for each component, which helps in onboarding new team members and maintaining a comprehensive living style guide.

## Storybook with Ensono Stacks

Storybook can be added to Ensono Stacks using the __[Stacks Storybook generator](../getting_started/next/storybook)__.

