---
id: index
title: About Ensono Stacks
sidebar_label: About Ensono Stacks
slug: /
description: What is Ensono Stacks and how does it work
keywords:
  - ensono
  - stacks
  - open-source
  - solution
  - template
---

## What is Ensono Stacks

Ensono Stacks is an Ensono open-source project that automates the setup of software development projects. Ensono Stacks is for software engineers of all kinds who want to create projects quickly.

Setting up the infrastructure and frameworks necessary to deliver a software project takes time. A team might spend the first two weeks (sprint 0) making technical decisions, provisioning and configuring environments, pipelines, compute, test frameworks, and more. Ensono Stacks automates this setup using infrastructure-as-code to shrink your project's sprint 0 from two weeks to an hour or less.

<!-- markdownlint-disable MD026-->

## What can you do with Ensono Stacks?

Most software delivery projects start with a series of technical decisions:

- Which cloud provider should I use?
- What solution architecture do I need to build?
- What language should I code in?
- What test framework should I use?
- What about the CI/CD pipeline?
- What compute solution should I use?

Your tech choices in these six areas are what Ensono Stacks calls a _Workload_. For example:

- On Azure (cloud provider)
- I want to build a REST API (solution architecture)
- written in Java (language)
- using JUnit as the test framework
- and GitLab as the CI/CD pipeline
- and Alpine for the compute

When you run Ensono Stacks, it presents you with options in each of these six areas. Then, it instantly generates your chosen workload, complete with sample applications and cloud provisioning, if that's what you've selected. Ensono Stacks covers all the technical overhead, so you're ready to start coding. Ensono Stacks currently offers 15 unique workload variations with another 40 planned. Explore [What can you do with Ensono Stacks?](/#stacks-selector) to find out more.

## Why use Ensono Stacks

Massively shrinking sprint 0 Ensono Stacks gets you productive very quickly. First-time users should be up and running in an hour. Familiar users, with all the required software installed and cloud accounts set up, can get a boiler-plated solution up and running in the cloud in five minutes.

But there's more to Ensono Stacks than saving time. Ensono has thought deeply about the technology choices Ensono Stacks offers. Our long experience delivering successful projects means we know which technologies work well and best together. This experience has informed our choices of platforms, services and functions that Ensono Stacks offers, which means that using Ensono Stacks reduces risk. You can be confident that the test frameworks Ensono Stacks offers when building a REST API in Java, the CI/ CD pipelines for your C# event listener, or the compute options for your Node SSR web app will work well.

## How does it work

Select a workload using the What Can You Do with Ensono Stacks element on the home page to see detailed documentation on how to get started. For a more detailed section on Workloads, please see [Introduction to workloads](/docs/workloads/workloads.md).
