---
id: code_of_conduct
title: Code of conduct
sidebar_label: Code of conduct
hide_title: true
hide_table_of_contents: false
description: Code of conduct
keywords:
  - conduct
  - values
  - behaviour
  - community
  - scope
  - open-source
---

import HideNavigation  from "../src/components/HideNavigation/HideNavigation";

## Code of Conduct

[Ensono Stacks](https://www.ensonodigital.com/about) is a independent technical consultancy delivering intelligent solutions that drive growth, innovation, and operational efficiency.

## Values

We have four key values in which we stand by:

1. **Start with the problem**: Working together to make sure that technology choices are business outcome driven and not tech for tech’s sake. The magic is understanding what your users want, knowing what technology is out there and gluing these   technologies together in the most effective way.
2. **Technology agnostic**: We are independent and not aligned to any product or solution (including the ones we open source), allowing us to recommend what is right for our clients. With a plethora of cloud services in the marketplace, we will find the right mix of available solutions from the rich PaaS and SaaS market.
3. **People first**: As a people business, we place your customers and employees at the centre of any digital project or transformation. People are at the heart of everything we design and deliver.
4. **Pragmatic**: All technology has its strengths but also its limitations. We focus on delivering solutions that work and on creating technology ecosystems that make the most of the technologies within them. We are honest about the value that can be delivered now but also work to ensure our solutions have the agility and scalability built in to meet the challenges of tomorrow.

## Open Source Conduct

### Purpose

A primary goal of Ensono Stacks is to be inclusive to the largest number of contributors, with the most varied and diverse backgrounds possible. As such, we are committed to providing a friendly, safe and welcoming environment for all, regardless of gender, sexual orientation, ability, ethnicity, socioeconomic status, and religion (or lack thereof).

This Code of Conduct outlines our expectations for all those who participate in our community, as well as the consequences for unacceptable behaviour.

We invite all those who participate in Ensono Stacks to help us create safe and positive experiences for everyone.

### Open Source Citizenship

A supplemental goal of this Code of Conduct is to increase open source citizenship by encouraging participants to recognize and strengthen the relationships between our actions and their effects on our community.

Communities mirror the societies in which they exist and positive action is essential to counteract the many forms of inequality and abuses of power that exist in society.

If you see someone who is making an extra effort to ensure our community is welcoming, friendly, and encourages all participants to contribute to the fullest extent, we want to know.

### Expected Behaviour

The following behaviours are expected and requested of all community members:

* Participate in an authentic and active way. In doing so, you contribute to the health and longevity of this community.
* Exercise consideration and respect in your speech and actions.
* Attempt collaboration before conflict.
* Refrain from demeaning, discriminatory, or harassing behaviour and speech.
* Be mindful of your surroundings and of your fellow participants. Alert community leaders if you notice a dangerous situation, someone in distress, or violations of this Code of Conduct, even if they seem inconsequential.
* Remember that community event venues may be shared with members of the public; please be respectful to all patrons of these locations.

### Unacceptable Behaviour

The following behaviours are considered harassment and are unacceptable within our community:

* Violence, threats of violence or violent language directed against another person.
* Sexist, racist, homophobic, transphobic, ableist or otherwise discriminatory jokes and language.
* Posting or displaying sexually explicit or violent material.
* Posting or threatening to post other people’s personally identifying information ("doxing").
* Personal insults, particularly those related to gender, sexual orientation, race, religion, or disability.
* Inappropriate photography or recording.
* Inappropriate physical contact. You should have someone’s consent before touching them.
* Unwelcome sexual attention. This includes, sexualized comments or jokes; inappropriate touching, groping, and unwelcomed sexual advances.
* Deliberate intimidation, stalking or following (online or in person).
* Advocating for, or encouraging, any of the above behaviour.
* Sustained disruption of community events, including talks and presentations.

### Scope

We expect all community participants (contributors, paid or otherwise; sponsors; and other guests) to abide by this Code of Conduct in all community venues, online and in person, as well as in all one on one communications pertaining to community business.

This Code of Conduct and its related procedures also applies to unacceptable behaviour occurring outside the scope of community activities when such behaviour has the potential to adversely affect the safety and well-being of community members.

***

*Primary source: [Citizen Code of Conduct - Revision 2.2](http://citizencodeofconduct.org/) Portions of text derived from the Django Code of Conduct and the Geek Feminism Anti-Harassment Policy.*

<HideNavigation next />
