Contributing
------------------

Thank you for considering contributing to [Ensono Stacks](https://www.ensonodigital.com). It's people like you that continue to make Ensono Stacks the best it can be.

Following these guidelines helps you communicate and participate with the developers maintaining and developing these open source projects. We will cover:
* How to file issues
* How to raise a PR
* How to suggest a new feature


### Contributing to Ensono Stacks

We love to receive contributions. There are many ways in which you can experience the warm fuzzies of open source contribution, from improving the documentation, writing tutorials or blog posts, submitting issues and feature requests, or writing code which can be incorporated into Ensono Stacks.

However, we have a few baselines worth noting:
* Please don't expect your new feature to be implemented unless you or someone else sends a pull request. Submit with a test to get it merged quicker.
* If you have an issue, please tell us how to reproduce it. Bonus points for a failing test case.
* Not everything will be fixed.
* Did we mention we love tests?

Please, don't use the issue tracker if your problem is not strictly Ensono Stacks specific. Stack Overflow or other sources are worth considering.

_See the individual [Ensono projects](./README.md) for in depth information about environment setup, testing, and code styles._

# First...
Please read our [Code of Conduct](./CODE_OF_CONDUCT.md).
The basis of all is to remember to do good humaning. Everyone is on their own path of challenge and discovery, so please treat others the way you would want to be treated. If you can’t offer praise, offer help instead.

* Ensure cross-platform compatibility for every change that's accepted. Windows, Mac, Debian & Ubuntu Linux.
* Ensure the code meets the requirements in the PR Checklist.
* Create issues for changes and feature requests. Be transparent.
* Be welcoming encourage diverse new contributors from all backgrounds.
* Documentation isn't optional
* Tests aren't optional

# How to contribute
Unsure where to being? Start by looking through the following [issues](https://github.com/Ensono/amido.github.io/issues?q=is%3Aissue+is%3Aopen+sort%3Acomments-desc) labels:

* [good-first-issue](https://github.com/Ensono/amido.github.io/labels/good-first-issue) - should only require a few lines of code, and a test or two.
* [documentation](https://github.com/Ensono/amido.github.io/labels/kind%2Fdocumentation) - we always need to improve our documentation, it's one of the best ways to contribute.

Sorting the issues by number of comments generally gives a reasonable proxy for the impact the change will have. More comments, more vested interest.

### Never contributed to open source before?
No problem! You can learn how from this *free* series, [How to Contribute to an Open Source Project on GitHub](https://egghead.io/series/how-to-contribute-to-an-open-source-project-on-github).

Alternatively, ask us for help.

# Open Development
All work on Ensono Stacks is on GitHub. Both Ensono maintainers and external contributors send pull requests which go through the same review process. We are using [Azure Pipelines](https://azure.microsoft.com/en-gb/services/devops/pipelines/) as our CI/CD tool of choice. Every PR will invoke a series of steps to build, test, and deploy.

## Code changes happen through pull requests
We use Github for hosting and supporting our open source Stack projects. The Ensono internal maintainers team will be monitoring Github for pull requests (PRs) and issues.

We actively welcome your pull requests:

1. Fork the repo and create your branch from master
2. If you've added code that should be tested, add tests.
3. Update the documentation.
4. Ensure the test suite passes.
5. Issue the pull request using the repos PULL_REQUEST_TEMPLATE.md. It's important to link the [issue number](https://github.com/Ensono/amido.github.io/issues) to ensure that the Issue is closed.

## How to report a bug
### Security first
If you find a security vulnerability, do NOT open an [issue](https://github.com/Ensono/amido.github.io/issues/new/choose). Email [Ensono](mailto:stacks@ensono.com) instead.

If you aren't sure you've found an security issue, ask yourself the following:
1. Can I access something that is not mine?
2. Can I disable something for someone else?

If you answered "yes" to either question, please get in contact.

### Report bugs using Github issues
We use GitHub issues to track public bugs. Report a bug by opening a new issue. Please follow the [issue templates](https://github.com/Ensono/amido.github.io/tree/master/.github/ISSUE_TEMPLATE).

In general, please follow the guidelines:
* A quick summary and/or background
* Steps to reproduce
    * including sample code
    * failing test if possible
* What you expected would happen
* What actually happens
* Impact of the bug

## General conventions
We follow [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) for all commits and PR's, to ensure we capture the "why" behind every "what".

For versioning, we follow [Semantic Version 2.0.0](https://semver.org/).

Code styling and practices depend on the project. Check the project repo for more information.

# Community
If you are interested in talking with Ensono on how accelerate your cloud adoption using Ensono Stacks then please reach out at [Ensono](mailto:stacks@ensono.com).

*************************
_Special thanks to the open-source inspirations we've loved and used to form our own documentation:
[source: [contributing-template](https://github.com/nayafia/contributing-template/blob/master/CONTRIBUTING-template.md)]
[source: [inspiration](https://github.com/codetriage/codetriage/blob/master/CONTRIBUTING.md)]_
************************
