% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_xml.R
\name{OEIS_xml}
\alias{OEIS_xml}
\title{Retrieves content from OEIS web as an `XML` document}
\usage{
OEIS_xml(ID)
}
\arguments{
\item{ID}{A string with the OEIS sequence identifier \code{ID} number.
The A-number or sequence \code{ID} is the absolute catalog number of the
sequence. It consists of "A" followed by 6 digits.}
}
\value{
An \code{OEIS_xml} S3 class and \code{xml_document} from OEIS web
  with the sequence content.
}
\description{
The `XML` document contains all the information from the OEIS web related to
the sequence.
}
\examples{

 id <- "A000156"
 test_seq_xml <- OEIS_xml(id)
 class(test_seq_xml)

}
\seealso{
* \code{\link{OEIS_url}}

* \code{\link{OEIS_check}}
}
