% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_url.R
\name{OEIS_url}
\alias{OEIS_url}
\title{Get sequence url in the OEIS server}
\usage{
OEIS_url(ID, text)
}
\arguments{
\item{ID}{A string with the OEIS sequence identifier \code{ID} number.
The A-number or sequence \code{ID} is the absolute catalog number of the
sequence. It consists of "A" followed by 6 digits.}

\item{text}{A logical if \code{TRUE} the function returns the internal format
url, if \code{FALSE} it returns full sequence url.}
}
\value{
A string with the full sequence url, or the internal format url.
\code{\link{OEIS_check}}
}
\description{
Get sequence url in the OEIS server
}
\examples{
OEIS_url("A000055")
OEIS_url("A000055", text = TRUE)

}
\references{
\href{https://oeis.org/eishelp1.html}{Internal Format Used In}
}
\seealso{
* \code{\link{OEIS_web_url}}
}
