% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_terms.R
\name{OEIS_terms}
\alias{OEIS_terms}
\title{Get OEIS sequence terms from `XML` document.}
\usage{
OEIS_terms(x)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}
}
\value{
A character list with the OEIS sequence terms.
}
\description{
This is the data included in the sequence. These lines give the beginning of
the sequence. Ideally the entry gives enough terms to fill about three lines
on the screen. The terms must be integers. If the terms are fractions, then
the numerators and denominators appear as separate sequences, labeled with
the Keyword "frac", and with links connecting the two sequences. Only
sequences that are well-defined and of general interest are included
}
\note{
For more terms see \code{\link{OEIS_bfile}}.
}
\examples{
# Wieferich primes: primes p such that p^2 divides 2^(p-1) - 1.
id <- "A001220"
internal_format <- OEIS_internal_format(id)
OEIS_terms(internal_format)

}
\seealso{
* \code{\link{OEIS_internal_format}}

* \code{\link{OEIS_sequence}}

* \code{\link{OEIS_bfile}}

* \code{\link{OEIS_xml}}
}
