% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_offset.R
\name{OEIS_offset}
\alias{OEIS_offset}
\title{OEIS sequence offset from \code{xml2} data.}
\usage{
OEIS_offset(x)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}
}
\value{
A character vector with the OEIS sequence offsets.
}
\description{
This line usually gives the subscript of the first term in the sequence. If
the sequence gives the decimal expansion of a constant, the offset is the
number of digits before the decimal point. In the OEIS web internal format,
there is a second offset, which says which term (counting from the left, and
starting with 1), first exceeds 1 in absolute value. This is set to 1 if all
the terms are 0 or +-1
}
\note{
In the internal format for a sequence the offset line (the %O line)
  contains two numbers. The first is the offset as just defined. The second
  gives the position of first entry greater than or equal to 2 in magnitude
  in the sequence (or 1 if no such entry exists), starting counting at 1. The
  second offset is used to determine the position of the sequence in the
  lexicographic order in the database.
}
\examples{
\dontrun{
id <- "A000056"
internal_format <- OEIS_internal_format(id)
OEIS_offset(internal_format)
}
}
\references{
\href{https://oeis.org/eishelp2.html#RS}{Explanation of the Different Lines}

\href{https://oeis.org/FAQ.html#Z23}{What does the "offset" mean?}
}
\seealso{
* \code{\link{OEIS_internal_format}}

* \code{\link{OEIS_description}}

* \code{\link{OEIS_xml}}

* \code{\link{OEIS_sequence}}
}
