% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_keywords.R
\name{OEIS_keywords}
\alias{OEIS_keywords}
\title{OEIS sequence keywords from sequence \code{internal_format}}
\usage{
OEIS_keywords(x)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}
}
\value{
A character vector with the OEIS sequence keywords.
}
\description{
These lines give keywords describing the sequence.
The actual keywords, in use, can be found at:
\href{https://oeis.org/eishelp2.html}{Explanation of Terms Used}
}
\examples{
id <- "A049323"
seq <- OEIS_sequence(id)
xml <- OEIS_xml(id)
frmt <- OEIS_internal_format(id)
OEIS_keywords(id)
# Keywords from "OEIS_sequence" class
OEIS_keywords(seq)
# Keywords from "OEIS_xml"
OEIS_keywords(xml)
# Keywords from internal format: "OEIS_internal" class
OEIS_keywords(frmt)

}
\seealso{
* \code{\link{OEIS_author}}

* \code{\link{OEIS_sequence}}

* \code{\link{OEIS_internal_format}}

* \code{\link{OEIS_xml}}
}
