% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_internal_format.R
\name{OEIS_internal_format}
\alias{OEIS_internal_format}
\title{Get sequence internal format}
\usage{
OEIS_internal_format(ID)
}
\arguments{
\item{ID}{A string with the OEIS sequence identifier \code{ID} number.
The A-number or sequence \code{ID} is the absolute catalog number of the
sequence. It consists of "A" followed by 6 digits.}
}
\value{
An object of the classes \code{data.frame} and
  \code{OEIS_internal} with the full sequence text internal format.
\code{\link{OEIS_check}}
}
\description{
In OEIS \strong{internal format}, each sequence, is described by about 10
lines, each line beginning %x Aabcdef where x is a letter (I,
S, T, N, etc.) and abcdef is the 6-digit identification number (or catalog
number) of the sequence. Each sequence gets a unique A-number.
}
\examples{
id <- "A000055"
OEIS_internal_format(id)

}
\references{
\href{https://oeis.org/eishelp1.html}{Internal Format Used In}
}
\seealso{
* \code{\link{OEIS_url}}

* \code{\link{OEIS_xml}}

* \code{\link{OEIS_ID}}
}
