% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_formula.R
\name{OEIS_formula}
\alias{OEIS_formula}
\title{OEIS sequence formula lines from sequence \code{internal_format}}
\usage{
OEIS_formula(x)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}
}
\value{
A character string with the OEIS sequence formula lines or
  \code{NULL} if there are no formulae.
}
\description{
These lines give formulae, recurrences, generating functions, etc. for the
sequence.
\strong{a(n)} usually denotes the n-th term of the sequence, and \strong{n}
is a typical subscript.
}
\examples{
\dontrun{
id <- "A105805"
internal_format <- OEIS_internal_format(id)
formula <- OEIS_formula(internal_format)
cat(formula, sep = "\n")
}
}
\references{
\url{https://oeis.org/FAQ.html#Z08}
}
\seealso{
\code{\link{OEIS_description}}

\code{\link{OEIS_internal_format}}

\code{\link{OEIS_sequence}}

\code{\link{OEIS_example}}
}
