% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_formerly.R
\name{OEIS_formerly}
\alias{OEIS_formerly}
\title{Get OEIS sequence former \code{ID}}
\usage{
OEIS_formerly(x)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}
}
\value{
A string with the OEIS former \code{ID} or \code{NULL}, if there is
  no former sequence designation.
}
\description{
This is an alternate \code{ID} for some sequences that also have a 4-digit
M-number, such as \code{M1459}, which is the number they carried in "The
Encyclopedia of Integer Sequences" by N.J.A. Sloane and S. Plouffe, Academic
Press, San Diego, CA, 1995. 'Some older sequences also have a 4-digit
N-number, such as N0577, which is the number they carried in the "Handbook of
Integer Sequences", by N. J. A. Sloane, Academic Press, NY, 1973
}
\examples{
id <- "A000056"
internal_format <- OEIS_internal_format(id)
OEIS_formerly(internal_format)

}
\seealso{
* \code{\link{OEIS_description}}

* \code{\link{OEIS_internal_format}}

* \code{\link{OEIS_sequence}}

* \code{\link{OEIS_xml}}
}
