% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_extensions.R
\name{OEIS_extensions}
\alias{OEIS_extensions}
\title{OEIS sequence extensions from sequence \code{internal_format}}
\usage{
OEIS_extensions(x)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}
}
\value{
A character string with the OEIS sequence extensions lines or
  \code{NULL} if there are no extensions.
}
\description{
This field is to claim credit for additions to the entry that can't be
properly acknowledged in other fields. The most common use is to acknowledge
more terms for sequences that had only a few previously.
}
\note{
\href{http://oeis.org/wiki/Style_Sheet}{OEIS Wiki: Style sheet for Style sheet for contributors}
}
\examples{
# A008406: Triangle T(n,k) read by rows, giving number of graphs with n nodes
# (n >= 1) and k edges (0 <= k <= n(n-1)/2).
id <- "A008406"
internal_format <- OEIS_internal_format(id)
extensions <- OEIS_extensions(internal_format)
cat(extensions, sep = "\n")
}
\seealso{
* \code{\link{OEIS_description}}

* \code{\link{OEIS_internal_format}}

* \code{\link{OEIS_sequence}}

* \code{\link{OEIS_example}}
}
