% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_download_bfile.R
\name{OEIS_download_bfile}
\alias{OEIS_download_bfile}
\title{Download bfile from the OEIS}
\usage{
OEIS_download_bfile(ID, destpath, ...)
}
\arguments{
\item{ID}{A string with the OEIS sequence identifier \code{ID} number.
The A-number or sequence \code{ID} is the absolute catalog number of the
sequence. It consists of "A" followed by 6 digits.}

\item{destpath}{A character string with the name where the downloaded
\code{bfile} is saved}

\item{...}{Additional parameters (see \link[utils]{download.file})}
}
\value{
An (invisible) integer code, 0 for success and non-zero for failure.
}
\description{
This function can be used to download a bfile from \url{https://oeis.org/}.
}
\examples{
\dontrun{
OEIS_download_bfile("A102030", "tests", quiet = TRUE)
}
}
\seealso{
* \code{\link{OEIS_bfile_url}}

* \code{\link{OEIS_bfile}}
}
