% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_crossrefs.R
\name{OEIS_crossrefs}
\alias{OEIS_crossrefs}
\title{OEIS Cross references}
\usage{
OEIS_crossrefs(x)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}
}
\value{
An object of the class \code{OEIS_crossrefs} including referenced
  sequences, sequences in context and adjacent sequences.
}
\description{
Cross references IDs
}
\examples{
\dontrun{
id <- "A000112"
seq_html <- OEIS_xml(id)
OEIS_crossrefs(seq_html)
}
}
\seealso{
\code{\link{OEIS_seqs_in_context}}

\code{\link{OEIS_seqs_adjacent}}

\code{\link{OEIS_cf}}

\code{\link{OEIS_df}}

\code{\link{OEIS_xml}}
}
