% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_comments.R
\name{OEIS_comments}
\alias{OEIS_comments}
\title{OEIS sequence comments lines from sequence \code{internal_format}}
\usage{
OEIS_comments(x)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}
}
\value{
A character string with the OEIS sequence comments lines from the
   sequence or \code{NULL} if there are no comments.
}
\description{
The comments field in OEIS sequence entries is for information that does
not quite fit in other fields.
}
\examples{
id <- "A105805"
internal_format <- OEIS_internal_format(id)
example <- OEIS_comments(internal_format)
cat(example, sep = "\n")

}
\seealso{
* \code{\link{OEIS_description}}

* \code{\link{OEIS_author}}

* \code{\link{OEIS_internal_format}}

* \code{\link{OEIS_formula}}

* \code{\link{OEIS_sequence}}

* \code{\link{OEIS_xml}}
}
