% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_crossrefs.R
\name{OEIS_cf}
\alias{OEIS_cf}
\title{OEIS sequence linked cross references from sequence information
\code{data.frame}}
\usage{
OEIS_cf(x)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}
}
\value{
A character vector with OEIS sequence linked cross references
  \code{ID}s.
}
\description{
OEIS sequence linked cross references from sequence information
\code{data.frame}
}
\examples{
\dontrun{
id <- "A240106"
seq_html <- OEIS_xml(id)
seq_df <- OEIS_df(seq_html)
OEIS_cf(seq_df)
}
}
\seealso{
* \code{\link{OEIS_seqs_adjacent}}

* \code{\link{OEIS_crossrefs}}

* \code{\link{OEIS_xml}}

* \code{\link{OEIS_df}}
}
