% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_bibtex.R
\name{OEIS_bibtex}
\alias{OEIS_bibtex}
\title{Getting BibTeX citation from OEIS sequence}
\usage{
OEIS_bibtex(x)
}
\arguments{
\item{x}{An object of class \code{OEIS_sequence}}
}
\value{
An object of class \code{bibentry} with the citation, the function
populates a \code{Misc} entry type, for use when nothing else fits, with
the following fields:
\itemize{
\item \strong{key}: a character string giving the citation key for the OEIS sequence.
\item \strong{author}: The name(s) of the author(s) (in the case of more than one
author, separated by \code{and}).
\item \strong{title}:  The {O}n-{L}ine {E}ncyclopedia of {I}nteger {S}equences.
\item \strong{url}: Link to sequence in OEIS.
\item \strong{year}: The year of publication (or, if unpublished, the year of
creation).
\item \strong{month}: The month of publication (or, if unpublished, the month
of creation).
\item \strong{note}: Sequence description.
}
}
\description{
Getting BibTeX citation from OEIS sequence
}
\note{
Fields tags are separated by commas. The last tag finishes with a comma
, although is not necessarily. The tag's name is not case-sensitive but
caps are used.

For more help on \code{bibentry} class, see: \code{\link[utils]{bibentry}}
}
\examples{
x <- OEIS_sequence("A170401")
bref <- OEIS_bibtex(x)
# BibTeX and citation.
print(bref, style = "Bibtex")
print(bref, style = "citation")

}
\references{
\itemize{
\item \href{http://www.bibtex.org/Format/}{BibTeX Format Description}
\item \href{http://psychedelic-geometry.blogspot.com.es/2010/02/bibtex-automatic-oeis-citations.html}{BibTeX AUTOMATIC OEIS CITATIONS}
\item \href{https://github.com/Psychedelic-Geometry/OEIS-Mathematica/wiki}{Mathematica OEIS Package}
\item \href{https://en.wikipedia.org/wiki/BibTeX}{Wikipedia: BibTex}
\item \href{https://oeis.org/wiki/Welcome#reference}{Referencing a Particular Sequence}
}
}
\seealso{
\itemize{
\item \code{\link[utils]{person}}
}

\itemize{
\item \code{\link[utils]{toBibtex}}
}

\itemize{
\item \code{\link{OEIS_author}}
}
}
