% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_bfile_url.R
\name{OEIS_bfile_url}
\alias{OEIS_bfile_url}
\title{Get sequence data url in \code{bfile} format.}
\usage{
OEIS_bfile_url(ID, URL)
}
\arguments{
\item{ID}{A string with the OEIS sequence identifier \code{ID} number.
The A-number or sequence \code{ID} is the absolute catalog number of the
sequence. It consists of "A" followed by 6 digits.}

\item{URL}{A logical that selects if the output is the complete url, or just
the \code{bfile} file name.}
}
\value{
A string with the sequence \strong{bfile} url, or the \strong{bfile}
  file name
}
\description{
A \strong{bfile} is a text formatted file that provides many more terms of a
sequence than the typical fifty to eighty terms that can be shown in the main
sequence entry.
}
\examples{
id <- "A000056"
OEIS_bfile_url(id, URL = FALSE)
OEIS_bfile_url(id, URL = TRUE)
}
\seealso{
* \code{\link{OEIS_url}}

* \code{\link{OEIS_check}}
}
