% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_author.R
\name{OEIS_author}
\alias{OEIS_author}
\title{OEIS sequence authors from \code{internal format}, or from the sequence
\code{ID}.}
\usage{
OEIS_author(x, email = FALSE)
}
\arguments{
\item{x}{Can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
}}

\item{email}{A logical, by specifying: \code{email = TRUE}, the
author's email is returned, if present, with the author's name.
The default value of \code{email} is \code{FALSE}.}
}
\value{
A character vector with the OEIS sequence authors and emails.
}
\description{
This function gives the name of the person, or persons, who contributed the
sequence and their emails, if they are present and selected.
}
\examples{
id <- "A169890"
OEIS_author(id, email = TRUE)

}
\seealso{
* \code{\link{OEIS_description}}

* \code{\link{OEIS_internal_format}}

* \code{\link{OEIS_sequence}}

* \code{\link{OEIS_check}}
}
