% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEIS_ID.R
\name{OEIS_ID}
\alias{OEIS_ID}
\title{OEIS sequence authors from \code{internal format}, or from the sequence
\code{ID}.}
\usage{
OEIS_ID(x)
}
\arguments{
\item{x}{can be one of the following:
\itemize{
\item A character string with sequence \code{ID}.
\item A \code{OEIS_internal} S3 class object, with sequence internal format.
\item A S3 classes object \code{OEIS_xml} and \code{xml_document}, with
sequence content from OEIS web.
\item An object of \code{OEIS_sequence} class, that contains all sequence
related data.
\item An object of \code{OEIS_bfile} class.
}}
}
\value{
A character string with the OEIS sequence \code{ID}.
}
\description{
This function gives the name of the person, or persons, who contributed the
sequence and their emails, if they are present and selected.
}
\examples{
id <- "A169890"
OEIS_ID(id)

}
\seealso{
\itemize{
\item \code{\link{OEIS_description}}
}

\itemize{
\item \code{\link{OEIS_internal_format}}
}

\itemize{
\item \code{\link{OEIS_sequence}}
}

\itemize{
\item \code{\link{OEIS_check}}
}
}
