﻿using ESimConnect.Definitions;
using System.ComponentModel.DataAnnotations;

namespace ESimConnect.Definitions
{
  public static partial class SimVars
  {
    public static class Aircraft
    {
      public static class Miscelaneous
      {
        public const string AIRCRAFT_WIND_X = "AIRCRAFT WIND X";
        public const string AIRCRAFT_WIND_Y = "AIRCRAFT WIND Y";
        public const string AIRCRAFT_WIND_Z = "AIRCRAFT WIND Z";
        public const string AIRSPEED_BARBER_POLE = "AIRSPEED BARBER POLE";
        public const string AIRSPEED_INDICATED = "AIRSPEED INDICATED";
        public const string AIRSPEED_MACH = "AIRSPEED MACH";
        public const string AIRSPEED_SELECT_INDICATED_OR_TRUE = "AIRSPEED SELECT INDICATED OR TRUE";
        public const string AIRSPEED_TRUE = "AIRSPEED TRUE";
        public const string AIRSPEED_TRUE_RAW = "AIRSPEED TRUE RAW";
        public const string BARBER_POLE_MACH = "BARBER POLE MACH";
        public const string TOTAL_VELOCITY = "TOTAL VELOCITY";
        public const string WINDSHIELD_WIND_VELOCITY = "WINDSHIELD WIND VELOCITY";
        public const string STANDARD_ATM_TEMPERATURE = "STANDARD ATM TEMPERATURE";
        public const string TOTAL_AIR_TEMPERATURE = "TOTAL AIR TEMPERATURE";
        public const string EYEPOINT_POSITION = "EYEPOINT POSITION";
        public const string STRUC_AIRSPEED_HOLD_PID_CONSTS = "STRUC AIRSPEED HOLD PID CONSTS";
        public const string STRUC_HEADING_HOLD_PID_CONSTS = "STRUC HEADING HOLD PID CONSTS";
        public const string STRUCT_BODY_ROTATION_ACCELERATION = "STRUCT BODY ROTATION ACCELERATION";
        public const string STRUCT_BODY_ROTATION_VELOCITY = "STRUCT BODY ROTATION VELOCITY";
        public const string STRUCT_BODY_VELOCITY = "STRUCT BODY VELOCITY";
        public const string STRUCT_ENGINE_POSITION__index = "STRUCT ENGINE POSITION:";
        public const string STRUCT_EYEPOINT_DYNAMIC_ANGLE = "STRUCT EYEPOINT DYNAMIC ANGLE";
        public const string STRUCT_EYEPOINT_DYNAMIC_OFFSET = "STRUCT EYEPOINT DYNAMIC OFFSET";
        public const string STRUCT_LATLONALT = "STRUCT LATLONALT";
        public const string STRUCT_LATLONALTPBH = "STRUCT LATLONALTPBH";
        public const string ACCELERATION_BODY_X = "ACCELERATION BODY X";
        public const string ACCELERATION_BODY_Y = "ACCELERATION BODY Y";
        public const string ACCELERATION_BODY_Z = "ACCELERATION BODY Z";
        public const string ACCELERATION_WORLD_X = "ACCELERATION WORLD X";
        public const string ACCELERATION_WORLD_Y = "ACCELERATION WORLD Y";
        public const string ACCELERATION_WORLD_Z = "ACCELERATION WORLD Z";
        public const string SURFACE_RELATIVE_GROUND_SPEED = "SURFACE RELATIVE GROUND SPEED";
        public const string GROUND_VELOCITY = "GROUND VELOCITY";
        public const string PLANE_ALTITUDE = "PLANE ALTITUDE";
        public const string PLANE_ALT_ABOVE_GROUND = "PLANE ALT ABOVE GROUND";
        public const string PLANE_ALT_ABOVE_GROUND_MINUS_CG = "PLANE ALT ABOVE GROUND MINUS CG";
        public const string PLANE_BANK_DEGREES = "PLANE BANK DEGREES";
        public const string PLANE_HEADING_DEGREES_GYRO = "PLANE HEADING DEGREES GYRO";
        public const string PLANE_HEADING_DEGREES_MAGNETIC = "PLANE HEADING DEGREES MAGNETIC";
        public const string PLANE_HEADING_DEGREES_TRUE = "PLANE HEADING DEGREES TRUE";
        public const string PLANE_LATITUDE = "PLANE LATITUDE";
        public const string PLANE_LONGITUDE = "PLANE LONGITUDE";
        public const string PLANE_PITCH_DEGREES = "PLANE PITCH DEGREES";
        public const string PLANE_TOUCHDOWN_BANK_DEGREES = "PLANE TOUCHDOWN BANK DEGREES";
        public const string PLANE_TOUCHDOWN_HEADING_DEGREES_MAGNETIC = "PLANE TOUCHDOWN HEADING DEGREES MAGNETIC";
        public const string PLANE_TOUCHDOWN_HEADING_DEGREES_TRUE = "PLANE TOUCHDOWN HEADING DEGREES TRUE";
        public const string PLANE_TOUCHDOWN_LATITUDE = "PLANE TOUCHDOWN LATITUDE";
        public const string PLANE_TOUCHDOWN_LONGITUDE = "PLANE TOUCHDOWN LONGITUDE";
        public const string PLANE_TOUCHDOWN_NORMAL_VELOCITY = "PLANE TOUCHDOWN NORMAL VELOCITY";
        public const string PLANE_TOUCHDOWN_PITCH_DEGREES = "PLANE TOUCHDOWN PITCH DEGREES";
        public const string RELATIVE_WIND_VELOCITY_BODY_X = "RELATIVE WIND VELOCITY BODY X";
        public const string RELATIVE_WIND_VELOCITY_BODY_Y = "RELATIVE WIND VELOCITY BODY Y";
        public const string RELATIVE_WIND_VELOCITY_BODY_Z = "RELATIVE WIND VELOCITY BODY Z";
        public const string ROTATION_ACCELERATION_BODY_X = "ROTATION ACCELERATION BODY X";
        public const string ROTATION_ACCELERATION_BODY_Y = "ROTATION ACCELERATION BODY Y";
        public const string ROTATION_ACCELERATION_BODY_Z = "ROTATION ACCELERATION BODY Z";
        public const string ROTATION_VELOCITY_BODY_X = "ROTATION VELOCITY BODY X";
        public const string ROTATION_VELOCITY_BODY_Y = "ROTATION VELOCITY BODY Y";
        public const string ROTATION_VELOCITY_BODY_Z = "ROTATION VELOCITY BODY Z";
        public const string SLOPE_TO_ATC_RUNWAY = "SLOPE TO ATC RUNWAY";
        public const string VELOCITY_BODY_X = "VELOCITY BODY X";
        public const string VELOCITY_BODY_Y = "VELOCITY BODY Y";
        public const string VELOCITY_BODY_Z = "VELOCITY BODY Z";
        public const string VERTICAL_SPEED = "VERTICAL SPEED";
        public const string AMBIENT_IN_CLOUD = "AMBIENT IN CLOUD";
        public const string CONTRAILS_CONDITIONS_MET = "CONTRAILS CONDITIONS MET";
        public const string IS_SLEW_ACTIVE = "IS SLEW ACTIVE";
        public const string IS_SLEW_ALLOWED = "IS SLEW ALLOWED";
        public const string IS_USER_SIM = "IS USER SIM";
        public const string ON_ANY_RUNWAY = "ON ANY RUNWAY";
        public const string PLANE_IN_PARKING_STATE = "PLANE IN PARKING STATE";
        public const string SURFACE_CONDITION = "SURFACE CONDITION";
        public const string SURFACE_INFO_VALID = "SURFACE INFO VALID";
        public const string SURFACE_TYPE = "SURFACE TYPE";
        public const string STRUCTURAL_ICE_PCT = "STRUCTURAL ICE PCT";
        [StringLength(128)]
        public const string TITLE = "TITLE";
        public const string TOW_CONNECTION = "TOW CONNECTION";
        public const string WINDSHIELD_RAIN_EFFECT_AVAILABLE = "WINDSHIELD RAIN EFFECT AVAILABLE";
      }

      public static class Autopilot
      {
        public const string AUTOPILOT_AIRSPEED_HOLD = "AUTOPILOT AIRSPEED HOLD";
        public const string AUTOPILOT_AIRSPEED_HOLD_VAR = "AUTOPILOT AIRSPEED HOLD VAR";
        public const string AUTOPILOT_AIRSPEED_MAX_CALCULATED = "AUTOPILOT AIRSPEED MAX CALCULATED";
        public const string AUTOPILOT_AIRSPEED_MIN_CALCULATED = "AUTOPILOT AIRSPEED MIN CALCULATED";
        public const string AUTOPILOT_ALT_RADIO_MODE = "AUTOPILOT ALT RADIO MODE";
        public const string AUTOPILOT_ALTITUDE_ARM = "AUTOPILOT ALTITUDE ARM";
        public const string AUTOPILOT_ALTITUDE_LOCK = "AUTOPILOT ALTITUDE LOCK";
        [SimWritable] public const string AUTOPILOT_ALTITUDE_LOCK_VAR = "AUTOPILOT ALTITUDE LOCK VAR";
        public const string AUTOPILOT_ALTITUDE_MANUALLY_TUNABLE = "AUTOPILOT ALTITUDE MANUALLY TUNABLE";
        public const string AUTOPILOT_ALTITUDE_SLOT_INDEX = "AUTOPILOT ALTITUDE SLOT INDEX";
        public const string AUTOPILOT_APPROACH_ACTIVE = "AUTOPILOT APPROACH ACTIVE";
        public const string AUTOPILOT_APPROACH_ARM = "AUTOPILOT APPROACH ARM";
        public const string AUTOPILOT_APPROACH_CAPTURED = "AUTOPILOT APPROACH CAPTURED";
        public const string AUTOPILOT_APPROACH_HOLD = "AUTOPILOT APPROACH HOLD";
        public const string AUTOPILOT_APPROACH_IS_LOCALIZER = "AUTOPILOT APPROACH IS LOCALIZER";
        public const string AUTOPILOT_ATTITUDE_HOLD = "AUTOPILOT ATTITUDE HOLD";
        public const string AUTOPILOT_AVAILABLE = "AUTOPILOT AVAILABLE";
        public const string AUTOPILOT_AVIONICS_MANAGED = "AUTOPILOT AVIONICS MANAGED";
        public const string AUTOPILOT_BACKCOURSE_HOLD = "AUTOPILOT BACKCOURSE HOLD";
        public const string AUTOPILOT_BANK_HOLD = "AUTOPILOT BANK HOLD";
        [SimWritable] public const string AUTOPILOT_BANK_HOLD_REF = "AUTOPILOT BANK HOLD REF";
        public const string AUTOPILOT_DEFAULT_PITCH_MODE = "AUTOPILOT DEFAULT PITCH MODE";
        public const string AUTOPILOT_DEFAULT_ROLL_MODE = "AUTOPILOT DEFAULT ROLL MODE";
        public const string AUTOPILOT_DISENGAGED = "AUTOPILOT DISENGAGED";
        public const string AUTOPILOT_FLIGHT_DIRECTOR_ACTIVE = "AUTOPILOT FLIGHT DIRECTOR ACTIVE";
        public const string AUTOPILOT_FLIGHT_DIRECTOR_BANK = "AUTOPILOT FLIGHT DIRECTOR BANK";
        public const string AUTOPILOT_FLIGHT_DIRECTOR_BANK_EX1 = "AUTOPILOT FLIGHT DIRECTOR BANK EX1";
        public const string AUTOPILOT_FLIGHT_DIRECTOR_PITCH = "AUTOPILOT FLIGHT DIRECTOR PITCH";
        public const string AUTOPILOT_FLIGHT_DIRECTOR_PITCH_EX1 = "AUTOPILOT FLIGHT DIRECTOR PITCH EX1";
        [SimWritable] public const string AUTOPILOT_FLIGHT_LEVEL_CHANGE = "AUTOPILOT FLIGHT LEVEL CHANGE";
        public const string AUTOPILOT_GLIDESLOPE_ACTIVE = "AUTOPILOT GLIDESLOPE ACTIVE";
        public const string AUTOPILOT_GLIDESLOPE_ARM = "AUTOPILOT GLIDESLOPE ARM";
        public const string AUTOPILOT_GLIDESLOPE_HOLD = "AUTOPILOT GLIDESLOPE HOLD";
        public const string AUTOPILOT_HEADING_LOCK = "AUTOPILOT HEADING LOCK";
        [SimWritable] public const string AUTOPILOT_HEADING_LOCK_DIR = "AUTOPILOT HEADING LOCK DIR";
        [SimWritable] public const string AUTOPILOT_HEADING_MANUALLY_TUNABLE = "AUTOPILOT HEADING MANUALLY TUNABLE";
        public const string AUTOPILOT_HEADING_SLOT_INDEX = "AUTOPILOT HEADING SLOT INDEX";
        public const string AUTOPILOT_MACH_HOLD = "AUTOPILOT MACH HOLD";
        public const string AUTOPILOT_MACH_HOLD_VAR = "AUTOPILOT MACH HOLD VAR";
        public const string AUTOPILOT_MANAGED_SPEED_IN_MACH = "AUTOPILOT MANAGED SPEED IN MACH";
        public const string AUTOPILOT_MANAGED_THROTTLE_ACTIVE = "AUTOPILOT MANAGED THROTTLE ACTIVE";
        public const string AUTOPILOT_MASTER = "AUTOPILOT MASTER";
        public const string AUTOPILOT_MAX_BANK = "AUTOPILOT MAX BANK";
        public const string AUTOPILOT_MAX_BANK_ID = "AUTOPILOT MAX BANK ID";
        public const string AUTOPILOT_NAV1_LOCK = "AUTOPILOT NAV1 LOCK";
        public const string AUTOPILOT_NAV_SELECTED = "AUTOPILOT NAV SELECTED";
        public const string AUTOPILOT_PITCH_HOLD = "AUTOPILOT PITCH HOLD";
        public const string AUTOPILOT_PITCH_HOLD_REF = "AUTOPILOT PITCH HOLD REF";
        public const string AUTOPILOT_RPM_HOLD = "AUTOPILOT RPM HOLD";
        public const string AUTOPILOT_RPM_HOLD_VAR = "AUTOPILOT RPM HOLD VAR";
        public const string AUTOPILOT_RPM_SLOT_INDEX = "AUTOPILOT RPM SLOT INDEX";
        public const string AUTOPILOT_SPEED_SLOT_INDEX = "AUTOPILOT SPEED SLOT INDEX";
        public const string AUTOPILOT_TAKEOFF_POWER_ACTIVE = "AUTOPILOT TAKEOFF POWER ACTIVE";
        public const string AUTOPILOT_THROTTLE_ARM = "AUTOPILOT THROTTLE ARM";
        [SimWritable] public const string AUTOPILOT_THROTTLE_MAX_THRUST = "AUTOPILOT THROTTLE MAX THRUST";
        public const string AUTOPILOT_VERTICAL_HOLD = "AUTOPILOT VERTICAL HOLD";
        [SimWritable] public const string AUTOPILOT_VERTICAL_HOLD_VAR = "AUTOPILOT VERTICAL HOLD VAR";
        public const string AUTOPILOT_VS_SLOT_INDEX = "AUTOPILOT VS SLOT INDEX";
        public const string AUTOPILOT_WING_LEVELER = "AUTOPILOT WING LEVELER";
        public const string AUTOPILOT_YAW_DAMPER = "AUTOPILOT YAW DAMPER";
        public const string ASSISTANCE_LANDING_ENABLED = "ASSISTANCE LANDING ENABLED";
        public const string ASSISTANCE_TAKEOFF_ENABLED = "ASSISTANCE TAKEOFF ENABLED";
        public const string AI_ANTISTALL_STATE = "AI ANTISTALL STATE";
        public const string AI_AUTOTRIM_ACTIVE = "AI AUTOTRIM ACTIVE";
        public const string AI_AUTOTRIM_ACTIVE_AGAINST_PLAYER = "AI AUTOTRIM ACTIVE AGAINST PLAYER";
        public const string AI_CONTROLS = "AI CONTROLS";
        public const string AI_CURSOR_MODE_ACTIVE = "AI CURSOR MODE ACTIVE";
        public const string ATTITUDE_BARS_POSITION = "ATTITUDE BARS POSITION";
        public const string ATTITUDE_CAGE = "ATTITUDE CAGE";
        public const string ATTITUDE_INDICATOR_BANK_DEGREES = "ATTITUDE INDICATOR BANK DEGREES";
        public const string ATTITUDE_INDICATOR_PITCH_DEGREES = "ATTITUDE INDICATOR PITCH DEGREES";
        public const string DELEGATE_CONTROLS_TO_AI = "DELEGATE CONTROLS TO AI";
        public const string FLY_ASSISTANT_CANCEL_DESTINATION = "FLY ASSISTANT CANCEL DESTINATION";
        public const string FLY_ASSISTANT_CANCEL_DESTINATION_DISPLAY = "FLY ASSISTANT CANCEL DESTINATION DISPLAY";
        public const string FLY_ASSISTANT_COM_AI_LOCKED = "FLY ASSISTANT COM AI LOCKED";
        public const string FLY_ASSISTANT_HAVE_DESTINATION = "FLY ASSISTANT HAVE DESTINATION";
        public const string FLY_ASSISTANT_LANDING_SPEED = "FLY ASSISTANT LANDING SPEED";
        public const string FLY_ASSISTANT_LANDING_SPEED_DISPLAY_MODE = "FLY ASSISTANT LANDING SPEED DISPLAY MODE";
        public const string FLY_ASSISTANT_NEAREST_CATEGORY = "FLY ASSISTANT NEAREST CATEGORY";
        public const string FLY_ASSISTANT_NEAREST_COUNT = "FLY ASSISTANT NEAREST COUNT";
        public const string FLY_ASSISTANT_NEAREST_NAME = "FLY ASSISTANT NEAREST NAME";
        public const string FLY_ASSISTANT_NEAREST_SELECTED = "FLY ASSISTANT NEAREST SELECTED";
        public const string FLY_ASSISTANT_RIBBONS_ACTIVE = "FLY ASSISTANT RIBBONS ACTIVE";
        public const string FLY_ASSISTANT_SET_AS_DESTINATION = "FLY ASSISTANT SET AS DESTINATION";
        public const string FLY_ASSISTANT_STALL_SPEED = "FLY ASSISTANT STALL SPEED";
        public const string FLY_ASSISTANT_STALL_SPEED_DISPLAY_MODE = "FLY ASSISTANT STALL SPEED DISPLAY MODE";
        public const string FLY_ASSISTANT_TAKEOFF_SPEED = "FLY ASSISTANT TAKEOFF SPEED";
        public const string FLY_ASSISTANT_TAKEOFF_SPEED_DISPLAY_MODE = "FLY ASSISTANT TAKEOFF SPEED DISPLAY MODE";
        public const string FLY_ASSISTANT_TAKEOFF_SPEED_ESTIMATED = "FLY ASSISTANT TAKEOFF SPEED ESTIMATED";

      }

      public static class BrakesAndLandingGear
      {
        public const string ANTISKID_BRAKES_ACTIVE = "ANTISKID BRAKES ACTIVE";
        public const string AUTOBRAKES_ACTIVE = "AUTOBRAKES ACTIVE";
        public const string AUTO_BRAKE_SWITCH_CB = "AUTO BRAKE SWITCH CB";
        public const string BRAKE_DEPENDENT_HYDRAULIC_PRESSURE = "BRAKE DEPENDENT HYDRAULIC PRESSURE";
        public const string BRAKE_INDICATOR = "BRAKE INDICATOR";
        [SimWritable] public const string BRAKE_LEFT_POSITION = "BRAKE LEFT POSITION";
        [SimWritable] public const string BRAKE_LEFT_POSITION_EX1 = "BRAKE LEFT POSITION EX1";
        public const string BRAKE_PARKING_INDICATOR = "BRAKE PARKING INDICATOR";
        public const string BRAKE_PARKING_POSITION = "BRAKE PARKING POSITION";
        [SimWritable] public const string BRAKE_RIGHT_POSITION = "BRAKE RIGHT POSITION";
        [SimWritable] public const string BRAKE_RIGHT_POSITION_EX1 = "BRAKE RIGHT POSITION EX1";
        public const string REJECTED_TAKEOFF_BRAKES_ACTIVE = "REJECTED TAKEOFF BRAKES ACTIVE";
        public const string TOE_BRAKES_AVAILABLE = "TOE BRAKES AVAILABLE";
        public const string CONTACT_POINT_COMPRESSION__index = "CONTACT POINT COMPRESSION:";
        public const string CONTACT_POINT_IS_ON_GROUND__index = "CONTACT POINT IS ON GROUND:";
        public const string CONTACT_POINT_IS_SKIDDING__index = "CONTACT POINT IS SKIDDING:";
        public const string CONTACT_POINT_POSITION__index = "CONTACT POINT POSITION:";
        public const string CONTACT_POINT_SKIDDING_FACTOR__index = "CONTACT POINT SKIDDING FACTOR:";
        public const string CONTACT_POINT_WATER_DEPTH__index = "CONTACT POINT WATER DEPTH:";
        public const string AUX_WHEEL_ROTATION_ANGLE = "AUX WHEEL ROTATION ANGLE";
        public const string AUX_WHEEL_RPM = "AUX WHEEL RPM";
        public const string CENTER_WHEEL_ROTATION_ANGLE = "CENTER WHEEL ROTATION ANGLE";
        public const string CENTER_WHEEL_RPM = "CENTER WHEEL RPM";
        public const string GEAR_ANIMATION_POSITION__index = "GEAR ANIMATION POSITION:";
        [SimWritable] public const string GEAR_AUX_POSITION = "GEAR AUX POSITION";
        public const string GEAR_AUX_STEER_ANGLE = "GEAR AUX STEER ANGLE";
        public const string GEAR_AUX_STEER_ANGLE_PCT = "GEAR AUX STEER ANGLE PCT";
        [SimWritable] public const string GEAR_CENTER_POSITION = "GEAR CENTER POSITION";
        public const string GEAR_CENTER_STEER_ANGLE = "GEAR CENTER STEER ANGLE";
        public const string GEAR_CENTER_STEER_ANGLE_PCT = "GEAR CENTER STEER ANGLE PCT";
        public const string GEAR_DAMAGE_BY_SPEED = "GEAR DAMAGE BY SPEED";
        public const string GEAR_EMERGENCY_HANDLE_POSITION = "GEAR EMERGENCY HANDLE POSITION";
        [SimWritable] public const string GEAR_HANDLE_POSITION = "GEAR HANDLE POSITION";
        public const string GEAR_HYDRAULIC_PRESSURE = "GEAR HYDRAULIC PRESSURE";
        public const string GEAR_IS_ON_GROUND__index = "GEAR IS ON GROUND:";
        public const string GEAR_IS_SKIDDING__index = "GEAR IS SKIDDING:";
        [SimWritable] public const string GEAR_LEFT_POSITION = "GEAR LEFT POSITION";
        public const string GEAR_LEFT_STEER_ANGLE = "GEAR LEFT STEER ANGLE";
        public const string GEAR_LEFT_STEER_ANGLE_PCT = "GEAR LEFT STEER ANGLE PCT";
        [SimWritable] public const string GEAR_POSITION__index = "GEAR POSITION:";
        [SimWritable] public const string GEAR_RIGHT_POSITION = "GEAR RIGHT POSITION";
        public const string GEAR_RIGHT_STEER_ANGLE = "GEAR RIGHT STEER ANGLE";
        public const string GEAR_RIGHT_STEER_ANGLE_PCT = "GEAR RIGHT STEER ANGLE PCT";
        public const string GEAR_SPEED_EXCEEDED = "GEAR SPEED EXCEEDED";
        public const string GEAR_STEER_ANGLE__index = "GEAR STEER ANGLE:";
        public const string GEAR_STEER_ANGLE_PCT__index = "GEAR STEER ANGLE PCT:";
        public const string GEAR_TOTAL_PCT_EXTENDED = "GEAR TOTAL PCT EXTENDED";
        public const string GEAR_WARNING__index = "GEAR WARNING:";
        public const string GEAR_WATER_DEPTH = "GEAR WATER DEPTH";
        public const string IS_GEAR_FLOATS = "IS GEAR FLOATS";
        public const string IS_GEAR_RETRACTABLE = "IS GEAR RETRACTABLE";
        public const string IS_GEAR_SKIDS = "IS GEAR SKIDS";
        public const string IS_GEAR_SKIS = "IS GEAR SKIS";
        public const string IS_GEAR_WHEELS = "IS GEAR WHEELS";
        public const string LEFT_WHEEL_ROTATION_ANGLE = "LEFT WHEEL ROTATION ANGLE";
        public const string LEFT_WHEEL_RPM = "LEFT WHEEL RPM";
        public const string NOSEWHEEL_LOCK_ON = "NOSEWHEEL LOCK ON";
        [SimWritable] public const string NOSEWHEEL_MAX_STEERING_ANGLE = "NOSEWHEEL MAX STEERING ANGLE";
        public const string RETRACT_FLOAT_SWITCH = "RETRACT FLOAT SWITCH";
        public const string RETRACT_LEFT_FLOAT_EXTENDED = "RETRACT LEFT FLOAT EXTENDED";
        public const string RETRACT_RIGHT_FLOAT_EXTENDED = "RETRACT RIGHT FLOAT EXTENDED";
        public const string RIGHT_WHEEL_ROTATION_ANGLE = "RIGHT WHEEL ROTATION ANGLE";
        public const string RIGHT_WHEEL_RPM = "RIGHT WHEEL RPM";
        public const string STEER_INPUT_CONTROL = "STEER INPUT CONTROL";
        public const string TAILWHEEL_LOCK_ON = "TAILWHEEL LOCK ON";
        public const string WATER_LEFT_RUDDER_EXTENDED = "WATER LEFT RUDDER EXTENDED";
        public const string WATER_LEFT_RUDDER_STEER_ANGLE = "WATER LEFT RUDDER STEER ANGLE";
        public const string WATER_LEFT_RUDDER_STEER_ANGLE_PCT = "WATER LEFT RUDDER STEER ANGLE PCT";
        public const string WATER_RIGHT_RUDDER_EXTENDED = "WATER RIGHT RUDDER EXTENDED";
        public const string WATER_RIGHT_RUDDER_STEER_ANGLE = "WATER RIGHT RUDDER STEER ANGLE";
        public const string WATER_RIGHT_RUDDER_STEER_ANGLE_PCT = "WATER RIGHT RUDDER STEER ANGLE PCT";
        [SimWritable] public const string WATER_RUDDER_HANDLE_POSITION = "WATER RUDDER HANDLE POSITION";
        public const string WHEEL_ROTATION_ANGLE__index = "WHEEL ROTATION ANGLE:";
        public const string WHEEL_RPM__index = "WHEEL RPM:";
      }

      public static class Control
      {
        public const string AILERON_AVERAGE_DEFLECTION = "AILERON AVERAGE DEFLECTION";
        public const string AILERON_LEFT_DEFLECTION = "AILERON LEFT DEFLECTION";
        public const string AILERON_LEFT_DEFLECTION_PCT = "AILERON LEFT DEFLECTION PCT";
        [SimWritable] public const string AILERON_POSITION = "AILERON POSITION";
        public const string AILERON_RIGHT_DEFLECTION = "AILERON RIGHT DEFLECTION";
        public const string AILERON_RIGHT_DEFLECTION_PCT = "AILERON RIGHT DEFLECTION PCT";
        public const string AILERON_TRIM = "AILERON TRIM";
        public const string AILERON_TRIM_DISABLED = "AILERON TRIM DISABLED";
        [SimWritable] public const string AILERON_TRIM_PCT = "AILERON TRIM PCT";
        public const string ELEVATOR_DEFLECTION = "ELEVATOR DEFLECTION";
        public const string ELEVATOR_DEFLECTION_PCT = "ELEVATOR DEFLECTION PCT";
        [SimWritable] public const string ELEVATOR_POSITION = "ELEVATOR POSITION";
        public const string ELEVATOR_TRIM_DISABLED = "ELEVATOR TRIM DISABLED";
        public const string ELEVATOR_TRIM_DOWN_LIMIT = "ELEVATOR TRIM DOWN LIMIT";
        public const string ELEVATOR_TRIM_INDICATOR = "ELEVATOR TRIM INDICATOR";
        public const string ELEVATOR_TRIM_NEUTRAL = "ELEVATOR TRIM NEUTRAL";
        public const string ELEVATOR_TRIM_PCT = "ELEVATOR TRIM PCT";
        [SimWritable] public const string ELEVATOR_TRIM_POSITION = "ELEVATOR TRIM POSITION";
        public const string ELEVATOR_TRIM_UP_LIMIT = "ELEVATOR TRIM UP LIMIT";
        public const string ELEVON_DEFLECTION = "ELEVON DEFLECTION";
        public const string FLAP_DAMAGE_BY_SPEED = "FLAP DAMAGE BY SPEED";
        [SimWritable] public const string FLAP_POSITION_SET = "FLAP POSITION SET";
        public const string FLAP_SPEED_EXCEEDED = "FLAP SPEED EXCEEDED";
        public const string FLAPS_AVAILABLE = "FLAPS AVAILABLE";
        public const string FLAPS_EFFECTIVE_HANDLE_INDEX__index = "FLAPS EFFECTIVE HANDLE INDEX:";
        [SimWritable] public const string FLAPS_HANDLE_INDEX__index = "FLAPS HANDLE INDEX:";
        public const string FLAPS_HANDLE_PERCENT = "FLAPS HANDLE PERCENT";
        public const string FLAPS_NUM_HANDLE_POSITIONS = "FLAPS NUM HANDLE POSITIONS";
        public const string LEADING_EDGE_FLAPS_LEFT_ANGLE = "LEADING EDGE FLAPS LEFT ANGLE";
        public const string LEADING_EDGE_FLAPS_LEFT_INDEX = "LEADING EDGE FLAPS LEFT INDEX";
        [SimWritable] public const string LEADING_EDGE_FLAPS_LEFT_PERCENT = "LEADING EDGE FLAPS LEFT PERCENT";
        public const string LEADING_EDGE_FLAPS_RIGHT_ANGLE = "LEADING EDGE FLAPS RIGHT ANGLE";
        public const string LEADING_EDGE_FLAPS_RIGHT_INDEX = "LEADING EDGE FLAPS RIGHT INDEX";
        [SimWritable] public const string LEADING_EDGE_FLAPS_RIGHT_PERCENT = "LEADING EDGE FLAPS RIGHT PERCENT";
        public const string TRAILING_EDGE_FLAPS_LEFT_ANGLE = "TRAILING EDGE FLAPS LEFT ANGLE";
        public const string TRAILING_EDGE_FLAPS_LEFT_INDEX = "TRAILING EDGE FLAPS LEFT INDEX";
        [SimWritable] public const string TRAILING_EDGE_FLAPS_LEFT_PERCENT = "TRAILING EDGE FLAPS LEFT PERCENT";
        public const string TRAILING_EDGE_FLAPS_RIGHT_ANGLE = "TRAILING EDGE FLAPS RIGHT ANGLE";
        public const string TRAILING_EDGE_FLAPS_RIGHT_INDEX = "TRAILING EDGE FLAPS RIGHT INDEX";
        [SimWritable] public const string TRAILING_EDGE_FLAPS_RIGHT_PERCENT = "TRAILING EDGE FLAPS RIGHT PERCENT";
        public const string FLY_BY_WIRE_ALPHA_PROTECTION = "FLY BY WIRE ALPHA PROTECTION";
        public const string FLY_BY_WIRE_ELAC_FAILED = "FLY BY WIRE ELAC FAILED";
        public const string FLY_BY_WIRE_ELAC_SWITCH = "FLY BY WIRE ELAC SWITCH";
        public const string FLY_BY_WIRE_FAC_FAILED = "FLY BY WIRE FAC FAILED";
        public const string FLY_BY_WIRE_FAC_SWITCH = "FLY BY WIRE FAC SWITCH";
        public const string FLY_BY_WIRE_SEC_FAILED = "FLY BY WIRE SEC FAILED";
        public const string FLY_BY_WIRE_SEC_SWITCH = "FLY BY WIRE SEC SWITCH";
        public const string FOLDING_WING_HANDLE_POSITION = "FOLDING WING HANDLE POSITION";
        [SimWritable] public const string FOLDING_WING_LEFT_PERCENT = "FOLDING WING LEFT PERCENT";
        [SimWritable] public const string FOLDING_WING_RIGHT_PERCENT = "FOLDING WING RIGHT PERCENT";
        public const string RUDDER_DEFLECTION = "RUDDER DEFLECTION";
        public const string RUDDER_DEFLECTION_PCT = "RUDDER DEFLECTION PCT";
        public const string RUDDER_PEDAL_INDICATOR = "RUDDER PEDAL INDICATOR";
        [SimWritable] public const string RUDDER_PEDAL_POSITION = "RUDDER PEDAL POSITION";
        [SimWritable] public const string RUDDER_POSITION = "RUDDER POSITION";
        public const string RUDDER_TRIM = "RUDDER TRIM";
        public const string RUDDER_TRIM_DISABLED = "RUDDER TRIM DISABLED";
        [SimWritable] public const string RUDDER_TRIM_PCT = "RUDDER TRIM PCT";
        public const string SPOILERS_ARMED = "SPOILERS ARMED";
        public const string SPOILER_AVAILABLE = "SPOILER AVAILABLE";
        [SimWritable] public const string SPOILERS_HANDLE_POSITION = "SPOILERS HANDLE POSITION";
        public const string SPOILERS_LEFT_POSITION = "SPOILERS LEFT POSITION";
        public const string SPOILERS_RIGHT_POSITION = "SPOILERS RIGHT POSITION";
        public const string BLAST_SHIELD_POSITION__index = "BLAST SHIELD POSITION:";
        public const string CABLE_CAUGHT_BY_TAILHOOK__index = "CABLE CAUGHT BY TAILHOOK:";
        public const string CATAPULT_STROKE_POSITION__index = "CATAPULT STROKE POSITION:";
        public const string HOLDBACK_BAR_INSTALLED = "HOLDBACK BAR INSTALLED";
        public const string LAUNCHBAR_HELD_EXTENDED = "LAUNCHBAR HELD EXTENDED";
        public const string LAUNCHBAR_POSITION = "LAUNCHBAR POSITION";
        public const string LAUNCHBAR_SWITCH = "LAUNCHBAR SWITCH";
        public const string NUMBER_OF_CATAPULTS = "NUMBER OF CATAPULTS";
      }

      public static class Electrics
      {
        [SimWritable] public const string BUS_LOOKUP_INDEX = "BUS LOOKUP INDEX";
        [SimWritable] public const string BUS_BREAKER_PULLED = "BUS BREAKER PULLED";
        public const string BUS_CONNECTION_ON = "BUS CONNECTION ON";
        public const string ELECTRICAL_GENALT_LOAD = "ELECTRICAL GENALT LOAD";
        [SimWritable] public const string ELECTRICAL_GENALT_BUS_AMPS = "ELECTRICAL GENALT BUS AMPS";
        [SimWritable] public const string ELECTRICAL_GENALT_BUS_VOLTAGE = "ELECTRICAL GENALT BUS VOLTAGE";
        [SimWritable] public const string ELECTRICAL_MAIN_BUS_VOLTAGE = "ELECTRICAL MAIN BUS VOLTAGE";
        [SimWritable] public const string ELECTRICAL_AVIONICS_BUS_AMPS = "ELECTRICAL AVIONICS BUS AMPS";
        [SimWritable] public const string ELECTRICAL_AVIONICS_BUS_VOLTAGE = "ELECTRICAL AVIONICS BUS VOLTAGE";
        [SimWritable] public const string ELECTRICAL_MAIN_BUS_AMPS = "ELECTRICAL MAIN BUS AMPS";
        [SimDeprecated] public const string ELECTRICAL_OLD_CHARGING_AMPS = "ELECTRICAL OLD CHARGING AMPS";
        [SimWritable] public const string ELECTRICAL_TOTAL_LOAD_AMPS = "ELECTRICAL TOTAL LOAD AMPS";
        public const string NEW_ELECTRICAL_SYSTEM = "NEW ELECTRICAL SYSTEM";
        [SimWritable] public const string ALTERNATOR_BREAKER_PULLED = "ALTERNATOR BREAKER PULLED";
        public const string ALTERNATOR_CONNECTION_ON = "ALTERNATOR CONNECTION ON";
        public const string GENERAL_ENG_MASTER_ALTERNATOR__index = "GENERAL ENG MASTER ALTERNATOR:";
        public const string APU_BLEED_PRESSURE_RECEIVED_BY_ENGINE = "APU BLEED PRESSURE RECEIVED BY ENGINE";
        public const string APU_GENERATOR_ACTIVE__index = "APU GENERATOR ACTIVE:";
        public const string APU_GENERATOR_SWITCH__index = "APU GENERATOR SWITCH:";
        public const string APU_ON_FIRE_DETECTED = "APU ON FIRE DETECTED";
        public const string APU_PCT_RPM = "APU PCT RPM";
        public const string APU_PCT_STARTER = "APU PCT STARTER";
        public const string APU_SWITCH = "APU SWITCH";
        public const string APU_VOLTS__index = "APU VOLTS:";
        public const string BLEED_AIR_APU = "BLEED AIR APU";
        public const string BATTERY_BREAKER_PULLED = "BATTERY BREAKER PULLED";
        public const string BATTERY_CONNECTION_ON = "BATTERY CONNECTION ON";
        public const string ELECTRICAL_BATTERY_BUS_AMPS = "ELECTRICAL BATTERY BUS AMPS";
        public const string ELECTRICAL_BATTERY_BUS_VOLTAGE = "ELECTRICAL BATTERY BUS VOLTAGE";
        public const string ELECTRICAL_BATTERY_ESTIMATED_CAPACITY_PCT = "ELECTRICAL BATTERY ESTIMATED CAPACITY PCT";
        public const string ELECTRICAL_BATTERY_LOAD = "ELECTRICAL BATTERY LOAD";
        public const string ELECTRICAL_BATTERY_VOLTAGE = "ELECTRICAL BATTERY VOLTAGE";
        public const string ELECTRICAL_HOT_BATTERY_BUS_AMPS = "ELECTRICAL HOT BATTERY BUS AMPS";
        public const string ELECTRICAL_HOT_BATTERY_BUS_VOLTAGE = "ELECTRICAL HOT BATTERY BUS VOLTAGE";
        public const string ELECTRICAL_MASTER_BATTERY = "ELECTRICAL MASTER BATTERY";
        public const string BREAKER_ADF = "BREAKER ADF";
        public const string BREAKER_ALTFLD = "BREAKER ALTFLD";
        public const string BREAKER_AUTOPILOT = "BREAKER AUTOPILOT";
        public const string BREAKER_AVNBUS1 = "BREAKER AVNBUS1";
        public const string BREAKER_AVNBUS2 = "BREAKER AVNBUS2";
        public const string BREAKER_AVNFAN = "BREAKER AVNFAN";
        public const string BREAKER_FLAP = "BREAKER FLAP";
        public const string BREAKER_GPS = "BREAKER GPS";
        public const string BREAKER_INST = "BREAKER INST";
        public const string BREAKER_INSTLTS = "BREAKER INSTLTS";
        public const string BREAKER_LTS_PWR = "BREAKER LTS PWR";
        public const string BREAKER_NAVCOM1 = "BREAKER NAVCOM1";
        public const string BREAKER_NAVCOM2 = "BREAKER NAVCOM2";
        public const string BREAKER_NAVCOM3 = "BREAKER NAVCOM3";
        public const string BREAKER_TURNCOORD = "BREAKER TURNCOORD";
        public const string BREAKER_WARN = "BREAKER WARN";
        public const string BREAKER_XPNDR = "BREAKER XPNDR";
        public const string CIRCUIT_AUTOPILOT_ON = "CIRCUIT AUTOPILOT ON";
        public const string CIRCUIT_AUTO_BRAKES_ON = "CIRCUIT AUTO BRAKES ON";
        public const string CIRCUIT_AUTO_FEATHER_ON = "CIRCUIT AUTO FEATHER ON";
        public const string CIRCUIT_AVIONICS_ON = "CIRCUIT AVIONICS ON";
        public const string CIRCUIT_BREAKER_PULLED = "CIRCUIT BREAKER PULLED";
        public const string CIRCUIT_CONNECTION_ON = "CIRCUIT CONNECTION ON";
        public const string CIRCUIT_FLAP_MOTOR_ON = "CIRCUIT FLAP MOTOR ON";
        public const string CIRCUIT_GEAR_MOTOR_ON = "CIRCUIT GEAR MOTOR ON";
        public const string CIRCUIT_GEAR_WARNING_ON = "CIRCUIT GEAR WARNING ON";
        public const string CIRCUIT_GENERAL_PANEL_ON = "CIRCUIT GENERAL PANEL ON";
        public const string CIRCUIT_HYDRAULIC_PUMP_ON = "CIRCUIT HYDRAULIC PUMP ON";
        public const string CIRCUIT_MARKER_BEACON_ON = "CIRCUIT MARKER BEACON ON";
        public const string CIRCUIT_NAVCOM1_ON = "CIRCUIT NAVCOM1 ON";
        public const string CIRCUIT_NAVCOM2_ON = "CIRCUIT NAVCOM2 ON";
        public const string CIRCUIT_NAVCOM3_ON = "CIRCUIT NAVCOM3 ON";
        public const string CIRCUIT_ON = "CIRCUIT ON";
        public const string CIRCUIT_PITOT_HEAT_ON = "CIRCUIT PITOT HEAT ON";
        public const string CIRCUIT_POWER_SETTING = "CIRCUIT POWER SETTING";
        public const string CIRCUIT_PROP_SYNC_ON = "CIRCUIT PROP SYNC ON";
        public const string CIRCUIT_STANDBY_VACUUM_ON = "CIRCUIT STANDBY VACUUM ON";
        public const string CIRCUIT_SWITCH_ON = "CIRCUIT SWITCH ON";
        public const string EXTERNAL_POWER_AVAILABLE = "EXTERNAL POWER AVAILABLE";
        public const string EXTERNAL_POWER_BREAKER_PULLED = "EXTERNAL POWER BREAKER PULLED";
        public const string EXTERNAL_POWER_CONNECTION_ON = "EXTERNAL POWER CONNECTION ON";
        public const string EXTERNAL_POWER_ON = "EXTERNAL POWER ON";
      }

      public static class Engine
      {
        public const string BLEED_AIR_ENGINE__index = "BLEED AIR ENGINE:";
        public const string BLEED_AIR_SOURCE_CONTROL__index = "BLEED AIR SOURCE CONTROL:";
        public const string COWL_FLAPS = "COWL FLAPS";
        public const string ENGINE_CONTROL_SELECT = "ENGINE CONTROL SELECT";
        public const string ENGINE_MIXURE_AVAILABLE = "ENGINE MIXURE AVAILABLE";
        public const string ENGINE_PRIMER = "ENGINE PRIMER";
        public const string ENGINE_TYPE = "ENGINE TYPE";
        public const string ENG_ANTI_ICE__index = "ENG ANTI ICE:";
        public const string ENG_COMBUSTION__index = "ENG COMBUSTION:";
        public const string ENG_CYLINDER_HEAD_TEMPERATURE__index = "ENG CYLINDER HEAD TEMPERATURE:";
        public const string ENG_EXHAUST_GAS_TEMPERATURE__index = "ENG EXHAUST GAS TEMPERATURE:";
        public const string ENG_EXHAUST_GAS_TEMPERATURE_GES__index = "ENG EXHAUST GAS TEMPERATURE GES:";
        public const string ENG_FAILED__index = "ENG FAILED:";
        public const string ENG_FUEL_FLOW_BUG_POSITION__index = "ENG FUEL FLOW BUG POSITION:";
        public const string ENG_FUEL_FLOW_GPH__index = "ENG FUEL FLOW GPH:";
        public const string ENG_FUEL_FLOW_PPH__index = "ENG FUEL FLOW PPH:";
        public const string ENG_FUEL_FLOW_PPH_SSL__index = "ENG FUEL FLOW PPH SSL:";
        public const string ENG_HYDRAULIC_PRESSURE__index = "ENG HYDRAULIC PRESSURE:";
        public const string ENG_HYDRAULIC_QUANTITY__index = "ENG HYDRAULIC QUANTITY:";
        public const string ENG_MANIFOLD_PRESSURE__index = "ENG MANIFOLD PRESSURE:";
        public const string ENG_MAX_RPM = "ENG MAX RPM";
        public const string ENG_N1_RPM__index = "ENG N1 RPM:";
        public const string ENG_N2_RPM__index = "ENG N2 RPM:";
        public const string ENG_OIL_PRESSURE__index = "ENG OIL PRESSURE:";
        public const string ENG_OIL_QUANTITY__index = "ENG OIL QUANTITY:";
        public const string ENG_OIL_TEMPERATURE__index = "ENG OIL TEMPERATURE:";
        public const string ENG_ON_FIRE__index = "ENG ON FIRE:";
        public const string ENG_PRESSURE_RATIO__index = "ENG PRESSURE RATIO:";
        public const string ENG_PRESSURE_RATIO_GES__index = "ENG PRESSURE RATIO GES:";
        public const string ENG_RPM_ANIMATION_PERCENT__index = "ENG RPM ANIMATION PERCENT:";
        public const string ENG_RPM_SCALER__index = "ENG RPM SCALER:";
        public const string ENG_TORQUE__index = "ENG TORQUE:";
        public const string ENG_VIBRATION__index = "ENG VIBRATION:";
        public const string ESTIMATED_FUEL_FLOW__index = "ESTIMATED FUEL FLOW:";
        public const string FULL_THROTTLE_THRUST_TO_WEIGHT_RATIO = "FULL THROTTLE THRUST TO WEIGHT RATIO";
        public const string GENERAL_ENG_ANTI_ICE_POSITION__index = "GENERAL ENG ANTI ICE POSITION:";
        public const string GENERAL_ENG_COMBUSTION__index = "GENERAL ENG COMBUSTION:";
        public const string GENERAL_ENG_COMBUSTION_EX1__index = "GENERAL ENG COMBUSTION EX1:";
        public const string GENERAL_ENG_COMBUSTION_SOUND_PERCENT__index = "GENERAL ENG COMBUSTION SOUND PERCENT:";
        public const string GENERAL_ENG_DAMAGE_PERCENT__index = "GENERAL ENG DAMAGE PERCENT:";
        public const string GENERAL_ENG_ELAPSED_TIME__index = "GENERAL ENG ELAPSED TIME:";
        public const string GENERAL_ENG_EXHAUST_GAS_TEMPERATURE__index = "GENERAL ENG EXHAUST GAS TEMPERATURE:";
        public const string GENERAL_ENG_FAILED__index = "GENERAL ENG FAILED:";
        public const string GENERAL_ENG_FIRE_DETECTED__index = "GENERAL ENG FIRE DETECTED:";
        public const string GENERAL_ENG_FUEL_PRESSURE__index = "GENERAL ENG FUEL PRESSURE:";
        public const string GENERAL_ENG_FUEL_PUMP_ON__index = "GENERAL ENG FUEL PUMP ON:";
        public const string GENERAL_ENG_FUEL_PUMP_SWITCH__index = "GENERAL ENG FUEL PUMP SWITCH:";
        public const string GENERAL_ENG_FUEL_PUMP_SWITCH_EX1__index = "GENERAL ENG FUEL PUMP SWITCH EX1:";
        public const string GENERAL_ENG_FUEL_USED_SINCE_START__index = "GENERAL ENG FUEL USED SINCE START:";
        public const string GENERAL_ENG_FUEL_VALVE__index = "GENERAL ENG FUEL VALVE:";
        public const string GENERAL_ENG_GENERATOR_ACTIVE__index = "GENERAL ENG GENERATOR ACTIVE:";
        public const string GENERAL_ENG_GENERATOR_SWITCH__index = "GENERAL ENG GENERATOR SWITCH:";
        public const string GENERAL_ENG_HOBBS_ELAPSED_TIME__index = "GENERAL ENG HOBBS ELAPSED TIME:";
        public const string GENERAL_ENG_MASTER_ALTERNATOR = "GENERAL ENG MASTER ALTERNATOR";
        public const string GENERAL_ENG_MAX_REACHED_RPM__index = "GENERAL ENG MAX REACHED RPM:";
        public const string GENERAL_ENG_MIXTURE_LEVER_POSITION__index = "GENERAL ENG MIXTURE LEVER POSITION:";
        public const string GENERAL_ENG_OIL_LEAKED_PERCENT__index = "GENERAL ENG OIL LEAKED PERCENT:";
        public const string GENERAL_ENG_OIL_PRESSURE__index = "GENERAL ENG OIL PRESSURE:";
        public const string GENERAL_ENG_OIL_TEMPERATURE__index = "GENERAL ENG OIL TEMPERATURE:";
        public const string GENERAL_ENG_PCT_MAX_RPM__index = "GENERAL ENG PCT MAX RPM:";
        public const string GENERAL_ENG_PROPELLER_LEVER_POSITION__index = "GENERAL ENG PROPELLER LEVER POSITION:";
        public const string GENERAL_ENG_REVERSE_THRUST_ENGAGED = "GENERAL ENG REVERSE THRUST ENGAGED";
        public const string GENERAL_ENG_RPM__index = "GENERAL ENG RPM:";
        public const string GENERAL_ENG_STARTER__index = "GENERAL ENG STARTER:";
        public const string GENERAL_ENG_STARTER_ACTIVE__index = "GENERAL ENG STARTER ACTIVE:";
        public const string GENERAL_ENG_THROTTLE_LEVER_POSITION__index = "GENERAL ENG THROTTLE LEVER POSITION:";
        public const string GENERAL_ENG_THROTTLE_MANAGED_MODE__index = "GENERAL ENG THROTTLE MANAGED MODE:";
        public const string MASTER_IGNITION_SWITCH = "MASTER IGNITION SWITCH";
        public const string MAX_EGT = "MAX EGT";
        public const string MAX_OIL_TEMPERATURE = "MAX OIL TEMPERATURE";
        public const string MAX_RATED_ENGINE_RPM = "MAX RATED ENGINE RPM";
        public const string NUMBER_OF_ENGINES = "NUMBER OF ENGINES";
        public const string OIL_AMOUNT = "OIL AMOUNT";
        public const string PANEL_AUTO_FEATHER_SWITCH__index = "PANEL AUTO FEATHER SWITCH:";
        public const string PROP_AUTO_CRUISE_ACTIVE = "PROP AUTO CRUISE ACTIVE";
        public const string PROP_AUTO_FEATHER_ARMED__index = "PROP AUTO FEATHER ARMED:";
        public const string PROP_BETA__index = "PROP BETA:";
        public const string PROP_BETA_FORCED_ACTIVE = "PROP BETA FORCED ACTIVE";
        public const string PROP_BETA_FORCED_POSITION = "PROP BETA FORCED POSITION";
        public const string PROP_BETA_MAX = "PROP BETA MAX";
        public const string PROP_BETA_MIN = "PROP BETA MIN";
        public const string PROP_BETA_MIN_REVERSE = "PROP BETA MIN REVERSE";
        public const string PROP_DEICE_SWITCH__index = "PROP DEICE SWITCH:";
        public const string PROP_FEATHERED__index = "PROP FEATHERED:";
        public const string PROP_FEATHERING_INHIBIT__index = "PROP FEATHERING INHIBIT:";
        public const string PROP_FEATHER_SWITCH__index = "PROP FEATHER SWITCH:";
        public const string PROP_MAX_RPM_PERCENT__index = "PROP MAX RPM PERCENT:";
        public const string PROP_ROTATION_ANGLE = "PROP ROTATION ANGLE";
        public const string PROP_RPM__index = "PROP RPM:";
        public const string PROP_SYNC_ACTIVE__index = "PROP SYNC ACTIVE:";
        public const string PROP_SYNC_DELTA_LEVER__index = "PROP SYNC DELTA LEVER:";
        public const string PROP_THRUST__index = "PROP THRUST:";
        public const string PROPELLER_ADVANCED_SELECTION = "PROPELLER ADVANCED SELECTION";
        public const string RECIP_CARBURETOR_TEMPERATURE__index = "RECIP CARBURETOR TEMPERATURE:";
        public const string RECIP_ENG_ALTERNATE_AIR_POSITION__index = "RECIP ENG ALTERNATE AIR POSITION:";
        public const string RECIP_ENG_ANTIDETONATION_TANK_MAX_QUANTITY__index = "RECIP ENG ANTIDETONATION TANK MAX QUANTITY:";
        public const string RECIP_ENG_ANTIDETONATION_TANK_QUANTITY__index = "RECIP ENG ANTIDETONATION TANK QUANTITY:";
        public const string RECIP_ENG_ANTIDETONATION_TANK_VALVE__index = "RECIP ENG ANTIDETONATION TANK VALVE:";
        public const string RECIP_ENG_ANTIDETONATION_FLOW_RATE__index = "RECIP ENG ANTIDETONATION FLOW RATE:";
        public const string RECIP_ENG_BRAKE_POWER__index = "RECIP ENG BRAKE POWER:";
        public const string RECIP_ENG_COOLANT_RESERVOIR_PERCENT__index = "RECIP ENG COOLANT RESERVOIR PERCENT:";
        public const string RECIP_ENG_COWL_FLAP_POSITION__index = "RECIP ENG COWL FLAP POSITION:";
        public const string RECIP_ENG_CYLINDER_HEAD_TEMPERATURE__index = "RECIP ENG CYLINDER HEAD TEMPERATURE:";
        public const string RECIP_ENG_CYLINDER_HEALTH__index = "RECIP ENG CYLINDER HEALTH:";
        public const string RECIP_ENG_DETONATING__index = "RECIP ENG DETONATING:";
        public const string RECIP_ENG_EMERGENCY_BOOST_ACTIVE__index = "RECIP ENG EMERGENCY BOOST ACTIVE:";
        public const string RECIP_ENG_EMERGENCY_BOOST_ELAPSED_TIME__index = "RECIP ENG EMERGENCY BOOST ELAPSED TIME:";
        public const string RECIP_ENG_ENGINE_MASTER_SWITCH__index = "RECIP ENG ENGINE MASTER SWITCH:";
        public const string RECIP_ENG_FUEL_AVAILABLE__index = "RECIP ENG FUEL AVAILABLE:";
        public const string RECIP_ENG_FUEL_FLOW__index = "RECIP ENG FUEL FLOW:";
        public const string RECIP_ENG_FUEL_NUMBER_TANKS_USED__index = "RECIP ENG FUEL NUMBER TANKS USED:";
        public const string RECIP_ENG_FUEL_TANKS_USED__index = "RECIP ENG FUEL TANKS USED:";
        public const string RECIP_ENG_FUEL_TANK_SELECTOR__index = "RECIP ENG FUEL TANK SELECTOR:";
        public const string RECIP_ENG_GLOW_PLUG_ACTIVE__index = "RECIP ENG GLOW PLUG ACTIVE:";
        public const string RECIP_ENG_LEFT_MAGNETO__index = "RECIP ENG LEFT MAGNETO:";
        public const string RECIP_ENG_MANIFOLD_PRESSURE__index = "RECIP ENG MANIFOLD PRESSURE:";
        public const string RECIP_ENG_NITROUS_TANK_MAX_QUANTITY__index = "RECIP ENG NITROUS TANK MAX QUANTITY:";
        public const string RECIP_ENG_NITROUS_TANK_QUANTITY__index = "RECIP ENG NITROUS TANK QUANTITY:";
        public const string RECIP_ENG_NITROUS_TANK_VALVE = "RECIP ENG NITROUS TANK VALVE";
        public const string RECIP_ENG_NUM_CYLINDERS__index = "RECIP ENG NUM CYLINDERS:";
        public const string RECIP_ENG_NUM_CYLINDERS_FAILED__index = "RECIP ENG NUM CYLINDERS FAILED:";
        public const string RECIP_ENG_PRIMER__index = "RECIP ENG PRIMER:";
        public const string RECIP_ENG_RADIATOR_TEMPERATURE__index = "RECIP ENG RADIATOR TEMPERATURE:";
        public const string RECIP_ENG_RIGHT_MAGNETO__index = "RECIP ENG RIGHT MAGNETO:";
        public const string RECIP_ENG_STARTER_TORQUE__index = "RECIP ENG STARTER TORQUE:";
        public const string RECIP_ENG_SUPERCHARGER_ACTIVE_GEAR__index = "RECIP ENG SUPERCHARGER ACTIVE GEAR:";
        public const string RECIP_ENG_TURBINE_INLET_TEMPERATURE__index = "RECIP ENG TURBINE INLET TEMPERATURE:";
        public const string RECIP_ENG_TURBOCHARGER_FAILED__index = "RECIP ENG TURBOCHARGER FAILED:";
        public const string RECIP_ENG_WASTEGATE_POSITION__index = "RECIP ENG WASTEGATE POSITION:";
        public const string RECIP_MAX_CHT = "RECIP MAX CHT";
        public const string RECIP_MIXTURE_RATIO__index = "RECIP MIXTURE RATIO:";
        public const string SHUTOFF_VALVE_PULLED = "SHUTOFF VALVE PULLED";
        public const string THROTTLE_LOWER_LIMIT = "THROTTLE LOWER LIMIT";
        public const string TURB_ENG_AFTERBURNER__index = "TURB ENG AFTERBURNER:";
        public const string TURB_ENG_AFTERBURNER_PCT_ACTIVE__index = "TURB ENG AFTERBURNER PCT ACTIVE:";
        public const string TURB_ENG_AFTERBURNER_STAGE_ACTIVE__index = "TURB ENG AFTERBURNER STAGE ACTIVE:";
        public const string TURB_ENG_BLEED_AIR__index = "TURB ENG BLEED AIR:";
        public const string TURB_ENG_COMMANDED_N1__index = "TURB ENG COMMANDED N1:";
        public const string TURB_ENG_CONDITION_LEVER_POSITION__index = "TURB ENG CONDITION LEVER POSITION:";
        public const string TURB_ENG_CORRECTED_FF__index = "TURB ENG CORRECTED FF:";
        public const string TURB_ENG_CORRECTED_N1__index = "TURB ENG CORRECTED N1:";
        public const string TURB_ENG_CORRECTED_N2__index = "TURB ENG CORRECTED N2:";
        public const string TURB_ENG_FREE_TURBINE_TORQUE__index = "TURB ENG FREE TURBINE TORQUE:";
        public const string TURB_ENG_FUEL_AVAILABLE__index = "TURB ENG FUEL AVAILABLE:";
        public const string TURB_ENG_FUEL_EFFICIENCY_LOSS__index = "TURB ENG FUEL EFFICIENCY LOSS:";
        public const string TURB_ENG_FUEL_FLOW_PPH__index = "TURB ENG FUEL FLOW PPH:";
        public const string TURB_ENG_HIGH_IDLE__index = "TURB ENG HIGH IDLE:";
        public const string TURB_ENG_IGNITION_SWITCH__index = "TURB ENG IGNITION SWITCH:";
        public const string TURB_ENG_IGNITION_SWITCH_EX1__index = "TURB ENG IGNITION SWITCH EX1:";
        public const string TURB_ENG_IS_IGNITING__index = "TURB ENG IS IGNITING:";
        public const string TURB_ENG_ITT__index = "TURB ENG ITT:";
        public const string TURB_ENG_ITT_COOLING_EFFICIENCY_LOSS__index = "TURB ENG ITT COOLING EFFICIENCY LOSS:";
        public const string TURB_ENG_JET_THRUST__index = "TURB ENG JET THRUST:";
        public const string TURB_ENG_LOW_IDLE__index = "TURB ENG LOW IDLE:";
        public const string TURB_ENG_MASTER_STARTER_SWITCH = "TURB ENG MASTER STARTER SWITCH";
        public const string TURB_ENG_MAX_TORQUE_PERCENT__index = "TURB ENG MAX TORQUE PERCENT:";
        public const string TURB_ENG_N1__index = "TURB ENG N1:";
        public const string TURB_ENG_N1_LOSS__index = "TURB ENG N1 LOSS:";
        public const string TURB_ENG_N2__index = "TURB ENG N2:";
        public const string TURB_ENG_NUM_TANKS_USED__index = "TURB ENG NUM TANKS USED:";
        public const string TURB_ENG_PRESSURE_RATIO__index = "TURB ENG PRESSURE RATIO:";
        public const string TURB_ENG_PRIMARY_NOZZLE_PERCENT__index = "TURB ENG PRIMARY NOZZLE PERCENT:";
        public const string TURB_ENG_REVERSE_NOZZLE_PERCENT__index = "TURB ENG REVERSE NOZZLE PERCENT:";
        public const string TURB_ENG_TANKS_USED__index = "TURB ENG TANKS USED:";
        public const string TURB_ENG_TANK_SELECTOR__index = "TURB ENG TANK SELECTOR:";
        public const string TURB_ENG_THROTTLE_COMMANDED_N1__index = "TURB ENG THROTTLE COMMANDED N1:";
        public const string TURB_ENG_THRUST_EFFICIENCY_LOSS__index = "TURB ENG THRUST EFFICIENCY LOSS:";
        public const string TURB_ENG_VIBRATION__index = "TURB ENG VIBRATION:";
        public const string TURB_MAX_ITT = "TURB MAX ITT";
      }

      public static class FlightModel
      {
        public const string BETA_DOT = "BETA DOT";
        public const string DECISION_ALTITUDE_MSL = "DECISION ALTITUDE MSL";
        public const string DECISION_HEIGHT = "DECISION HEIGHT";
        public const string DESIGN_CRUISE_ALT = "DESIGN CRUISE ALT";
        public const string DESIGN_SPAWN_ALTITUDE_CRUISE = "DESIGN SPAWN ALTITUDE CRUISE";
        public const string DESIGN_SPAWN_ALTITUDE_DESCENT = "DESIGN SPAWN ALTITUDE DESCENT";
        public const string DESIGN_SPEED_CLIMB = "DESIGN SPEED CLIMB";
        public const string DESIGN_SPEED_MIN_ROTATION = "DESIGN SPEED MIN ROTATION";
        public const string DESIGN_SPEED_VC = "DESIGN SPEED VC";
        public const string DESIGN_SPEED_VS0 = "DESIGN SPEED VS0";
        public const string DESIGN_SPEED_VS1 = "DESIGN SPEED VS1";
        public const string DESIGN_TAKEOFF_SPEED = "DESIGN TAKEOFF SPEED";
        public const string DYNAMIC_PRESSURE = "DYNAMIC PRESSURE";
        public const string ESTIMATED_CRUISE_SPEED = "ESTIMATED CRUISE SPEED";
        public const string G_FORCE = "G FORCE";
        public const string G_LIMITER_SETTING = "G LIMITER SETTING";
        public const string INCIDENCE_ALPHA = "INCIDENCE ALPHA";
        public const string INCIDENCE_BETA = "INCIDENCE BETA";
        public const string IS_TAIL_DRAGGER = "IS TAIL DRAGGER";
        public const string LINEAR_CL_ALPHA = "LINEAR CL ALPHA";
        public const string MACH_MAX_OPERATE = "MACH MAX OPERATE";
        public const string MAX_G_FORCE = "MAX G FORCE";
        public const string MIN_DRAG_VELOCITY = "MIN DRAG VELOCITY";
        public const string MIN_G_FORCE = "MIN G FORCE";
        public const string SEMIBODY_LOADFACTOR_X = "SEMIBODY LOADFACTOR X";
        public const string SEMIBODY_LOADFACTOR_Y = "SEMIBODY LOADFACTOR Y";
        public const string SEMIBODY_LOADFACTOR_YDOT = "SEMIBODY LOADFACTOR YDOT";
        public const string SEMIBODY_LOADFACTOR_Z = "SEMIBODY LOADFACTOR Z";
        public const string SIGMA_SQRT = "SIGMA SQRT";
        public const string SIMULATED_RADIUS = "SIMULATED RADIUS";
        public const string STALL_ALPHA = "STALL ALPHA";
        public const string STATIC_PITCH = "STATIC PITCH";
        public const string TYPICAL_DESCENT_RATE = "TYPICAL DESCENT RATE";
        public const string WING_AREA = "WING AREA";
        public const string WING_FLEX_PCT__index = "WING FLEX PCT:";
        public const string WING_SPAN = "WING SPAN";
        public const string YAW_STRING_ANGLE = "YAW STRING ANGLE";
        public const string YAW_STRING_PCT_EXTENDED = "YAW STRING PCT EXTENDED";
        public const string ZERO_LIFT_ALPHA = "ZERO LIFT ALPHA";
        public const string CG_AFT_LIMIT = "CG AFT LIMIT";
        public const string CG_FEET = "CG FEET";
        public const string CG_FEET_AFT_LIMIT = "CG FEET AFT LIMIT";
        public const string CG_FEET_LATERAL = "CG FEET LATERAL";
        public const string CG_FEET_LATERAL_LEFT_LIMIT = "CG FEET LATERAL LEFT LIMIT";
        public const string CG_FEET_LATERAL_RIGHT_LIMIT = "CG FEET LATERAL RIGHT LIMIT";
        public const string CG_FEET_FWD_LIMIT = "CG FEET FWD LIMIT";
        public const string CG_FWD_LIMIT = "CG FWD LIMIT";
        public const string CG_MAX_MACH = "CG MAX MACH";
        public const string CG_MIN_MACH = "CG MIN MACH";
        public const string CG_PERCENT = "CG PERCENT";
        public const string CG_PERCENT_LATERAL = "CG PERCENT LATERAL";
        public const string STATIC_CG_TO_GROUND = "STATIC CG TO GROUND";
        public const string INTERACTIVE_POINT_BANK = "INTERACTIVE POINT BANK";
        public const string INTERACTIVE_POINT_HEADING = "INTERACTIVE POINT HEADING";
        public const string INTERACTIVE_POINT_JETWAY_LEFT_BEND = "INTERACTIVE POINT JETWAY LEFT BEND";
        public const string INTERACTIVE_POINT_JETWAY_LEFT_DEPLOYMENT = "INTERACTIVE POINT JETWAY LEFT DEPLOYMENT";
        public const string INTERACTIVE_POINT_JETWAY_RIGHT_BEND = "INTERACTIVE POINT JETWAY RIGHT BEND";
        public const string INTERACTIVE_POINT_JETWAY_RIGHT_DEPLOYMENT = "INTERACTIVE POINT JETWAY RIGHT DEPLOYMENT";
        public const string INTERACTIVE_POINT_JETWAY_TOP_HORIZONTAL = "INTERACTIVE POINT JETWAY TOP HORIZONTAL";
        public const string INTERACTIVE_POINT_JETWAY_TOP_VERTICAL = "INTERACTIVE POINT JETWAY TOP VERTICAL";
        public const string INTERACTIVE_POINT_GOAL = "INTERACTIVE POINT GOAL";
        public const string INTERACTIVE_POINT_OPEN = "INTERACTIVE POINT OPEN";
        public const string INTERACTIVE_POINT_PITCH = "INTERACTIVE POINT PITCH";
        public const string INTERACTIVE_POINT_POSX = "INTERACTIVE POINT POSX";
        public const string INTERACTIVE_POINT_POSY = "INTERACTIVE POINT POSY";
        public const string INTERACTIVE_POINT_POSZ = "INTERACTIVE POINT POSZ";
        public const string INTERACTIVE_POINT_TYPE = "INTERACTIVE POINT TYPE";
        public const string EMPTY_WEIGHT = "EMPTY WEIGHT";
        public const string EMPTY_WEIGHT_CROSS_COUPLED_MOI = "EMPTY WEIGHT CROSS COUPLED MOI";
        public const string EMPTY_WEIGHT_PITCH_MOI = "EMPTY WEIGHT PITCH MOI";
        public const string EMPTY_WEIGHT_ROLL_MOI = "EMPTY WEIGHT ROLL MOI";
        public const string EMPTY_WEIGHT_YAW_MOI = "EMPTY WEIGHT YAW MOI";
        public const string MAX_GROSS_WEIGHT = "MAX GROSS WEIGHT";
        public const string TOTAL_WEIGHT = "TOTAL WEIGHT";
        public const string TOTAL_WEIGHT_CROSS_COUPLED_MOI = "TOTAL WEIGHT CROSS COUPLED MOI";
        public const string TOTAL_WEIGHT_PITCH_MOI = "TOTAL WEIGHT PITCH MOI";
        public const string TOTAL_WEIGHT_ROLL_MOI = "TOTAL WEIGHT ROLL MOI";
        public const string TOTAL_WEIGHT_YAW_MOI = "TOTAL WEIGHT YAW MOI";
      }
      public static class Fuel
      {
        public const string FUEL_CROSS_FEED__index = "FUEL CROSS FEED:";
        public const string FUEL_DUMP_ACTIVE = "FUEL DUMP ACTIVE";
        public const string FUEL_DUMP_SWITCH = "FUEL DUMP SWITCH";
        public const string FUEL_LEFT_CAPACITY = "FUEL LEFT CAPACITY";
        public const string FUEL_LEFT_QUANTITY = "FUEL LEFT QUANTITY";
        public const string FUEL_PUMP = "FUEL PUMP";
        public const string FUEL_RIGHT_CAPACITY = "FUEL RIGHT CAPACITY";
        public const string FUEL_RIGHT_QUANTITY = "FUEL RIGHT QUANTITY";
        public const string FUEL_SELECTED_QUANTITY__index = "FUEL SELECTED QUANTITY:";
        public const string FUEL_SELECTED_QUANTITY_PERCENT__index = "FUEL SELECTED QUANTITY PERCENT:";
        public const string FUEL_SELECTED_TRANSFER_MODE = "FUEL SELECTED TRANSFER MODE";
        public const string FUEL_TOTAL_CAPACITY = "FUEL TOTAL CAPACITY";
        public const string FUEL_TOTAL_QUANTITY = "FUEL TOTAL QUANTITY";
        public const string FUEL_TOTAL_QUANTITY_WEIGHT = "FUEL TOTAL QUANTITY WEIGHT";
        public const string FUEL_TRANSFER_PUMP_ON__index = "FUEL TRANSFER PUMP ON:";
        public const string FUEL_WEIGHT_PER_GALLON = "FUEL WEIGHT PER GALLON";
        public const string NEW_FUEL_SYSTEM = "NEW FUEL SYSTEM";
        public const string NUM_FUEL_SELECTORS = "NUM FUEL SELECTORS";
        public const string UNLIMITED_FUEL = "UNLIMITED FUEL";
        public const string UNUSABLE_FUEL_TOTAL_QUANTITY = "UNUSABLE FUEL TOTAL QUANTITY";
        public const string FUELSYSTEM_ENGINE_PRESSURE__index = "FUELSYSTEM ENGINE PRESSURE:";
        public const string FUELSYSTEM_JUNCTION_SETTING__index = "FUELSYSTEM JUNCTION SETTING:";
        public const string FUELSYSTEM_LINE_FUEL_FLOW__index = "FUELSYSTEM LINE FUEL FLOW:";
        public const string FUELSYSTEM_LINE_FUEL_LEVEL__index = "FUELSYSTEM LINE FUEL LEVEL:";
        public const string FUELSYSTEM_LINE_FUEL_PRESSURE__index = "FUELSYSTEM LINE FUEL PRESSURE:";
        public const string FUELSYSTEM_PUMP_ACTIVE__index = "FUELSYSTEM PUMP ACTIVE:";
        public const string FUELSYSTEM_PUMP_SWITCH__index = "FUELSYSTEM PUMP SWITCH:";
        public const string FUELSYSTEM_TANK_CAPACITY__index = "FUELSYSTEM TANK CAPACITY:";
        public const string FUELSYSTEM_TANK_LEVEL__index = "FUELSYSTEM TANK LEVEL:";
        public const string FUELSYSTEM_TANK_QUANTITY__index = "FUELSYSTEM TANK QUANTITY:";
        public const string FUELSYSTEM_TANK_TOTAL_QUANTITY__index = "FUELSYSTEM TANK TOTAL QUANTITY:";
        public const string FUELSYSTEM_TANK_WEIGHT__index = "FUELSYSTEM TANK WEIGHT:";
        public const string FUELSYSTEM_TRIGGER_STATUS__index = "FUELSYSTEM TRIGGER STATUS:";
        public const string FUELSYSTEM_VALVE_OPEN__index = "FUELSYSTEM VALVE OPEN:";
        public const string FUELSYSTEM_VALVE_SWITCH__index = "FUELSYSTEM VALVE SWITCH:";
        public const string FUEL_TANK_CENTER_CAPACITY = "FUEL TANK CENTER CAPACITY";
        public const string FUEL_TANK_CENTER2_CAPACITY = "FUEL TANK CENTER2 CAPACITY";
        public const string FUEL_TANK_CENTER3_CAPACITY = "FUEL TANK CENTER3 CAPACITY";
        public const string FUEL_TANK_CENTER_LEVEL = "FUEL TANK CENTER LEVEL";
        public const string FUEL_TANK_CENTER2_LEVEL = "FUEL TANK CENTER2 LEVEL";
        public const string FUEL_TANK_CENTER3_LEVEL = "FUEL TANK CENTER3 LEVEL";
        public const string FUEL_TANK_CENTER_QUANTITY = "FUEL TANK CENTER QUANTITY";
        public const string FUEL_TANK_CENTER2_QUANTITY = "FUEL TANK CENTER2 QUANTITY";
        public const string FUEL_TANK_CENTER3_QUANTITY = "FUEL TANK CENTER3 QUANTITY";
        public const string FUEL_TANK_EXTERNAL1_CAPACITY = "FUEL TANK EXTERNAL1 CAPACITY";
        public const string FUEL_TANK_EXTERNAL2_CAPACITY = "FUEL TANK EXTERNAL2 CAPACITY";
        public const string FUEL_TANK_EXTERNAL1_LEVEL = "FUEL TANK EXTERNAL1 LEVEL";
        public const string FUEL_TANK_EXTERNAL2_LEVEL = "FUEL TANK EXTERNAL2 LEVEL";
        public const string FUEL_TANK_EXTERNAL1_QUANTITY = "FUEL TANK EXTERNAL1 QUANTITY";
        public const string FUEL_TANK_EXTERNAL2_QUANTITY = "FUEL TANK EXTERNAL2 QUANTITY";
        public const string FUEL_TANK_LEFT_AUX_CAPACITY = "FUEL TANK LEFT AUX CAPACITY";
        public const string FUEL_TANK_LEFT_AUX_LEVEL = "FUEL TANK LEFT AUX LEVEL";
        public const string FUEL_TANK_LEFT_AUX_QUANTITY = "FUEL TANK LEFT AUX QUANTITY";
        public const string FUEL_TANK_LEFT_MAIN_CAPACITY = "FUEL TANK LEFT MAIN CAPACITY";
        public const string FUEL_TANK_LEFT_MAIN_LEVEL = "FUEL TANK LEFT MAIN LEVEL";
        public const string FUEL_TANK_LEFT_MAIN_QUANTITY = "FUEL TANK LEFT MAIN QUANTITY";
        public const string FUEL_TANK_LEFT_TIP_CAPACITY = "FUEL TANK LEFT TIP CAPACITY";
        public const string FUEL_TANK_LEFT_TIP_LEVEL = "FUEL TANK LEFT TIP LEVEL";
        public const string FUEL_TANK_LEFT_TIP_QUANTITY = "FUEL TANK LEFT TIP QUANTITY";
        public const string FUEL_TANK_RIGHT_AUX_CAPACITY = "FUEL TANK RIGHT AUX CAPACITY";
        public const string FUEL_TANK_RIGHT_AUX_LEVEL = "FUEL TANK RIGHT AUX LEVEL";
        public const string FUEL_TANK_RIGHT_AUX_QUANTITY = "FUEL TANK RIGHT AUX QUANTITY";
        public const string FUEL_TANK_RIGHT_MAIN_CAPACITY = "FUEL TANK RIGHT MAIN CAPACITY";
        public const string FUEL_TANK_RIGHT_MAIN_LEVEL = "FUEL TANK RIGHT MAIN LEVEL";
        public const string FUEL_TANK_RIGHT_MAIN_QUANTITY = "FUEL TANK RIGHT MAIN QUANTITY";
        public const string FUEL_TANK_RIGHT_TIP_CAPACITY = "FUEL TANK RIGHT TIP CAPACITY";
        public const string FUEL_TANK_RIGHT_TIP_LEVEL = "FUEL TANK RIGHT TIP LEVEL";
        public const string FUEL_TANK_RIGHT_TIP_QUANTITY = "FUEL TANK RIGHT TIP QUANTITY";
        public const string FUEL_TANK_SELECTOR__index = "FUEL TANK SELECTOR:";
      }
      public static class RadioAndNavigation
      {
        public const string ADF_ACTIVE_FREQUENCY__index = "ADF ACTIVE FREQUENCY:";
        public const string ADF_AVAILABLE__index = "ADF AVAILABLE:";
        public const string ADF_CARD = "ADF CARD";
        public const string ADF_IDENT = "ADF IDENT";
        public const string ADF_LATLONALT__index = "ADF LATLONALT:";
        public const string ADF_NAME__index = "ADF NAME:";
        public const string ADF_RADIAL__index = "ADF RADIAL:";
        public const string ADF_RADIAL_MAG__index = "ADF RADIAL MAG:";
        public const string ADF_SIGNAL__index = "ADF SIGNAL:";
        public const string ADF_SOUND__index = "ADF SOUND:";
        public const string ADF_STANDBY_AVAILABLE__index = "ADF STANDBY AVAILABLE:";
        public const string ADF_STANDBY_FREQUENCY__index = "ADF STANDBY FREQUENCY:";
        public const string ADF_VOLUME = "ADF VOLUME";
        public const string ATC_AIRLINE = "ATC AIRLINE";
        public const string ATC_AIRPORT_IS_TOWERED = "ATC AIRPORT IS TOWERED";
        public const string ATC_CLEARED_IFR = "ATC CLEARED IFR";
        public const string ATC_CLEARED_LANDING = "ATC CLEARED LANDING";
        public const string ATC_CLEARED_TAKEOFF = "ATC CLEARED TAKEOFF";
        public const string ATC_CLEARED_TAXI = "ATC CLEARED TAXI";
        public const string ATC_CURRENT_WAYPOINT_ALTITUDE = "ATC CURRENT WAYPOINT ALTITUDE";
        public const string ATC_FLIGHT_NUMBER = "ATC FLIGHT NUMBER";
        public const string ATC_FLIGHTPLAN_DIFF_ALT = "ATC FLIGHTPLAN DIFF ALT";
        public const string ATC_FLIGHTPLAN_DIFF_DISTANCE = "ATC FLIGHTPLAN DIFF DISTANCE";
        public const string ATC_FLIGHTPLAN_DIFF_HEADING = "ATC FLIGHTPLAN DIFF HEADING";
        public const string ATC_HEAVY = "ATC HEAVY";
        public const string ATC_ID = "ATC ID";
        public const string ATC_IFR_FP_TO_REQUEST = "ATC IFR FP TO REQUEST";
        public const string ATC_MODEL = "ATC MODEL";
        public const string ATC_ON_PARKING_SPOT = "ATC ON PARKING SPOT";
        public const string ATC_PREVIOUS_WAYPOINT_ALTITUDE = "ATC PREVIOUS WAYPOINT ALTITUDE";
        public const string ATC_RUNWAY_AIRPORT_NAME = "ATC RUNWAY AIRPORT NAME";
        public const string ATC_RUNWAY_DISTANCE = "ATC RUNWAY DISTANCE";
        public const string ATC_RUNWAY_END_DISTANCE = "ATC RUNWAY END DISTANCE";
        public const string ATC_RUNWAY_HEADING_DEGREES_TRUE = "ATC RUNWAY HEADING DEGREES TRUE";
        public const string ATC_RUNWAY_LENGTH = "ATC RUNWAY LENGTH";
        public const string ATC_RUNWAY_RELATIVE_POSITION_X = "ATC RUNWAY RELATIVE POSITION X";
        public const string ATC_RUNWAY_RELATIVE_POSITION_Y = "ATC RUNWAY RELATIVE POSITION Y";
        public const string ATC_RUNWAY_RELATIVE_POSITION_Z = "ATC RUNWAY RELATIVE POSITION Z";
        public const string ATC_RUNWAY_SELECTED = "ATC RUNWAY SELECTED";
        public const string ATC_RUNWAY_START_DISTANCE = "ATC RUNWAY START DISTANCE";
        public const string ATC_RUNWAY_TDPOINT_RELATIVE_POSITION_X = "ATC RUNWAY TDPOINT RELATIVE POSITION X";
        public const string ATC_RUNWAY_TDPOINT_RELATIVE_POSITION_Y = "ATC RUNWAY TDPOINT RELATIVE POSITION Y";
        public const string ATC_RUNWAY_TDPOINT_RELATIVE_POSITION_Z = "ATC RUNWAY TDPOINT RELATIVE POSITION Z";
        public const string ATC_RUNWAY_WIDTH = "ATC RUNWAY WIDTH";
        public const string ATC_SUGGESTED_MIN_RWY_LANDING = "ATC SUGGESTED MIN RWY LANDING";
        public const string ATC_SUGGESTED_MIN_RWY_TAKEOFF = "ATC SUGGESTED MIN RWY TAKEOFF";
        public const string ATC_TAXIPATH_DISTANCE = "ATC TAXIPATH DISTANCE";
        public const string ATC_TYPE = "ATC TYPE";
        public const string COM1_STORED_FREQUENCY = "COM1 STORED FREQUENCY";
        public const string COM2_STORED_FREQUENCY = "COM2 STORED FREQUENCY";
        public const string COM3_STORED_FREQUENCY = "COM3 STORED FREQUENCY";
        public const string COM_ACTIVE_BEARING__index = "COM ACTIVE BEARING:";
        public const string COM_ACTIVE_DISTANCE__index = "COM ACTIVE DISTANCE:";
        public const string COM_ACTIVE_FREQUENCY__index = "COM ACTIVE FREQUENCY:";
        public const string COM_ACTIVE_FREQ_IDENT__index = "COM ACTIVE FREQ IDENT:";
        public const string COM_ACTIVE_FREQ_TYPE__index = "COM ACTIVE FREQ TYPE:";
        public const string COM_ACTIVE_LATLONALT__index = "COM ACTIVE LATLONALT:";
        public const string COM_AVAILABLE__index = "COM AVAILABLE:";
        public const string COM_RECEIVE__index = "COM RECEIVE:";
        public const string COM_RECEIVE_ALL = "COM RECEIVE ALL";
        public const string COM_RECEIVE_EX1__index = "COM RECEIVE EX1:";
        public const string COM_SPACING_MODE__index = "COM SPACING MODE:";
        public const string COM_STANDBY_FREQUENCY__index = "COM STANDBY FREQUENCY:";
        public const string COM_STANDBY_FREQ_IDENT__index = "COM STANDBY FREQ IDENT:";
        public const string COM_STANDBY_FREQ_TYPE__index = "COM STANDBY FREQ TYPE:";
        public const string COM_STATUS__index = "COM STATUS:";
        public const string COM_TEST__index = "COM TEST:";
        public const string COM_TRANSMIT__index = "COM TRANSMIT:";
        public const string COM_VOLUME = "COM VOLUME";
        public const string FLARM_AVAILABLE = "FLARM AVAILABLE";
        public const string FLARM_THREAT_BEARING = "FLARM THREAT BEARING";
        public const string FLARM_THREAT_DATA = "FLARM THREAT DATA";
        public const string FLARM_THREAT_DISTANCE = "FLARM THREAT DISTANCE";
        public const string FLARM_THREAT_HEADING = "FLARM THREAT HEADING";
        public const string FLARM_THREAT_RELATIVE_ALTITUDE = "FLARM THREAT RELATIVE ALTITUDE";
        public const string FLARM_THREAT_TIME_TO_COLLISION = "FLARM THREAT TIME TO COLLISION";
        public const string FLARM_THREAT_VERTICAL_BEARING = "FLARM THREAT VERTICAL BEARING";
        public const string GPS_APPROACH_AIRPORT_ID = "GPS APPROACH AIRPORT ID";
        public const string GPS_APPROACH_APPROACH_ID = "GPS APPROACH APPROACH ID";
        public const string GPS_APPROACH_APPROACH_INDEX = "GPS APPROACH APPROACH INDEX";
        public const string GPS_APPROACH_APPROACH_TYPE = "GPS APPROACH APPROACH TYPE";
        public const string GPS_APPROACH_IS_FINAL = "GPS APPROACH IS FINAL";
        public const string GPS_APPROACH_IS_MISSED = "GPS APPROACH IS MISSED";
        public const string GPS_APPROACH_IS_WP_RUNWAY = "GPS APPROACH IS WP RUNWAY";
        public const string GPS_APPROACH_MODE = "GPS APPROACH MODE";
        public const string GPS_APPROACH_SEGMENT_TYPE = "GPS APPROACH SEGMENT TYPE";
        public const string GPS_APPROACH_TIMEZONE_DEVIATION = "GPS APPROACH TIMEZONE DEVIATION";
        public const string GPS_APPROACH_TRANSITION_ID = "GPS APPROACH TRANSITION ID";
        public const string GPS_APPROACH_TRANSITION_INDEX = "GPS APPROACH TRANSITION INDEX";
        public const string GPS_APPROACH_WP_COUNT = "GPS APPROACH WP COUNT";
        public const string GPS_APPROACH_WP_INDEX = "GPS APPROACH WP INDEX";
        public const string GPS_APPROACH_WP_TYPE = "GPS APPROACH WP TYPE";
        public const string GPS_CDI_NEEDLE = "GPS CDI NEEDLE";
        public const string GPS_CDI_SCALING = "GPS CDI SCALING";
        public const string GPS_COURSE_TO_STEER = "GPS COURSE TO STEER";
        public const string GPS_DRIVES_NAV1 = "GPS DRIVES NAV1";
        public const string GPS_ETA = "GPS ETA";
        public const string GPS_ETE = "GPS ETE";
        public const string GPS_FLIGHTPLAN_TOTAL_DISTANCE = "GPS FLIGHTPLAN TOTAL DISTANCE";
        public const string GPS_FLIGHT_PLAN_WP_COUNT = "GPS FLIGHT PLAN WP COUNT";
        public const string GPS_FLIGHT_PLAN_WP_INDEX = "GPS FLIGHT PLAN WP INDEX";
        public const string GPS_GROUND_MAGNETIC_TRACK = "GPS GROUND MAGNETIC TRACK";
        public const string GPS_GROUND_SPEED = "GPS GROUND SPEED";
        public const string GPS_GROUND_TRUE_HEADING = "GPS GROUND TRUE HEADING";
        public const string GPS_GROUND_TRUE_TRACK = "GPS GROUND TRUE TRACK";
        public const string GPS_GSI_SCALING = "GPS GSI SCALING";
        public const string GPS_HAS_GLIDEPATH = "GPS HAS GLIDEPATH";
        public const string GPS_HSI_NEEDLE = "GPS HSI NEEDLE";
        public const string GPS_IS_ACTIVE_FLIGHT_PLAN = "GPS IS ACTIVE FLIGHT PLAN";
        public const string GPS_IS_ACTIVE_WAY_POINT = "GPS IS ACTIVE WAY POINT";
        public const string GPS_IS_ACTIVE_WP_LOCKED = "GPS IS ACTIVE WP LOCKED";
        public const string GPS_IS_APPROACH_ACTIVE = "GPS IS APPROACH ACTIVE";
        public const string GPS_IS_APPROACH_LOADED = "GPS IS APPROACH LOADED";
        public const string GPS_IS_ARRIVED = "GPS IS ARRIVED";
        public const string GPS_IS_DIRECTTO_FLIGHTPLAN = "GPS IS DIRECTTO FLIGHTPLAN";
        public const string GPS_MAGVAR = "GPS MAGVAR";
        public const string GPS_OBS_ACTIVE = "GPS OBS ACTIVE";
        public const string GPS_OBS_VALUE = "GPS OBS VALUE";
        public const string GPS_OVERRIDDEN = "GPS OVERRIDDEN";
        public const string GPS_POSITION_ALT = "GPS POSITION ALT";
        public const string GPS_POSITION_LAT = "GPS POSITION LAT";
        public const string GPS_POSITION_LON = "GPS POSITION LON";
        public const string GPS_TARGET_ALTITUDE = "GPS TARGET ALTITUDE";
        public const string GPS_TARGET_DISTANCE = "GPS TARGET DISTANCE";
        public const string GPS_VERTICAL_ANGLE = "GPS VERTICAL ANGLE";
        public const string GPS_VERTICAL_ANGLE_ERROR = "GPS VERTICAL ANGLE ERROR";
        public const string GPS_VERTICAL_ERROR = "GPS VERTICAL ERROR";
        public const string GPS_WP_BEARING = "GPS WP BEARING";
        public const string GPS_WP_CROSS_TRK = "GPS WP CROSS TRK";
        public const string GPS_WP_DESIRED_TRACK = "GPS WP DESIRED TRACK";
        public const string GPS_WP_DISTANCE = "GPS WP DISTANCE";
        public const string GPS_WP_ETA = "GPS WP ETA";
        public const string GPS_WP_ETE = "GPS WP ETE";
        public const string GPS_WP_NEXT_ALT = "GPS WP NEXT ALT";
        public const string GPS_WP_NEXT_ID = "GPS WP NEXT ID";
        public const string GPS_WP_NEXT_LAT = "GPS WP NEXT LAT";
        public const string GPS_WP_NEXT_LON = "GPS WP NEXT LON";
        public const string GPS_WP_PREV_ALT = "GPS WP PREV ALT";
        public const string GPS_WP_PREV_ID = "GPS WP PREV ID";
        public const string GPS_WP_PREV_LAT = "GPS WP PREV LAT";
        public const string GPS_WP_PREV_LON = "GPS WP PREV LON";
        public const string GPS_WP_PREV_VALID = "GPS WP PREV VALID";
        public const string GPS_WP_TRACK_ANGLE_ERROR = "GPS WP TRACK ANGLE ERROR";
        public const string GPS_WP_TRUE_BEARING = "GPS WP TRUE BEARING";
        public const string GPS_WP_TRUE_REQ_HDG = "GPS WP TRUE REQ HDG";
        public const string GPS_WP_VERTICAL_SPEED = "GPS WP VERTICAL SPEED";
        public const string HSI_BEARING = "HSI BEARING";
        public const string HSI_BEARING_VALID = "HSI BEARING VALID";
        public const string HSI_CDI_NEEDLE = "HSI CDI NEEDLE";
        public const string HSI_CDI_NEEDLE_VALID = "HSI CDI NEEDLE VALID";
        public const string HSI_DISTANCE = "HSI DISTANCE";
        public const string HSI_GSI_NEEDLE = "HSI GSI NEEDLE";
        public const string HSI_GSI_NEEDLE_VALID = "HSI GSI NEEDLE VALID";
        public const string HSI_HAS_LOCALIZER = "HSI HAS LOCALIZER";
        public const string HSI_SPEED = "HSI SPEED";
        public const string HSI_STATION_IDENT = "HSI STATION IDENT";
        public const string HSI_TF_FLAGS = "HSI TF FLAGS";
        public const string INNER_MARKER = "INNER MARKER";
        public const string INNER_MARKER_LATLONALT = "INNER MARKER LATLONALT";
        public const string MARKER_AVAILABLE = "MARKER AVAILABLE";
        public const string MARKER_BEACON_SENSITIVITY_HIGH = "MARKER BEACON SENSITIVITY HIGH";
        public const string MARKER_BEACON_STATE = "MARKER BEACON STATE";
        public const string MARKER_BEACON_TEST_MUTE = "MARKER BEACON TEST MUTE";
        public const string MARKER_SOUND = "MARKER SOUND";
        public const string MIDDLE_MARKER = "MIDDLE MARKER";
        public const string MIDDLE_MARKER_LATLONALT = "MIDDLE MARKER LATLONALT";
        public const string OUTER_MARKER = "OUTER MARKER";
        public const string OUTER_MARKER_LATLONALT = "OUTER MARKER LATLONALT";
        public const string NAV_ACTIVE_FREQUENCY__index = "NAV ACTIVE FREQUENCY:";
        public const string NAV_AVAILABLE__index = "NAV AVAILABLE:";
        public const string NAV_BACK_COURSE_FLAGS__index = "NAV BACK COURSE FLAGS:";
        public const string NAV_CDI__index = "NAV CDI:";
        public const string NAV_CLOSE_DME__index = "NAV CLOSE DME:";
        public const string NAV_CLOSE_FREQUENCY__index = "NAV CLOSE FREQUENCY:";
        public const string NAV_CLOSE_IDENT__index = "NAV CLOSE IDENT:";
        public const string NAV_CLOSE_LOCALIZER__index = "NAV CLOSE LOCALIZER:";
        public const string NAV_CLOSE_NAME__index = "NAV CLOSE NAME:";
        public const string NAV_CODES = "NAV CODES";
        public const string NAV_DME = "NAV DME";
        public const string NAV_DMESPEED = "NAV DMESPEED";
        public const string NAV_DME_LATLONALT__index = "NAV DME LATLONALT:";
        public const string NAV_FREQUENCY = "NAV FREQUENCY";
        public const string NAV_GLIDE_SLOPE = "NAV GLIDE SLOPE";
        public const string NAV_GLIDE_SLOPE_ERROR = "NAV GLIDE SLOPE ERROR";
        public const string NAV_GLIDE_SLOPE_LENGTH = "NAV GLIDE SLOPE LENGTH";
        public const string NAV_GSI = "NAV GSI";
        public const string NAV_GS_FLAG = "NAV GS FLAG";
        public const string NAV_GS_LATLONALT__index = "NAV GS LATLONALT:";
        public const string NAV_GS_LLAF64 = "NAV GS LLAF64";
        public const string NAV_HAS_CLOSE_DME = "NAV HAS CLOSE DME";
        public const string NAV_HAS_CLOSE_LOCALIZER = "NAV HAS CLOSE LOCALIZER";
        public const string NAV_HAS_DME = "NAV HAS DME";
        public const string NAV_HAS_GLIDE_SLOPE = "NAV HAS GLIDE SLOPE";
        public const string NAV_HAS_LOCALIZER = "NAV HAS LOCALIZER";
        public const string NAV_HAS_NAV = "NAV HAS NAV";
        public const string NAV_HAS_TACAN = "NAV HAS TACAN";
        public const string NAV_IDENT = "NAV IDENT";
        public const string NAV_LOCALIZER = "NAV LOCALIZER";
        public const string NAV_LOC_AIRPORT_IDENT = "NAV LOC AIRPORT IDENT";
        public const string NAV_LOC_RUNWAY_DESIGNATOR = "NAV LOC RUNWAY DESIGNATOR";
        public const string NAV_LOC_RUNWAY_NUMBER = "NAV LOC RUNWAY NUMBER";
        public const string NAV_MAGVAR = "NAV MAGVAR";
        public const string NAV_NAME = "NAV NAME";
        public const string NAV_OBS = "NAV OBS";
        public const string NAV_RADIAL = "NAV RADIAL";
        public const string NAV_RADIAL_ERROR = "NAV RADIAL ERROR";
        public const string NAV_RAW_GLIDE_SLOPE = "NAV RAW GLIDE SLOPE";
        public const string NAV_RELATIVE_BEARING_TO_STATION = "NAV RELATIVE BEARING TO STATION";
        public const string NAV_SIGNAL = "NAV SIGNAL";
        public const string NAV_SOUND__index = "NAV SOUND:";
        public const string NAV_STANDBY_FREQUENCY__index = "NAV STANDBY FREQUENCY:";
        public const string NAV_TOFROM = "NAV TOFROM";
        public const string NAV_VOLUME = "NAV VOLUME";
        public const string NAV_VOR_DISTANCE = "NAV VOR DISTANCE";
        public const string NAV_VOR_LATLONALT__index = "NAV VOR LATLONALT:";
        public const string NAV_VOR_LLAF64 = "NAV VOR LLAF64";
        public const string TACAN_ACTIVE_CHANNEL__index = "TACAN ACTIVE CHANNEL:";
        public const string TACAN_ACTIVE_MODE__index = "TACAN ACTIVE MODE:";
        public const string TACAN_AVAILABLE__index = "TACAN AVAILABLE:";
        public const string TACAN_DRIVES_NAV1__index = "TACAN DRIVES NAV1:";
        public const string TACAN_OBS__index = "TACAN OBS:";
        public const string TACAN_STANDBY_CHANNEL__index = "TACAN STANDBY CHANNEL:";
        public const string TACAN_STANDBY_MODE__index = "TACAN STANDBY MODE:";
        public const string TACAN_STATION_CDI__index = "TACAN STATION CDI:";
        public const string TACAN_STATION_DISTANCE__index = "TACAN STATION DISTANCE:";
        public const string TACAN_STATION_IDENT__index = "TACAN STATION IDENT:";
        public const string TACAN_STATION_LATLONALT__index = "TACAN STATION LATLONALT:";
        public const string TACAN_STATION_RADIAL__index = "TACAN STATION RADIAL:";
        public const string TACAN_STATION_RADIAL_ERROR__index = "TACAN STATION RADIAL ERROR:";
        public const string TACAN_STATION_TOFROM__index = "TACAN STATION TOFROM:";
        public const string TACAN_VOLUME__index = "TACAN VOLUME:";
        public const string COPILOT_TRANSMITTER_TYPE = "COPILOT TRANSMITTER TYPE";
        public const string COPILOT_TRANSMITTING = "COPILOT TRANSMITTING";
        public const string PILOT_TRANSMITTER_TYPE = "PILOT TRANSMITTER TYPE";
        public const string PILOT_TRANSMITTING = "PILOT TRANSMITTING";
        public const string RADIOS_AVAILABLE = "RADIOS AVAILABLE";
        public const string RADIO_HEIGHT = "RADIO HEIGHT";
        public const string TRANSPONDER_AVAILABLE = "TRANSPONDER AVAILABLE";
        public const string TRANSPONDER_CODE__index = "TRANSPONDER CODE:";
        public const string TRANSPONDER_IDENT = "TRANSPONDER IDENT";
        public const string TRANSPONDER_STATE = "TRANSPONDER STATE";



      }

      public static class Systems
      {
        public const string AIRSPEED_TRUE_CALIBRATE = "AIRSPEED TRUE CALIBRATE";
        public const string ALTERNATE_STATIC_SOURCE_OPEN__index = "ALTERNATE STATIC SOURCE OPEN:";
        public const string ANEMOMETER_PCT_RPM = "ANEMOMETER PCT RPM";
        public const string ANGLE_OF_ATTACK_INDICATOR = "ANGLE OF ATTACK INDICATOR";
        public const string ANNUNCIATOR_SWITCH = "ANNUNCIATOR SWITCH";
        public const string APPLY_HEAT_TO_SYSTEMS = "APPLY HEAT TO SYSTEMS";
        public const string AUDIO_PANEL_AVAILABLE = "AUDIO PANEL AVAILABLE";
        public const string AUDIO_PANEL_VOLUME = "AUDIO PANEL VOLUME";
        public const string AUTOTHROTTLE_ACTIVE = "AUTOTHROTTLE ACTIVE";
        public const string AUTO_COORDINATION = "AUTO COORDINATION";
        public const string AVIONICS_MASTER_SWITCH__index = "AVIONICS MASTER SWITCH:";
        public const string CABIN_NO_SMOKING_ALERT_SWITCH = "CABIN NO SMOKING ALERT SWITCH";
        public const string CABIN_SEATBELTS_ALERT_SWITCH = "CABIN SEATBELTS ALERT SWITCH";
        public const string CANOPY_OPEN = "CANOPY OPEN";
        public const string CARB_HEAT_AVAILABLE = "CARB HEAT AVAILABLE";
        public const string DELTA_HEADING_RATE = "DELTA HEADING RATE";
        public const string DME_SOUND = "DME SOUND";
        public const string ELT_ACTIVATED = "ELT ACTIVATED";
        public const string EXTERNAL_SYSTEM_VALUE = "EXTERNAL SYSTEM VALUE";
        public const string FIRE_BOTTLE_DISCHARGED = "FIRE BOTTLE DISCHARGED";
        public const string FIRE_BOTTLE_SWITCH = "FIRE BOTTLE SWITCH";
        public const string GLASSCOCKPIT_AUTOMATIC_BRIGHTNESS = "GLASSCOCKPIT AUTOMATIC BRIGHTNESS";
        public const string GPWS_SYSTEM_ACTIVE = "GPWS SYSTEM ACTIVE";
        public const string GPWS_WARNING = "GPWS WARNING";
        public const string GYRO_DRIFT_ERROR = "GYRO DRIFT ERROR";
        public const string HAS_STALL_PROTECTION = "HAS STALL PROTECTION";
        public const string HEADING_INDICATOR = "HEADING INDICATOR";
        public const string INDICATED_ALTITUDE = "INDICATED ALTITUDE";
        public const string INDICATED_ALTITUDE_CALIBRATED = "INDICATED ALTITUDE CALIBRATED";
        public const string INDICATED_ALTITUDE_EX1 = "INDICATED ALTITUDE EX1";
        public const string INDUCTOR_COMPASS_HEADING_REF = "INDUCTOR COMPASS HEADING REF";
        public const string INDUCTOR_COMPASS_PERCENT_DEVIATION = "INDUCTOR COMPASS PERCENT DEVIATION";
        public const string INSTRUMENTS_AVAILABLE = "INSTRUMENTS AVAILABLE";
        public const string INTERCOM_MODE = "INTERCOM MODE";
        public const string INTERCOM_SYSTEM_ACTIVE = "INTERCOM SYSTEM ACTIVE";
        public const string IS_ALTITUDE_FREEZE_ON = "IS ALTITUDE FREEZE ON";
        public const string IS_ATTITUDE_FREEZE_ON = "IS ATTITUDE FREEZE ON";
        public const string IS_LATITUDE_LONGITUDE_FREEZE_ON = "IS LATITUDE LONGITUDE FREEZE ON";
        public const string KOHLSMAN_SETTING_HG__index = "KOHLSMAN SETTING HG:";
        public const string KOHLSMAN_SETTING_MB__index = "KOHLSMAN SETTING MB:";
        public const string KOHLSMAN_SETTING_STD__index = "KOHLSMAN SETTING STD:";
        public const string MAGNETIC_COMPASS = "MAGNETIC COMPASS";
        public const string MANUAL_FUEL_PUMP_HANDLE = "MANUAL FUEL PUMP HANDLE";
        public const string OVERSPEED_WARNING = "OVERSPEED WARNING";
        public const string PANEL_ANTI_ICE_SWITCH = "PANEL ANTI ICE SWITCH";
        public const string PITOT_ICE_PCT = "PITOT ICE PCT";
        public const string PITOT_HEAT = "PITOT HEAT";
        public const string PITOT_HEAT_SWITCH__index = "PITOT HEAT SWITCH:";
        public const string PLANE_HEADING_DEGREES_GYRO = "PLANE HEADING DEGREES GYRO";
        public const string PRESSURE_ALTITUDE = "PRESSURE ALTITUDE";
        public const string PRESSURIZATION_CABIN_ALTITUDE = "PRESSURIZATION CABIN ALTITUDE";
        public const string PRESSURIZATION_CABIN_ALTITUDE_GOAL = "PRESSURIZATION CABIN ALTITUDE GOAL";
        public const string PRESSURIZATION_CABIN_ALTITUDE_RATE = "PRESSURIZATION CABIN ALTITUDE RATE";
        public const string PRESSURIZATION_DUMP_SWITCH = "PRESSURIZATION DUMP SWITCH";
        public const string PRESSURIZATION_PRESSURE_DIFFERENTIAL = "PRESSURIZATION PRESSURE DIFFERENTIAL";
        public const string RAD_INS_SWITCH = "RAD INS SWITCH";
        public const string SELECTED_DME = "SELECTED DME";
        public const string SMOKESYSTEM_AVAILABLE = "SMOKESYSTEM AVAILABLE";
        public const string SMOKE_ENABLE = "SMOKE ENABLE";
        public const string SPEAKER_ACTIVE = "SPEAKER ACTIVE";
        public const string STALL_HORN_AVAILABLE = "STALL HORN AVAILABLE";
        public const string STALL_PROTECTION_OFF_LIMIT = "STALL PROTECTION OFF LIMIT";
        public const string STALL_PROTECTION_ON_GOAL = "STALL PROTECTION ON GOAL";
        public const string STALL_PROTECTION_ON_LIMIT = "STALL PROTECTION ON LIMIT";
        public const string STALL_WARNING = "STALL WARNING";
        public const string STRUCTURAL_DEICE_SWITCH = "STRUCTURAL DEICE SWITCH";
        public const string SUCTION_PRESSURE = "SUCTION PRESSURE";
        public const string SYSTEMS_AVAILABLE = "SYSTEMS AVAILABLE";
        public const string TAILHOOK_HANDLE = "TAILHOOK HANDLE";
        public const string TAILHOOK_POSITION = "TAILHOOK POSITION";
        public const string TOW_RELEASE_HANDLE = "TOW RELEASE HANDLE";
        public const string TRUE_AIRSPEED_SELECTED = "TRUE AIRSPEED SELECTED";
        public const string TURN_COORDINATOR_BALL = "TURN COORDINATOR BALL";
        public const string TURN_COORDINATOR_BALL_INV = "TURN COORDINATOR BALL INV";
        public const string TURN_INDICATOR_RATE = "TURN INDICATOR RATE";
        public const string TURN_INDICATOR_SWITCH = "TURN INDICATOR SWITCH";
        public const string WINDSHIELD_DEICE_SWITCH = "WINDSHIELD DEICE SWITCH";
        public const string WISKEY_COMPASS_INDICATION_DEGREES = "WISKEY COMPASS INDICATION DEGREES";
        public const string VARIOMETER_MAC_CREADY_SETTING = "VARIOMETER MAC CREADY SETTING";
        public const string VARIOMETER_NETTO = "VARIOMETER NETTO";
        public const string VARIOMETER_RATE = "VARIOMETER RATE";
        public const string VARIOMETER_SPEED_TO_FLY = "VARIOMETER SPEED TO FLY";
        public const string VARIOMETER_SPEED_TO_FLY_GLIDE_RATIO = "VARIOMETER SPEED TO FLY GLIDE RATIO";
        public const string VARIOMETER_SWITCH = "VARIOMETER SWITCH";
        public const string VARIOMETER_TOTAL_ENERGY = "VARIOMETER TOTAL ENERGY";
        public const string WATER_BALLAST_TANK_CAPACITY__index = "WATER BALLAST TANK CAPACITY:";
        public const string WATER_BALLAST_TANK_NUMBER = "WATER BALLAST TANK NUMBER";
        public const string WATER_BALLAST_TANK_QUANTITY__index = "WATER BALLAST TANK QUANTITY:";
        public const string WATER_BALLAST_VALVE = "WATER BALLAST VALVE";
        public const string WATER_BALLAST_VALVE_FLOW_RATE = "WATER BALLAST VALVE FLOW RATE";
        public const string IS_ANY_INTERIOR_LIGHT_ON = "IS ANY INTERIOR LIGHT ON";
        public const string LANDING_LIGHT_PBH = "LANDING LIGHT PBH";
        public const string LIGHT_BEACON = "LIGHT BEACON";
        public const string LIGHT_BEACON_ON = "LIGHT BEACON ON";
        public const string LIGHT_BACKLIGHT_INTENSITY = "LIGHT BACKLIGHT INTENSITY";
        public const string LIGHT_BRAKE_ON = "LIGHT BRAKE ON";
        public const string LIGHT_CABIN = "LIGHT CABIN";
        public const string LIGHT_CABIN_ON = "LIGHT CABIN ON";
        public const string LIGHT_CABIN_POWER_SETTING = "LIGHT CABIN POWER SETTING";
        public const string LIGHT_GLARESHIELD = "LIGHT GLARESHIELD";
        public const string LIGHT_GLARESHIELD_ON = "LIGHT GLARESHIELD ON";
        public const string LIGHT_GLARESHIELD_POWER_SETTING = "LIGHT GLARESHIELD POWER SETTING";
        public const string LIGHT_GYROLIGHT_INTENSITY = "LIGHT GYROLIGHT INTENSITY";
        public const string LIGHT_HEAD_ON = "LIGHT HEAD ON";
        public const string LIGHT_HEADLIGHT_INTENSITY = "LIGHT HEADLIGHT INTENSITY";
        public const string LIGHT_LANDING_ON = "LIGHT LANDING ON";
        public const string LIGHT_LANDING = "LIGHT LANDING";
        public const string LIGHT_LOGO = "LIGHT LOGO";
        public const string LIGHT_LOGO_ON = "LIGHT LOGO ON";
        public const string LIGHT_NAV_ON = "LIGHT NAV ON";
        public const string LIGHT_NAV = "LIGHT NAV";
        public const string LIGHT_ON_STATES = "LIGHT ON STATES";
        public const string LIGHT_PANEL = "LIGHT PANEL";
        public const string LIGHT_PANEL_ON = "LIGHT PANEL ON";
        public const string LIGHT_PANEL_POWER_SETTING = "LIGHT PANEL POWER SETTING";
        public const string LIGHT_PEDESTRAL = "LIGHT PEDESTRAL";
        public const string LIGHT_PEDESTRAL_ON = "LIGHT PEDESTRAL ON";
        public const string LIGHT_PEDESTRAL_POWER_SETTING = "LIGHT PEDESTRAL POWER SETTING";
        public const string LIGHT_POTENTIOMETER__index = "LIGHT POTENTIOMETER:";
        public const string LIGHT_RECOGNITION = "LIGHT RECOGNITION";
        public const string LIGHT_RECOGNITION_ON = "LIGHT RECOGNITION ON";
        public const string LIGHT_STATES = "LIGHT STATES";
        public const string LIGHT_STROBE = "LIGHT STROBE";
        public const string LIGHT_STROBE_ON = "LIGHT STROBE ON";
        public const string LIGHT_TAXI = "LIGHT TAXI";
        public const string LIGHT_TAXI_ON = "LIGHT TAXI ON";
        public const string LIGHT_WING = "LIGHT WING";
        public const string LIGHT_WING_ON = "LIGHT WING ON";
        public const string MANUAL_INSTRUMENT_LIGHTS = "MANUAL INSTRUMENT LIGHTS";
        public const string STROBES_AVAILABLE = "STROBES AVAILABLE";
        public const string STROBE_FLASH = "STROBE FLASH";
        public const string HYDRAULIC_PRESSURE__index = "HYDRAULIC PRESSURE:";
        public const string HYDRAULIC_RESERVOIR_PERCENT__index = "HYDRAULIC RESERVOIR PERCENT:";
        public const string HYDRAULIC_SWITCH = "HYDRAULIC SWITCH";
        public const string HYDRAULIC_SYSTEM_INTEGRITY = "HYDRAULIC SYSTEM INTEGRITY";
        public const string PARTIAL_PANEL_ADF = "PARTIAL PANEL ADF";
        public const string PARTIAL_PANEL_AIRSPEED = "PARTIAL PANEL AIRSPEED";
        public const string PARTIAL_PANEL_ALTIMETER = "PARTIAL PANEL ALTIMETER";
        public const string PARTIAL_PANEL_ATTITUDE = "PARTIAL PANEL ATTITUDE";
        public const string PARTIAL_PANEL_AVIONICS = "PARTIAL PANEL AVIONICS";
        public const string PARTIAL_PANEL_COMM = "PARTIAL PANEL COMM";
        public const string PARTIAL_PANEL_COMPASS = "PARTIAL PANEL COMPASS";
        public const string PARTIAL_PANEL_ELECTRICAL = "PARTIAL PANEL ELECTRICAL";
        public const string PARTIAL_PANEL_ENGINE = "PARTIAL PANEL ENGINE";
        public const string PARTIAL_PANEL_FUEL_INDICATOR = "PARTIAL PANEL FUEL INDICATOR";
        public const string PARTIAL_PANEL_HEADING = "PARTIAL PANEL HEADING";
        public const string PARTIAL_PANEL_NAV = "PARTIAL PANEL NAV";
        public const string PARTIAL_PANEL_PITOT = "PARTIAL PANEL PITOT";
        public const string PARTIAL_PANEL_TRANSPONDER = "PARTIAL PANEL TRANSPONDER";
        public const string PARTIAL_PANEL_TURN_COORDINATOR = "PARTIAL PANEL TURN COORDINATOR";
        public const string PARTIAL_PANEL_VACUUM = "PARTIAL PANEL VACUUM";
        public const string PARTIAL_PANEL_VERTICAL_VELOCITY = "PARTIAL PANEL VERTICAL VELOCITY";
        public const string DROPPABLE_OBJECTS_COUNT__index = "DROPPABLE OBJECTS COUNT:";
        public const string DROPPABLE_OBJECTS_TYPE__index = "DROPPABLE OBJECTS TYPE:";
        public const string DROPPABLE_OBJECTS_UI_NAME__index = "DROPPABLE OBJECTS UI NAME:";
        public const string PAYLOAD_STATION_COUNT = "PAYLOAD STATION COUNT";
        public const string PAYLOAD_STATION_NAME__index = "PAYLOAD STATION NAME:";
        public const string PAYLOAD_STATION_NUM_SIMOBJECTS__index = "PAYLOAD STATION NUM SIMOBJECTS:";
        public const string PAYLOAD_STATION_OBJECT__index = "PAYLOAD STATION OBJECT:";
        public const string PAYLOAD_STATION_WEIGHT__index = "PAYLOAD STATION WEIGHT:";
        public const string WARNING_FUEL = "WARNING FUEL";
        public const string WARNING_FUEL_LEFT = "WARNING FUEL LEFT";
        public const string WARNING_FUEL_RIGHT = "WARNING FUEL RIGHT";
        public const string WARNING_LOW_HEIGHT = "WARNING LOW HEIGHT";
        public const string WARNING_OIL_PRESSURE = "WARNING OIL PRESSURE";
        public const string WARNING_VACUUM = "WARNING VACUUM";
        public const string WARNING_VACUUM_LEFT = "WARNING VACUUM LEFT";
        public const string WARNING_VACUUM_RIGHT = "WARNING VACUUM RIGHT";
        public const string WARNING_VOLTAGE = "WARNING VOLTAGE";
        public const string YOKE_X_INIDICATOR = "YOKE X INIDICATOR";
        public const string YOKE_X_POSITION = "YOKE X POSITION";
        public const string YOKE_X_POSITION_WITH_AP = "YOKE X POSITION WITH AP";
        public const string YOKE_Y_INIDICATOR = "YOKE Y INIDICATOR";
        public const string YOKE_Y_POSITION = "YOKE Y POSITION";
        public const string YOKE_Y_POSITION_WITH_AP = "YOKE Y POSITION WITH AP";

      }
    }
  }
}
