/* -------------------------------------------------------------------------- */
/*                 BEEQ declarative colors for Tailwind config                */
/* -------------------------------------------------------------------------- */

export const DECLARATIVE_COLORS = {
  bg: {
    primary: 'var(--bq-background--primary)',
    secondary: 'var(--bq-background--secondary)',
    tertiary: 'var(--bq-background--tertiary)',
    alt: 'var(--bq-background--alt)',
    inverse: 'var(--bq-background--inverse)',
    brand: 'var(--bq-background--brand)',
    overlay: 'var(--bq-background--overlay)',
  },
  data: {
    '01': 'var(--bq-data-01)',
    '02': 'var(--bq-data-02)',
    '03': 'var(--bq-data-03)',
    '04': 'var(--bq-data-04)',
    '05': 'var(--bq-data-05)',
    '06': 'var(--bq-data-06)',
    '07': 'var(--bq-data-07)',
    '08': 'var(--bq-data-08)',
    '09': 'var(--bq-data-09)',
    '10': 'var(--bq-data-10)',
    '11': 'var(--bq-data-11)',
    '12': 'var(--bq-data-12)',
  },
  focus: 'var(--bq-focus)',
  icon: {
    primary: 'var(--bq-icon--primary)',
    alt: 'var(--bq-icon--alt)',
    secondary: 'var(--bq-icon--secondary)',
    inverse: 'var(--bq-icon--inverse)',
    brand: 'var(--bq-icon--brand)',
    info: 'var(--bq-icon--info)',
    success: 'var(--bq-icon--success)',
    warning: 'var(--bq-icon--warning)',
    danger: 'var(--bq-icon--danger)',
  },
  state: {
    hover: 'var(--bq-state--hover)',
    active: 'var(--bq-state--active)',
  },
  stroke: {
    primary: 'var(--bq-stroke--primary)',
    secondary: 'var(--bq-stroke--secondary)',
    tertiary: 'var(--bq-stroke--tertiary)',
    inverse: 'var(--bq-stroke--inverse)',
    brand: 'var(--bq-stroke--brand)',
    alt: 'var(--bq-stroke--alt)',
    success: 'var(--bq-stroke--success)',
    warning: 'var(--bq-stroke--warning)',
    danger: 'var(--bq-stroke--danger)',
  },
  text: {
    /** Primary */
    primary: 'var(--bq-text--primary)',
    alt: 'var(--bq-text--alt)',
    /** Secondary */
    secondary: 'var(--bq-text--secondary)',
    /** Inverse */
    inverse: 'var(--bq-text--inverse)',
    /** Brand */
    brand: 'var(--bq-text--brand)',
    /** Feedback */
    info: 'var(--bq-text--info)',
    success: 'var(--bq-text--success)',
    warning: 'var(--bq-text--warning)',
    danger: 'var(--bq-text--danger)',
  },
  ui: {
    primary: 'var(--bq-ui--primary)',
    alt: 'var(--bq-ui--alt)',
    secondary: 'var(--bq-ui--secondary)',
    tertiary: 'var(--bq-ui--tertiary)',
    inverse: 'var(--bq-ui--inverse)',
    brand: 'var(--bq-ui--brand)',
    'brand-alt': 'var(--bq-ui--brand-alt)',
    success: 'var(--bq-ui--success)',
    'success-alt': 'var(--bq-ui--success-alt)',
    warning: 'var(--bq-ui--warning)',
    'warning-alt': 'var(--bq-ui--warning-alt)',
    danger: 'var(--bq-ui--danger)',
    'danger-alt': 'var(--bq-ui--danger-alt)',
  },
};
